/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.OnceRowPipe;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.util.DataSource;

public abstract class AbstractInputTableParameter<T>
extends Parameter<T> {
    private InputFormatParameter formatParam_;
    private BooleanParameter streamParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    private static final String[] KNOWN_PREFIXES = new String[]{"in", "upload", "animate"};

    protected AbstractInputTableParameter(String name, Class<T> clazz) {
        super(name, clazz, true);
        String suffix = "";
        for (String prefix : Arrays.asList(KNOWN_PREFIXES)) {
            if (!name.startsWith(prefix)) continue;
            suffix = name.substring(prefix.length());
            break;
        }
        char labelChar = name.charAt(0);
        this.formatParam_ = new InputFormatParameter(labelChar + "fmt" + suffix);
        this.streamParam_ = new BooleanParameter(labelChar + "stream" + suffix);
        this.streamParam_.setBooleanDefault(false);
        this.setTableDescription("the input table");
    }

    public InputFormatParameter getFormatParameter() {
        return this.formatParam_;
    }

    public BooleanParameter getStreamParameter() {
        return this.streamParam_;
    }

    public final void setTableDescription(String inDescrip) {
        this.setDescription(new String[]{"<p>The location of " + inDescrip + ".", "This may take one of the following forms:", AbstractInputTableParameter.getLocationFormList(this.formatParam_), "In any case, compressed data in one of the supported compression", "formats (gzip, Unix compress or bzip2) will be decompressed", "transparently.", "</p>"});
        this.streamParam_.setDescription(new String[]{"<p>If set true, " + inDescrip, "specified by the <code>" + this.getName() + "</code> parameter", "will be read as a stream.", "It is necessary to give the ", "<code>" + this.formatParam_.getName() + "</code> parameter", "in this case.", "Depending on the required operations and processing mode,", "this may cause the read to fail (sometimes it is necessary", "to read the table more than once).", "It is not normally necessary to set this flag;", "in most cases the data will be streamed automatically", "if that is the best thing to do.", "However it can sometimes result in less resource usage when", "processing large files in certain formats (such as VOTable).", "</p>"});
        this.formatParam_.setTableDescription(inDescrip, this);
    }

    protected StarTable makeTable(Environment env, String loc) throws TaskException {
        String fmt = this.formatParam_.stringValue(env);
        boolean stream = this.streamParam_.booleanValue(env);
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        try {
            if (loc.equals("-")) {
                BufferedInputStream in = new BufferedInputStream(DataSource.getInputStream((String)loc));
                return this.getStreamedTable(tfact, in, fmt, null);
            }
            if (stream) {
                return this.getStreamedTable(tfact, DataSource.makeDataSource((String)loc), fmt);
            }
            return tfact.makeStarTable(loc, fmt);
        }
        catch (EOFException e) {
            throw new ExecutionException("Premature end of file", (Throwable)e);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                msg = e.toString();
            }
            throw new ExecutionException(msg, (Throwable)e);
        }
    }

    protected StarTable[] makeTables(Environment env, String loc) throws TaskException {
        String fmt = this.formatParam_.stringValue(env);
        boolean stream = this.streamParam_.booleanValue(env);
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        String streamWarning = "Can't currently stream multiple tables (would need MultiTableBuilder.streamTables method)";
        try {
            if (loc.equals("-")) {
                logger_.warning(streamWarning);
                BufferedInputStream in = new BufferedInputStream(DataSource.getInputStream((String)loc));
                return new StarTable[]{this.getStreamedTable(tfact, in, fmt, null)};
            }
            if (this.streamParam_.booleanValue(env)) {
                logger_.warning(streamWarning);
            }
            DataSource datsrc = DataSource.makeDataSource((String)loc);
            return Tables.tableArray((TableSequence)tfact.makeStarTables(datsrc, fmt));
        }
        catch (EOFException e) {
            throw new ExecutionException("Premature end of file", (Throwable)e);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null || msg.trim().length() == 0) {
                msg = e.toString();
            }
            throw new ExecutionException(msg, (Throwable)e);
        }
    }

    private StarTable getStreamedTable(StarTableFactory tfact, final InputStream in, String inFmt, final String pos) throws IOException, TaskException {
        if (inFmt == null || inFmt.equals("(auto)")) {
            String msg = "Must specify input format for streamed table";
            throw new ParameterValueException((Parameter)this.formatParam_, msg);
        }
        final TableBuilder tbuilder = tfact.getTableBuilder(inFmt);
        assert (tbuilder != null);
        final OnceRowPipe streamStore = new OnceRowPipe(1024);
        Thread streamer = new Thread("Table Streamer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    tbuilder.streamStarTable(in, (TableSink)streamStore, pos);
                }
                catch (IOException e) {
                    streamStore.setError(e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        streamer.setDaemon(true);
        streamer.start();
        return streamStore.waitForStarTable();
    }

    private StarTable getStreamedTable(final StarTableFactory tfact, final DataSource datsrc, final String inFmt) throws IOException, TaskException {
        BufferedInputStream in1 = new BufferedInputStream(datsrc.getInputStream());
        final String pos = datsrc.getPosition();
        StarTable t1 = this.getStreamedTable(tfact, in1, inFmt, pos);
        return new WrapperStarTable(t1){

            public RowSequence getRowSequence() throws IOException {
                try {
                    return super.getRowSequence();
                }
                catch (UnrepeatableSequenceException e) {
                    StarTable t2;
                    BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
                    try {
                        t2 = AbstractInputTableParameter.this.getStreamedTable(tfact, in, inFmt, pos);
                    }
                    catch (TaskException e1) {
                        throw new AssertionError((Object)e1);
                    }
                    return t2.getRowSequence();
                }
            }
        };
    }

    public static String getLocationFormList(InputFormatParameter fmtParam) {
        return DocUtils.join(new String[]{"<ul>", "<li>A filename.</li>", "<li>A URL.</li>", "<li>The special value \"<code>-</code>\",", "    meaning standard input.", "    In this case the input format must be given explicitly", "    using the <code>" + fmtParam.getName() + "</code>", "    parameter.", "    Note that not all formats can be streamed in this way.</li>", "<li>A system command line with", "    either a \"<code>&lt;</code>\" character at the start,", "    or a \"<code>|</code>\" character at the end", "    (\"<code>&lt;syscmd</code>\" or", "     \"<code>syscmd|</code>\").", "    This executes the given pipeline and reads from its", "    standard output.", "    This will probably only work on unix-like systems.</li>", "</ul>"});
    }
}

