/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class AddEnvironment
implements Environment {
    private final Environment baseEnv_;
    private final Map<String, String> addMap_;

    public AddEnvironment(Environment baseEnv, Map<String, String> addMap) {
        this.baseEnv_ = baseEnv;
        this.addMap_ = addMap;
    }

    public void acquireValue(Parameter par) throws TaskException {
        String name = par.getName();
        if (this.addMap_.containsKey(name)) {
            par.setValueFromString((Environment)this, this.addMap_.get(name));
        } else {
            this.baseEnv_.acquireValue(par);
        }
    }

    public void clearValue(Parameter par) {
        String name = par.getName();
        if (this.addMap_.containsKey(name)) {
            this.addMap_.remove(name);
        } else {
            this.baseEnv_.clearValue(par);
        }
    }

    public String[] getNames() {
        LinkedHashMap names = new LinkedHashMap();
        String[] baseNames = this.baseEnv_.getNames();
        for (int i = 0; i < baseNames.length; ++i) {
            names.put(baseNames[i], null);
        }
        for (String addName : this.addMap_.keySet()) {
            names.put(addName, null);
        }
        return names.keySet().toArray(new String[0]);
    }

    public PrintStream getOutputStream() {
        return this.baseEnv_.getOutputStream();
    }

    public PrintStream getErrorStream() {
        return this.baseEnv_.getErrorStream();
    }

    public static AddEnvironment createAddEnvironment(Environment baseEnv, Map<String, String> addMap) {
        if (baseEnv instanceof TableEnvironment) {
            final TableEnvironment tEnv = (TableEnvironment)baseEnv;
            return new AddEnvironment(baseEnv, addMap){

                public JDBCAuthenticator getJdbcAuthenticator() {
                    return tEnv.getJdbcAuthenticator();
                }

                public StarTableFactory getTableFactory() {
                    return tEnv.getTableFactory();
                }

                public StarTableOutput getTableOutput() {
                    return tEnv.getTableOutput();
                }

                public boolean isDebug() {
                    return tEnv.isDebug();
                }

                public boolean isStrictVotable() {
                    return tEnv.isStrictVotable();
                }

                public void setDebug(boolean debug) {
                    tEnv.setDebug(debug);
                }

                public void setStrictVotable(boolean strict) {
                    tEnv.setStrictVotable(strict);
                }
            };
        }
        return new AddEnvironment(baseEnv, addMap);
    }
}

