/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;

public class ConnectionParameter
extends Parameter<Connection> {
    private final StringParameter userParam_;
    private final StringParameter passParam_;

    public ConnectionParameter(String name) {
        super(name, Connection.class, true);
        this.setPrompt("JDBC-type URL for database connection");
        this.setUsage("<jdbc-url>");
        this.setDescription(new String[]{"<p>URL which defines a connection to a database.", "This has the form ", "<code>jdbc:&lt;subprotocol&gt;:&lt;subname&gt;</code>", "- the details are database- and driver-dependent.", "Consult Sun's JDBC documentation and that for the particular", "JDBC driver you are using for details.", "Note that the relevant driver class will need to be on your", "classpath and referenced in the <code>jdbc.drivers</code>", "system property as well for the connection to be made.", "</p>"});
        this.userParam_ = new StringParameter("user");
        this.userParam_.setPrompt("User name for database connection");
        try {
            Properties props = System.getProperties();
            if (props.containsKey("user.name")) {
                this.userParam_.setStringDefault(props.getProperty("user.name"));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.userParam_.setNullPermitted(true);
        this.userParam_.setDescription(new String[]{"<p>User name for logging in to SQL database.", "Defaults to the current username.", "</p>"});
        this.passParam_ = new StringParameter("password");
        this.passParam_.setPrompt("Password for database connection");
        this.passParam_.setNullPermitted(true);
        this.passParam_.setPreferExplicit(true);
        this.passParam_.setDescription(new String[]{"<p>Password for logging in to SQL database.", "</p>"});
    }

    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.userParam_, this.passParam_};
    }

    public Connection stringToObject(Environment env, String stringValue) throws TaskException {
        if (!stringValue.startsWith("jdbc:")) {
            String msg = "Must be of form \"jdbc:<subprotocol>:<subname>\"";
            throw new ParameterValueException((Parameter)this, msg);
        }
        String user = this.userParam_.stringValue(env);
        String pass = this.passParam_.stringValue(env);
        try {
            return DriverManager.getConnection(stringValue, user, pass);
        }
        catch (SQLException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
    }

    public String objectToString(Environment env, Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName() + ":" + connection.getCatalog();
        }
        catch (SQLException e) {
            return "JDBC";
        }
    }
}

