/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;

public class DoubleArrayParameter
extends Parameter<double[]> {
    private final int count_;

    public DoubleArrayParameter(String name, int count) {
        super(name, double[].class, false);
        this.count_ = count;
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sbuf.append(",");
            }
            sbuf.append("<num>");
        }
        this.setUsage(sbuf.toString());
    }

    public double[] doublesValue(Environment env) throws TaskException {
        return (double[])this.objectValue(env);
    }

    public float[] floatsValue(Environment env) throws TaskException {
        double[] dvals = (double[])this.objectValue(env);
        if (dvals == null) {
            return null;
        }
        float[] fvals = new float[dvals.length];
        for (int i = 0; i < dvals.length; ++i) {
            fvals[i] = (float)dvals[i];
        }
        return fvals;
    }

    public double[] stringToObject(Environment env, String stringval) throws TaskException {
        String[] svals = stringval.split(",");
        if (svals.length != this.count_) {
            String msg = "Not " + this.count_ + " comma-separated values";
            throw new ParameterValueException((Parameter)this, msg);
        }
        double[] dvals = new double[this.count_];
        for (int i = 0; i < this.count_; ++i) {
            String sv = svals[i].trim();
            try {
                dvals[i] = Double.parseDouble(sv);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParameterValueException((Parameter)this, "Not numeric: " + sv);
            }
        }
        return dvals;
    }

    public String objectToString(Environment env, double[] dvals) throws TaskException {
        if (dvals == null) {
            return null;
        }
        if (dvals.length != this.count_) {
            throw new TaskException("Wrong length");
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.count_; ++i) {
            if (i > 0) {
                sbuf.append(",");
            }
            sbuf.append(dvals[i]);
        }
        return sbuf.toString();
    }
}

