/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.StepFactory;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class FilterParameter
extends Parameter<ProcessingStep[]>
implements ExtraParameter,
MultiParameter {
    public FilterParameter(String name) {
        super(name, ProcessingStep[].class, true);
        this.setUsage("<cmds>");
        this.setNullPermitted(true);
        this.setTableDescription("the table", null, null);
    }

    public final void setTableDescription(String shortDescrip, AbstractInputTableParameter tableParam, Boolean isBefore) {
        this.setPrompt("Processing command(s) for " + shortDescrip);
        StringBuffer dbuf = new StringBuffer();
        dbuf.append(shortDescrip);
        if (tableParam != null) {
            dbuf.append(" as specified by parameter <code>").append(tableParam.getName()).append("</code>");
        }
        String longDescrip = dbuf.toString();
        StringBuffer seqBuf = new StringBuffer();
        if (isBefore != null) {
            seqBuf.append(",\n").append(isBefore != false ? "before any" : "after all").append(" other processing has taken place");
        }
        String seqTxt = seqBuf.toString();
        String indir = String.valueOf('@');
        this.setDescription(new String[]{"<p>Specifies processing to be performed on", longDescrip + seqTxt + ".", "The value of this parameter is one or more of the filter", "commands described in <ref id=\"filterSteps\"/>.", "If more than one is given, they must be separated by", "semicolon characters (\";\").", "This parameter can be repeated multiple times on the same", "command line to build up a list of processing steps.", "The sequence of commands given in this way", "defines the processing pipeline which is performed on the table.", "</p>", "<p>Commands may alteratively be supplied in an external file,", "by using the indirection character '" + indir + "'.", "Thus a value of \"<code>" + indir + "filename</code>\"", "causes the file <code>filename</code> to be read for a list", "of filter commands to execute.  The commands in the file", "may be separated by newline characters and/or semicolons.", "</p>"});
    }

    public char getValueSeparator() {
        return ';';
    }

    public ProcessingStep[] stringToObject(Environment env, String sval) throws TaskException {
        return StepFactory.getInstance().createSteps(sval);
    }

    public ProcessingStep[] stepsValue(Environment env) throws TaskException {
        ProcessingStep[] steps = (ProcessingStep[])this.objectValue(env);
        return env == null || steps == null ? new ProcessingStep[]{} : steps;
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        return FilterParameter.getFiltersUsage(env);
    }

    public static String getFiltersUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer().append("   Known filter commands:\n");
        ObjectFactory<ProcessingFilter> filterFactory = StepFactory.getInstance().getFilterFactory();
        String[] fnames = filterFactory.getNickNames();
        for (int i = 0; i < fnames.length; ++i) {
            String fname = fnames[i];
            try {
                ProcessingFilter filter = (ProcessingFilter)filterFactory.createObject(fname);
                String fusage = filter.getUsage();
                sbuf.append("      ").append(fname);
                String pad = ("      " + fname).replaceAll(".", " ");
                if (fusage != null) {
                    sbuf.append(' ').append(fusage.replaceAll("\n", "\n " + pad));
                }
                sbuf.append('\n');
                continue;
            }
            catch (LoadException e) {
                if (!env.isDebug()) continue;
                sbuf.append("    ( ").append(fname).append(" - not available: ").append((Object)e).append(" )\n");
            }
        }
        sbuf.append("\n").append("   Commands can be separated on one line using ").append("semicolons (;).\n").append("   Arguments containing spaces should be ").append("'quoted' or \"quoted\".\n");
        return sbuf.toString();
    }
}

