/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.awt.Component;
import java.awt.Dimension;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.LineWord;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.task.DynamicTask;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.util.gui.MemoryMonitor;

public class LineInvoker {
    private final String toolName_;
    private final ObjectFactory<Task> taskFactory_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools");

    public LineInvoker(String toolName, ObjectFactory<Task> taskFactory) {
        this.toolName_ = toolName;
        this.taskFactory_ = taskFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int invoke(String[] args) {
        String arg;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        LineTableEnvironment env = new LineTableEnvironment();
        int verbosity = 0;
        boolean bench = false;
        boolean memgui = false;
        boolean allowunused = false;
        PrintStream out = System.out;
        PrintStream err = System.err;
        Iterator it = argList.iterator();
        while (it.hasNext() && ((arg = (String)it.next()).startsWith("-") || arg.startsWith("+"))) {
            if (arg.equals("-help") || arg.equals("-h")) {
                it.remove();
                String topic = it.hasNext() ? (String)it.next() : null;
                out.println("\n" + this.getUsage(topic));
                return 0;
            }
            if (arg.equals("-version")) {
                it.remove();
                String[] lines = new String[]{"", "This is STILTS, the STIL Tool Set", "", "STILTS version " + Stilts.getVersion(), "STIL version " + IOUtils.getResourceContents(StarTable.class, (String)"stil.version", null), "Starjava revision: " + Stilts.getStarjavaRevision(), "JVM: " + InvokeUtils.getJavaVM(), "", "Author: Mark Taylor", "WWW: http://www.starlink.ac.uk/stilts/", ""};
                int il = 0;
                while (il < lines.length) {
                    String line = lines[il];
                    if (line.length() > 0) {
                        out.print("    ");
                    }
                    out.println(line);
                    ++il;
                }
                return 0;
            }
            if (arg.equals("-verbose")) {
                it.remove();
                ++verbosity;
                continue;
            }
            if (arg.equals("+verbose")) {
                it.remove();
                --verbosity;
                continue;
            }
            if (arg.equals("-memory")) {
                it.remove();
                StoragePolicy.setDefaultPolicy((StoragePolicy)StoragePolicy.PREFER_MEMORY);
                env.getTableFactory().setStoragePolicy(StoragePolicy.PREFER_MEMORY);
                continue;
            }
            if (arg.equals("-disk")) {
                it.remove();
                StoragePolicy.setDefaultPolicy((StoragePolicy)StoragePolicy.PREFER_DISK);
                env.getTableFactory().setStoragePolicy(StoragePolicy.PREFER_DISK);
                continue;
            }
            if (arg.equals("-votstrict")) {
                it.remove();
                env.setStrictVotable(true);
                continue;
            }
            if (arg.equals("-novotstrict")) {
                it.remove();
                env.setStrictVotable(false);
                continue;
            }
            if (arg.equals("-batch")) {
                it.remove();
                env.setInteractive(false);
                continue;
            }
            if (arg.equals("-prompt")) {
                it.remove();
                env.setPromptAll(true);
                continue;
            }
            if (arg.equals("-debug")) {
                it.remove();
                env.setDebug(true);
                continue;
            }
            if (arg.equals("-bench")) {
                it.remove();
                bench = true;
                continue;
            }
            if (arg.equals("-memgui")) {
                it.remove();
                memgui = true;
                continue;
            }
            if (arg.equals("-allowunused")) {
                it.remove();
                allowunused = true;
                continue;
            }
            if (arg.equals("-noallowunused")) {
                it.remove();
                allowunused = false;
                continue;
            }
            if (arg.equals("-checkversion") && it.hasNext()) {
                it.remove();
                String vers = (String)it.next();
                it.remove();
                if (vers.equals(Stilts.getVersion())) continue;
                err.println("Version mismatch: " + Stilts.getVersion() + " != " + vers);
                return 1;
            }
            if (arg.equals("-stdout") && it.hasNext()) {
                it.remove();
                String outName = (String)it.next();
                it.remove();
                if (outName == null || outName.trim().length() == 0 || "-".equals(outName)) {
                    out = System.out;
                    continue;
                }
                try {
                    out = new PrintStream(new FileOutputStream(outName));
                    continue;
                }
                catch (IOException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(err);
                        return 1;
                    }
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    err.println("\n" + msg + "\n");
                    return 1;
                }
            }
            if (arg.equals("-stderr") && it.hasNext()) {
                it.remove();
                String errName = (String)it.next();
                it.remove();
                if (errName == null || errName.trim().length() == 0 || "=".equals(errName)) {
                    err = System.err;
                    continue;
                }
                try {
                    err = new PrintStream(new FileOutputStream(errName));
                    continue;
                }
                catch (IOException e) {
                    if (env.isDebug()) {
                        e.printStackTrace(err);
                        return 1;
                    }
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    err.println("\n" + msg + "\n");
                    return 1;
                }
            }
            it.remove();
            err.println("\n" + this.getUsage());
            return 1;
        }
        if (argList.size() == 0) {
            err.println("\n" + this.getUsage());
            return 1;
        }
        env.setOutputStream(out);
        env.setErrorStream(err);
        InvokeUtils.configureLogging((int)verbosity, (boolean)env.isDebug());
        String taskName = (String)argList.remove(0);
        if (!this.taskFactory_.isRegistered(taskName)) {
            err.println("\nNo such task: " + taskName);
            err.println("\n" + this.getUsage());
            err.flush();
            return 1;
        }
        Task task = null;
        try {
            task = (Task)this.taskFactory_.createObject(taskName);
            String[] taskArgs = argList.toArray(new String[0]);
            LineWord[] words = new LineWord[taskArgs.length];
            for (int i = 0; i < taskArgs.length; ++i) {
                words[i] = new LineWord(taskArgs[i]);
            }
            env.setWords(words);
            String helpText = this.helpMessage(env, task, taskName, taskArgs);
            if (helpText != null) {
                out.println("\n" + helpText);
                int n = 0;
                return n;
            }
            long start = System.currentTimeMillis();
            Executable exec = task.createExecutable((Environment)env);
            String[] unused = env.getUnused();
            if (unused.length > 0) {
                this.logParameterValues(taskName, env);
                if (!allowunused) {
                    err.println("\n" + LineInvoker.getUnusedWarning(unused));
                    err.println(LineInvoker.getTaskUsage(task, taskName));
                    int n = 1;
                    return n;
                }
                logger_.warning(LineInvoker.getUnusedWarning(unused));
            } else {
                this.logParameterValues(taskName, env);
            }
            JFrame monwin = memgui ? LineInvoker.startMemoryMonitor("STILTS") : null;
            exec.execute();
            if (monwin != null) {
                monwin.dispose();
            }
            if (bench) {
                long millis = System.currentTimeMillis() - start;
                String secs = Float.toString((float)(millis / 100L) * 0.1f);
                err.println("Elapsed time: " + secs + "s");
            }
            int n = 0;
            return n;
        }
        catch (TaskException e) {
            this.reportError(env, e);
            if (e instanceof ParameterValueException && task != null) {
                Parameter param = ((ParameterValueException)e).getParameter();
                try {
                    err.println("Value was: " + param.getName() + "=\"" + param.stringValue((Environment)env) + "\"");
                }
                catch (TaskException e2) {
                    // empty catch block
                }
                err.println("Usage: " + param.getName() + "=" + param.getUsage());
                err.println();
            } else if (e instanceof UsageException && task != null) {
                err.println(LineInvoker.getTaskUsage(task, taskName));
            }
            int param = 1;
            return param;
        }
        catch (IllegalArgumentException e) {
            this.reportError(env, e);
            int param = 1;
            return param;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            int param = 1;
            return param;
        }
        catch (IOException e) {
            this.reportError(env, e);
            int param = 1;
            return param;
        }
        catch (LoadException e) {
            err.println("Task " + taskName + " not available");
            if (e.getMessage() != null) {
                err.println(e.getMessage() + "\n");
            }
            if (env.isDebug()) {
                e.printStackTrace(err);
            }
            int param = 1;
            return param;
        }
        catch (OutOfMemoryError e) {
            err.println("\nOut of memory");
            if (e.getMessage() != null) {
                err.println(e.getMessage());
            }
            if (env.getTableFactory().getStoragePolicy() != StoragePolicy.PREFER_DISK) {
                err.println("Try \"-disk\" flag?\n");
            } else {
                err.println("Try increasing heap memory (-Xmx flag)\n");
            }
            if (env.isDebug()) {
                e.printStackTrace(err);
            }
            int param = 1;
            return param;
        }
        catch (NoClassDefFoundError e) {
            this.reportError(env, e);
            if (env.isDebug()) {
                e.printStackTrace(err);
            }
            try {
                String msg = new StringBuffer().append("\n").append(e).append("\n").append("The runtime Java Runtime Environment (JRE) ").append("is missing some compile-time classes.\n").append("The most likely reason is that you are ").append("using an incomplete java such as GNU gcj.\n").append("The JVM you are using is ").append(System.getProperty("java.vm.name", "unknown")).append(" version ").append(System.getProperty("java.vm.version", "?")).append(".\n").append("The recommended JRE is Sun's J2SE ").append("version 1.5 or greater.\n").toString();
                err.println(msg);
            }
            catch (Throwable e1) {
                e1.printStackTrace(err);
            }
            int n = 1;
            return n;
        }
        finally {
            out.flush();
            err.flush();
        }
    }

    private void logParameterValues(String taskName, LineTableEnvironment env) {
        StringBuffer sbuf = new StringBuffer(taskName);
        String[] words = env.getAssignments();
        for (int i = 0; i < words.length; ++i) {
            sbuf.append(' ').append(words[i]);
        }
        logger_.info(sbuf.toString());
    }

    private String helpMessage(LineTableEnvironment env, Task task, String taskName, String[] taskArgs) throws TaskException {
        for (int i = 0; i < taskArgs.length; ++i) {
            Parameter param;
            String arg = taskArgs[i];
            String helpFor = null;
            if (arg.equals("-help") || arg.equals("-h") || arg.equalsIgnoreCase("help")) {
                return LineInvoker.getTaskUsage(env, task, taskName);
            }
            if (arg.toLowerCase().startsWith("-help=")) {
                helpFor = arg.substring(6).trim().toLowerCase();
            } else if (arg.toLowerCase().startsWith("help=")) {
                helpFor = arg.substring(5).trim().toLowerCase();
            } else if (arg.length() > 2 && arg.endsWith("=?")) {
                helpFor = arg.substring(0, arg.length() - 2);
            }
            if ("*".equals(helpFor)) {
                Parameter[] params = task.getParameters();
                StringBuffer sbuf = new StringBuffer();
                for (int j = 0; j < params.length; ++j) {
                    sbuf.append(LineInvoker.getParamHelp(env, taskName, params[j]));
                    sbuf.append('\n');
                }
                return sbuf.toString();
            }
            if (helpFor == null) continue;
            Parameter[] params = task.getParameters();
            for (int j = 0; j < params.length; ++j) {
                Parameter param2 = params[j];
                if (!env.paramNameMatches(helpFor, param2)) continue;
                return LineInvoker.getParamHelp(env, taskName, param2);
            }
            if (task instanceof DynamicTask && (param = ((DynamicTask)task).getParameterByName(env, helpFor)) != null) {
                return LineInvoker.getParamHelp(env, taskName, param);
            }
            String stripper = new StringBuffer().append('(').append("N").append('|').append("S").append('|').append("").append(')').append('*').append('$').toString();
            for (int j = 0; j < params.length; ++j) {
                Parameter param3 = params[j];
                String pname = param3.getName().replaceFirst(stripper, "");
                if (!LineTableEnvironment.normaliseName(helpFor).equals(LineTableEnvironment.normaliseName(pname))) continue;
                return LineInvoker.getParamHelp(env, taskName, param3);
            }
            return "No help for parameter: " + helpFor + "\n\n" + LineInvoker.getTaskUsage(task, taskName);
        }
        return null;
    }

    private String getUsage(String topic) {
        if (topic != null) {
            try {
                Task task = (Task)this.taskFactory_.createObject(topic);
                return LineInvoker.getTaskUsage(task, topic);
            }
            catch (LoadException loadException) {
                // empty catch block
            }
        }
        return this.getUsage();
    }

    private void reportError(TableEnvironment env, Throwable e) {
        if (env.isDebug()) {
            e.printStackTrace(env.getErrorStream());
        } else {
            env.getErrorStream().println(LineInvoker.getStackSummary(e));
        }
    }

    public static String getStackSummary(Throwable error) {
        ArrayList<String> msgList = new ArrayList<String>();
        for (Throwable e = error; e != null; e = e.getCause()) {
            int nm;
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            if ((nm = msgList.size()) != 0 && msg.equals(msgList.get(nm - 1))) continue;
            msgList.add(msg);
        }
        String[] msgs = msgList.toArray(new String[0]);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Error: ");
        for (int im = 0; im < msgs.length; ++im) {
            if (im > 0) {
                sbuf.append('\n');
                for (int j = 0; j < im; ++j) {
                    sbuf.append("    ");
                }
                sbuf.append('(');
            }
            sbuf.append(msgs[im]);
        }
        for (int j = 1; j < msgs.length; ++j) {
            sbuf.append(')');
        }
        return sbuf.toString();
    }

    private String getUsage() {
        StringBuffer sbuf = new StringBuffer().append("Usage:\n");
        String pad1 = "   ";
        String pad = (pad1 + this.toolName_).replaceAll(".", " ");
        sbuf.append(pad1).append(this.toolName_).append(" [-help]").append(" [-version]").append(" [-verbose]").append(" [-allowunused]").append(" [-prompt]").append(" [-bench]").append('\n').append(pad).append(" [-debug]").append(" [-batch]").append(" [-memory]").append(" [-disk]").append(" [-memgui]").append('\n').append(pad).append(" [-checkversion <vers>]").append(" [-stdout <file>]").append(" [-stderr <file>]").append('\n').append(pad).append(" <task-name> <task-args>").append('\n').append('\n');
        sbuf.append(pad1).append(this.toolName_).append(" <task-name> help[=<param-name>|*]").append('\n').append('\n');
        sbuf.append("   Known tasks:\n");
        String[] tasks = this.taskFactory_.getNickNames();
        for (int i = 0; i < tasks.length; ++i) {
            sbuf.append("      ").append(tasks[i]).append('\n');
        }
        return sbuf.toString();
    }

    private static String getTaskUsage(Task task, String taskName) {
        try {
            return LineInvoker.getTaskUsage(null, task, taskName);
        }
        catch (TaskException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String getTaskUsage(Environment env, Task task, String taskName) throws TaskException {
        Parameter[] params = task instanceof DynamicTask && env != null ? ((DynamicTask)task).getContextParameters(env) : task.getParameters();
        return LineInvoker.getPrefixedParameterUsage(params, "Usage: " + taskName);
    }

    public static String getPrefixedParameterUsage(Parameter[] params, String prefix) {
        ArrayList namedWords = new ArrayList();
        ArrayList<String> numberedWords = new ArrayList<String>();
        int iPos = 0;
        for (int i = 0; i < params.length; ++i) {
            StringBuffer word = new StringBuffer();
            word.append(' ');
            Parameter param = params[i];
            int pos = param.getPosition();
            boolean byPos = false;
            if (param.getPosition() > 0) {
                if (pos == ++iPos) {
                    byPos = true;
                } else {
                    logger_.warning("Parameter positions out of sync for " + param);
                }
            }
            if (byPos) {
                word.append('[');
            }
            word.append(param.getName()).append('=');
            if (byPos) {
                word.append(']');
            }
            word.append(param.getUsage());
            (byPos ? numberedWords : namedWords).add(word.toString());
        }
        StringBuffer usage = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append(prefix);
        String pad = line.toString().replaceAll(".", " ");
        if (namedWords.size() > 0) {
            for (String word : namedWords) {
                if (line.length() + word.length() > 78) {
                    usage.append(line).append('\n');
                    line = new StringBuffer(pad);
                }
                line.append(word);
            }
            usage.append(line).append('\n');
            line = new StringBuffer(pad);
        }
        if (numberedWords.size() > 0) {
            for (String word : numberedWords) {
                if (line.length() + word.length() > 78) {
                    usage.append(line).append('\n');
                    line = new StringBuffer(pad);
                }
                line.append(word);
            }
            usage.append(line).append('\n');
            line = new StringBuffer(pad);
        }
        if (line.toString().trim().length() > 0) {
            usage.append(line).append('\n');
        }
        return usage.toString();
    }

    public static String getParamHelp(TableEnvironment env, String taskName, Parameter param) {
        boolean byPos = param.getPosition() > 0;
        boolean isOptional = param.getStringDefault() != null || param.isNullPermitted();
        StringBuffer sbuf = new StringBuffer();
        if (taskName != null) {
            sbuf.append("Help for parameter ").append(param.getName().toUpperCase()).append(" in task ").append(taskName.toUpperCase()).append('\n').append(sbuf.toString().replaceAll(".", "-"));
        }
        sbuf.append("\n   Name:\n").append("      ").append(param.getName()).append("\n\n   Usage:\n").append("      ").append(isOptional ? "[" : "").append(byPos ? "[" : "").append(param.getName()).append('=').append(byPos ? "]" : "").append(param.getUsage()).append(isOptional ? "]" : "").append("\n\n   Summary:\n").append("      ").append(param.getPrompt()).append("\n\n   Description:\n");
        try {
            sbuf.append(new Formatter().formatXML(param.getDescription(), 6));
        }
        catch (SAXException e) {
            sbuf.append("      ???");
        }
        Class clazz = param.getValueClass();
        String clazzName = clazz.getCanonicalName();
        String javaPrefix = "java.lang.";
        String clazzAbbrev = clazzName.startsWith(javaPrefix) ? clazzName.substring(javaPrefix.length()) : clazzName;
        sbuf.append("\n\n   Type:\n").append("      ").append(clazzAbbrev);
        if (param.getStringDefault() != null || param.isNullPermitted()) {
            sbuf.append("\n\n   Default:\n").append("      ").append(param.getStringDefault());
        }
        if (param instanceof ExtraParameter) {
            sbuf.append("\n\n").append(((ExtraParameter)param).getExtraUsage(env));
        }
        sbuf.append('\n');
        return sbuf.toString();
    }

    public static String getUnusedWarning(String[] unused) {
        StringBuffer sbuf = new StringBuffer("Unused arguments:");
        for (int i = 0; i < unused.length; ++i) {
            sbuf.append(' ').append(unused[i]);
        }
        sbuf.append('\n');
        return sbuf.toString();
    }

    private static JFrame startMemoryMonitor(String title) {
        JFrame frame = new JFrame(title);
        MemoryMonitor memmon = new MemoryMonitor();
        memmon.setPreferredSize(new Dimension(200, 24));
        frame.getContentPane().add((Component)memmon);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }
}

