/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;

public class LoopStarTable
extends ColumnStarTable {
    private final long nrow_;

    public LoopStarTable(String colName, final double start, double end, final double step, Boolean isInteger) {
        ColumnData colData;
        long nrow;
        boolean isInt = isInteger == null ? start == (double)((int)start) && end == (double)((int)end) && step == (double)((int)step) : isInteger;
        String descrip = "Loop variable";
        if (isInt) {
            nrow = ((long)end - (long)start) / (long)step;
            colData = new ColumnData(new ColumnInfo(colName, Integer.class, descrip)){

                public Object readValue(long irow) {
                    return new Integer((int)(start + (double)irow * step));
                }
            };
        } else {
            nrow = (long)Math.floor((end - start) / step);
            colData = new ColumnData(new ColumnInfo(colName, Double.class, descrip)){

                public Object readValue(long irow) {
                    return new Double(start + (double)irow * step);
                }
            };
        }
        this.nrow_ = Math.max(0L, nrow);
        this.addColumn(colData);
    }

    public long getRowCount() {
        return this.nrow_;
    }
}

