/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.MultiOutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;

public abstract class MultiOutputTask
implements Task {
    private final String purpose_;
    private final List<Parameter> paramList_;
    private final OutputStreamParameter outParam_;
    private final OutputFormatParameter ofmtParam_;

    protected MultiOutputTask(String purpose) {
        this.purpose_ = purpose;
        this.paramList_ = new ArrayList<Parameter>();
        this.outParam_ = new OutputStreamParameter("out");
        this.paramList_.add((Parameter)this.outParam_);
        this.ofmtParam_ = new MultiOutputFormatParameter("ofmt");
        this.paramList_.add((Parameter)this.ofmtParam_);
    }

    public String getPurpose() {
        return this.purpose_;
    }

    public Parameter[] getParameters() {
        return this.paramList_.toArray(new Parameter[0]);
    }

    protected List<Parameter> getParameterList() {
        return this.paramList_;
    }

    protected abstract TableSequence createTableSequence(Environment var1) throws TaskException;

    public Executable createExecutable(Environment env) throws TaskException {
        StarTableWriter writer;
        final TableSequence tseq = this.createTableSequence(env);
        final String loc = this.outParam_.stringValue(env);
        String ofmt = this.ofmtParam_.stringValue(env);
        final StarTableOutput sto = LineTableEnvironment.getTableOutput(env);
        try {
            writer = sto.getHandler(ofmt, loc);
        }
        catch (TableFormatException e) {
            String msg = "Unknown output format";
            throw new ParameterValueException((Parameter)this.ofmtParam_, msg, (Throwable)e);
        }
        if (!(writer instanceof MultiStarTableWriter)) {
            String msg = "Format " + ofmt + " can't write multiple tables";
            throw new ParameterValueException((Parameter)this.ofmtParam_, msg);
        }
        final MultiStarTableWriter multiWriter = (MultiStarTableWriter)writer;
        return new Executable(){

            public void execute() throws IOException {
                multiWriter.writeStarTables(tseq, loc, sto);
            }
        };
    }

    public static TableSequence createTableSequence(InputTableSpec[] inSpecs) throws TaskException {
        final Iterator<InputTableSpec> it = Arrays.asList(inSpecs).iterator();
        return new TableSequence(){
            private int index;

            public StarTable nextTable() throws IOException {
                if (it.hasNext()) {
                    ++this.index;
                    InputTableSpec inSpec = (InputTableSpec)it.next();
                    try {
                        return inSpec.getWrappedTable();
                    }
                    catch (TaskException e) {
                        throw (IOException)new IOException("Load error for table #" + this.index + ": " + inSpec.getLocation()).initCause(e);
                    }
                }
                return null;
            }
        };
    }
}

