/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.PrintStream;
import java.util.ArrayList;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.taplint.JsonOutputReporter;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.TextOutputReporter;

public class OutputReporterParameter
extends Parameter<OutputReporter> {
    private final StringParameter rtypeParam_;
    private final IntegerParameter repeatParam_;
    private final BooleanParameter debugParam_;
    private final IntegerParameter truncParam_;
    private final Parameter[] reporterParams_;
    private final OutputReporterFactory<?>[] orFactories_ = new OutputReporterFactory[]{new TextOutputReporterFactory("text"), new JsonOutputReporterFactory("json")};

    public OutputReporterParameter(String name) {
        super(name, OutputReporter.class, true);
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer ubuf = new StringBuffer();
        StringBuffer lbuf = new StringBuffer();
        for (OutputReporterFactory<?> f : this.orFactories_) {
            if (ubuf.length() > 0) {
                ubuf.append("|");
                lbuf.append(", ");
            }
            ubuf.append(((OutputReporterFactory)f).name_);
            lbuf.append("<code>").append(((OutputReporterFactory)f).name_).append("</code>");
        }
        this.setUsage(ubuf.toString());
        this.setPrompt("Report output format");
        this.setDescription(new String[]{"<p>Determines the format of the output.", "Possible values are", lbuf.toString() + ".", "</p>", "<p>Note not all of the other parameters may be applicable", "to all output formats.", "</p>"});
        this.setStringDefault(((OutputReporterFactory)this.orFactories_[0]).name_);
        this.rtypeParam_ = new StringParameter("report");
        this.rtypeParam_.setPrompt("Message types to report");
        ReportType[] types = ReportType.values();
        StringBuilder dbuf = new StringBuilder();
        StringBuilder cbuf = new StringBuilder();
        dbuf.append("Each character of the string is one of the letters ");
        for (int it = 0; it < types.length; ++it) {
            char tchr = types[it].getChar();
            if (it > 0) {
                dbuf.append(", ");
            }
            cbuf.append(tchr);
        }
        String tchrs = cbuf.toString();
        dbuf.append(" with the following meanings:\n").append("<ul>\n");
        for (int it = 0; it < types.length; ++it) {
            ReportType type = types[it];
            dbuf.append("<li><code>").append(type.getChar()).append("</code>: ").append(type.getDescription()).append("</li>\n");
        }
        dbuf.append("</ul>");
        this.rtypeParam_.setUsage("[" + tchrs + "]+");
        this.rtypeParam_.setDescription(new String[]{"<p>Letters indicating which message types should be listed.", dbuf.toString(), "</p>"});
        this.rtypeParam_.setStringDefault(tchrs);
        paramList.add(this.rtypeParam_);
        this.repeatParam_ = new IntegerParameter("maxrepeat");
        this.repeatParam_.setPrompt("Maximum repeat count per message");
        this.repeatParam_.setDescription(new String[]{"<p>Puts a limit on the number of times that a single message", "will be repeated.", "By setting this to some reasonably small number, you can ensure", "that the output does not get cluttered up by millions of", "repetitions of essentially the same error.", "</p>"});
        this.repeatParam_.setIntDefault(9);
        paramList.add(this.repeatParam_);
        this.truncParam_ = new IntegerParameter("truncate");
        this.truncParam_.setPrompt("Maximum number of characters per line");
        this.truncParam_.setDescription(new String[]{"<p>Limits the line length written to the output.", "</p>"});
        this.truncParam_.setIntDefault(640);
        paramList.add(this.truncParam_);
        this.debugParam_ = new BooleanParameter("debug");
        this.debugParam_.setPrompt("Emit debugging output?");
        this.debugParam_.setDescription(new String[]{"<p>If true, debugging output including stack traces will be", "output along with the normal validation messages.", "</p>"});
        this.debugParam_.setBooleanDefault(false);
        paramList.add(this.debugParam_);
        this.reporterParams_ = paramList.toArray(new Parameter[0]);
    }

    public Parameter[] getReporterParameters() {
        return this.reporterParams_;
    }

    public String objectToString(Environment env, OutputReporter orval) {
        for (OutputReporterFactory<?> f : this.orFactories_) {
            if (!((OutputReporterFactory)f).clazz_.isAssignableFrom(orval.getClass())) continue;
            return ((OutputReporterFactory)f).name_;
        }
        return orval.getClass().getName();
    }

    public OutputReporter stringToObject(Environment env, String sval) throws TaskException {
        for (OutputReporterFactory<?> f : this.orFactories_) {
            if (!((OutputReporterFactory)f).name_.equalsIgnoreCase(sval)) continue;
            return f.createReporter(env);
        }
        throw new ParameterValueException((Parameter)this, "Unknown reporter type");
    }

    private class JsonOutputReporterFactory
    extends OutputReporterFactory<JsonOutputReporter> {
        public JsonOutputReporterFactory(String name) {
            super(name, JsonOutputReporter.class);
        }

        @Override
        public JsonOutputReporter createReporter(Environment env) throws TaskException {
            PrintStream out = env.getOutputStream();
            ReportType[] types = this.getReportTypes(env);
            int maxRepeat = OutputReporterParameter.this.repeatParam_.intValue(env);
            boolean debug = OutputReporterParameter.this.debugParam_.booleanValue(env);
            int maxChar = OutputReporterParameter.this.truncParam_.intValue(env);
            return new JsonOutputReporter(out, types, maxRepeat, debug, maxChar);
        }
    }

    private class TextOutputReporterFactory
    extends OutputReporterFactory<TextOutputReporter> {
        public TextOutputReporterFactory(String name) {
            super(name, TextOutputReporter.class);
        }

        @Override
        public TextOutputReporter createReporter(Environment env) throws TaskException {
            PrintStream out = env.getOutputStream();
            ReportType[] types = this.getReportTypes(env);
            int maxRepeat = OutputReporterParameter.this.repeatParam_.intValue(env);
            boolean debug = OutputReporterParameter.this.debugParam_.booleanValue(env);
            int maxChar = OutputReporterParameter.this.truncParam_.intValue(env);
            return new TextOutputReporter(out, types, maxRepeat, debug, maxChar);
        }
    }

    private abstract class OutputReporterFactory<T extends OutputReporter> {
        private final String name_;
        private final Class<T> clazz_;

        OutputReporterFactory(String name, Class<T> clazz) {
            this.name_ = name;
            this.clazz_ = clazz;
        }

        public abstract T createReporter(Environment var1) throws TaskException;

        ReportType[] getReportTypes(Environment env) throws TaskException {
            String typeStr = OutputReporterParameter.this.rtypeParam_.stringValue(env);
            ArrayList<ReportType> typeList = new ArrayList<ReportType>();
            for (int ic = 0; ic < typeStr.length(); ++ic) {
                char c = typeStr.charAt(ic);
                ReportType type = ReportType.forChar(c);
                if (type == null) {
                    String msg = "Bad message type character '" + c + "'";
                    throw new ParameterValueException((Parameter)OutputReporterParameter.this.rtypeParam_, msg);
                }
                typeList.add(type);
            }
            return typeList.toArray(new ReportType[0]);
        }
    }
}

