/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.CopyMode;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.TableConsumerParameter;

public class OutputTableParameter
extends Parameter<TableConsumer>
implements TableConsumerParameter {
    private final OutputFormatParameter formatParam_ = new OutputFormatParameter("ofmt");

    public OutputTableParameter(String name) {
        super(name, TableConsumer.class, true);
        this.setUsage("<out-table>");
        this.setPrompt("Location of output table");
        this.setStringDefault("-");
        this.setDescription(new String[]{"<p>The location of the output table.  This is usually a filename", "to write to.", "If it is equal to the special value \"-\" (the default)", "the output table will be written to standard output.", "</p>"});
    }

    public OutputFormatParameter getFormatParameter() {
        return this.formatParam_;
    }

    public TableConsumer stringToObject(Environment env, String sval) throws TaskException {
        String loc = sval;
        String fmt = this.formatParam_.stringValue(env);
        return CopyMode.createConsumer(env, loc, fmt);
    }

    @Override
    public TableConsumer consumerValue(Environment env) throws TaskException {
        return (TableConsumer)this.objectValue(env);
    }

    @Override
    public void setValueFromConsumer(Environment env, TableConsumer consumer) throws TaskException {
        this.setValueFromObject(env, consumer);
    }
}

