/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.convert.SkySystem;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.CalculatorColumnSupplement;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.JELColumnSupplement;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.MapperTask;
import uk.ac.starlink.ttools.task.PixSampler;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.TablesInput;

public class PixSample
extends MapperTask {
    private static final String pixdataName_ = "pixdata";

    public PixSample() {
        super("Samples from a HEALPix pixel data file", new ChoiceMode(), true, new PixSampleMapper(), new PixSampleTablesInput());
    }

    public static ColumnSupplement createSampleSupplement(StarTable base, final PixSampler pixSampler, final PixSampler.StatMode statMode, final CoordReader coordReader, String lonExpr, String latExpr, String radExpr) throws IOException {
        JELColumnSupplement calcInputSup = new JELColumnSupplement(base, new String[]{lonExpr, latExpr, radExpr}, null);
        return new CalculatorColumnSupplement(calcInputSup, pixSampler.getValueInfos(statMode)){

            @Override
            protected Object[] calculate(Object[] inRow) throws IOException {
                double[] coords = coordReader.getCoords(1.getDouble(inRow[0]), 1.getDouble(inRow[1]));
                double lon = coords[0];
                double lat = coords[1];
                double radius = 1.getDouble(inRow[2]);
                return pixSampler.sampleValues(lon, lat, radius, statMode);
            }
        };
    }

    private static CoordReader createCoordReader(ChoiceParameter<SkySystem> insysParam, ChoiceParameter<SkySystem> outsysParam, Environment env) throws TaskException {
        SkySystem insys = (SkySystem)insysParam.objectValue(env);
        outsysParam.setNullPermitted(insys == null);
        SkySystem outsys = (SkySystem)outsysParam.objectValue(env);
        if (insys == null != (outsys == null)) {
            String msg = new StringBuffer().append("If one of ").append(insysParam.getName()).append(" and ").append(outsysParam.getName()).append(" is null, they must both be").toString();
            throw new ParameterValueException(outsysParam, msg);
        }
        return PixSample.createCoordReader(insys, outsys);
    }

    public static CoordReader createCoordReader(final SkySystem inSys, final SkySystem outSys) {
        if (inSys == null && outSys == null) {
            return new CoordReader(){

                @Override
                public double[] getCoords(double lonDeg, double latDeg) {
                    return new double[]{lonDeg, latDeg};
                }
            };
        }
        if (inSys != null && outSys != null) {
            double epoch = 2000.0;
            return new CoordReader(){

                @Override
                public double[] getCoords(double lonDegIn, double latDegIn) {
                    double lonRadIn = lonDegIn / 180.0 * Math.PI;
                    double latRadIn = latDegIn / 180.0 * Math.PI;
                    double[] fk5Rad = inSys.toFK5(lonRadIn, latRadIn, 2000.0);
                    double[] radOut = outSys.fromFK5(fk5Rad[0], fk5Rad[1], 2000.0);
                    double lonRadOut = radOut[0];
                    double latRadOut = radOut[1];
                    double lonDegOut = lonRadOut * 180.0 / Math.PI;
                    double latDegOut = latRadOut * 180.0 / Math.PI;
                    return new double[]{lonDegOut, latDegOut};
                }
            };
        }
        throw new IllegalArgumentException();
    }

    public static interface CoordReader {
        public double[] getCoords(double var1, double var3);
    }

    private static enum HealpixScheme {
        NESTED("nested"),
        RING("ring"),
        AUTO("(auto)");

        private final String name_;

        private HealpixScheme(String name) {
            this.name_ = name;
        }

        public String toString() {
            return this.name_;
        }
    }

    private static class PixSampleTablesInput
    implements TablesInput {
        private final InputTableParameter inTableParam_ = new InputTableParameter("in");
        private final InputTableParameter pixTableParam_;
        private final FilterParameter inFilterParam_ = new FilterParameter("icmd");
        private final FilterParameter pixFilterParam_;

        PixSampleTablesInput() {
            this.inFilterParam_.setTableDescription("the input table", this.inTableParam_, Boolean.TRUE);
            this.pixTableParam_ = new InputTableParameter(PixSample.pixdataName_);
            this.pixTableParam_.setUsage("<pix-table>");
            this.pixTableParam_.setPrompt("HEALPix table location");
            this.pixTableParam_.setDescription(new String[]{"<p>The location of the table containing the pixel data.", "The data must be in the form of a HEALPix table,", "with one pixel per row in HEALPix order.", "These files are typically, but not necessarily,", "FITS tables.", "A filename or URL may be used, but a local file will be", "more efficient.", "</p>", "<p>Some HEALPix format FITS tables seem to have rows", "which contain 1024-element arrays of pixels", "instead of single pixel values.", "This (rather perverse?) format is not currently supported", "here, but if there is demand support could be added.", "</p>"});
            InputFormatParameter pixFmtParam = this.pixTableParam_.getFormatParameter();
            pixFmtParam.setPrompt("File format for pixel data table");
            pixFmtParam.setDescription(new String[]{"<p>File format for the HEALPix pixel data table.", "This is usually, but not necessarily, FITS.", "</p>"});
            pixFmtParam.setStringDefault("fits");
            this.pixFilterParam_ = new FilterParameter("pcmd");
            this.pixFilterParam_.setTableDescription("pixel data table", this.pixTableParam_, Boolean.TRUE);
        }

        @Override
        public Parameter[] getParameters() {
            return new Parameter[]{this.inTableParam_, this.inTableParam_.getFormatParameter(), this.inFilterParam_, this.pixTableParam_, this.pixTableParam_.getFormatParameter(), this.pixFilterParam_};
        }

        @Override
        public InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
            final StarTable inTable = this.inTableParam_.tableValue(env);
            InputTableSpec inSpec = new InputTableSpec(this.inTableParam_.stringValue(env), this.inFilterParam_.stepsValue(env)){

                @Override
                public StarTable getInputTable() {
                    return inTable;
                }
            };
            final StarTable pixTable = this.pixTableParam_.tableValue(env);
            InputTableSpec pixSpec = new InputTableSpec(this.pixTableParam_.stringValue(env), this.pixFilterParam_.stepsValue(env)){

                @Override
                public StarTable getInputTable() throws TaskException {
                    try {
                        return Tables.randomTable((StarTable)pixTable);
                    }
                    catch (IOException e) {
                        throw new TaskException("Read error for " + this.getLocation(), (Throwable)e);
                    }
                }
            };
            return new InputTableSpec[]{inSpec, pixSpec};
        }
    }

    private static class PixSampleMapper
    implements TableMapper {
        private final ChoiceParameter<PixSampler.StatMode> modeParam_;
        private final StringParameter lonParam_;
        private final StringParameter latParam_;
        private final ChoiceParameter<SkySystem> insysParam_;
        private final ChoiceParameter<SkySystem> outsysParam_;
        private final StringParameter radiusParam_;
        private final ChoiceParameter<HealpixScheme> schemeParam_;

        PixSampleMapper() {
            PixSampler.StatMode[] statModes = new PixSampler.StatMode[]{PixSampler.POINT_MODE, PixSampler.MEAN_MODE};
            this.modeParam_ = new ChoiceParameter<PixSampler.StatMode>("stat", statModes){

                public String stringifyOption(PixSampler.StatMode mode) {
                    return mode.toString().toLowerCase();
                }
            };
            this.radiusParam_ = new StringParameter("radius");
            this.insysParam_ = new ChoiceParameter("insys", (Object[])SkySystem.getKnownSystems());
            this.outsysParam_ = new ChoiceParameter("pixsys", (Object[])SkySystem.getKnownSystems());
            this.modeParam_.setPrompt("Statistical quantity to gather from pixels");
            this.modeParam_.setDescription(new String[]{"<p>Determines how the pixel values will be sampled", "to generate an output value.", "The options are:", "<ul>", "<li><code>" + this.modeParam_.stringifyOption((Object)PixSampler.POINT_MODE) + "</code>: ", "Uses the value at the pixel covering the supplied position.", "In this case the <code>" + this.radiusParam_.getName() + "</code>", "parameter is not used.</li>", "<li><code>" + this.modeParam_.stringifyOption((Object)PixSampler.MEAN_MODE) + "</code>: ", "Averages the values over all the pixels within a radius", "given by the <code>" + this.radiusParam_.getName() + "</code>", "parameter.", "This averaging is somewhat approximate;", "all pixels which are mostly within the radius", "are averaged with equal weights.</li>", "</ul>", "</p>"});
            this.modeParam_.setDefaultOption((Object)PixSampler.POINT_MODE);
            this.radiusParam_.setPrompt("Radius for statistical accumulation in degrees");
            this.radiusParam_.setUsage("<expr>");
            this.radiusParam_.setDescription(new String[]{"<p>Determines the radius in degrees over which pixels will be", "sampled to generate the output statistic", "in accordance with the value of the", "<code>" + this.modeParam_.getName() + "</code> parameter.", "This will typically be a constant value,", "but it may be an algebraic expression based on", "columns from the input table.", "</p>", "<p>Not used if <code>" + this.modeParam_.getName() + "=" + this.modeParam_.stringifyOption((Object)PixSampler.POINT_MODE) + "</code>.", "</p>"});
            String postxt = new StringBuffer().append("This will usually be the name or ID of a column\n").append("in the input table,\n").append("or an expression involving one.\n").append("If this coordinate does not match the coordinate\n").append("system used by the pixel data table,\n").append("both coordinate systems must be set using the\n").append("<code>").append(this.insysParam_.getName()).append("</code>").append(" and ").append("<code>").append(this.outsysParam_.getName()).append("</code>").append(" parameters.\n").toString();
            this.lonParam_ = new StringParameter("lon");
            this.lonParam_.setPrompt("Input table longitude in degrees");
            this.lonParam_.setUsage("<expr>");
            this.lonParam_.setDescription(new String[]{"<p>Expression which evaluates to the longitude coordinate", "in degrees in the input table at which", "positions are to be sampled from the pixel data table.", postxt, "</p>"});
            this.latParam_ = new StringParameter("lat");
            this.latParam_.setPrompt("Input table latitude in degrees");
            this.latParam_.setUsage("<expr>");
            this.latParam_.setDescription(new String[]{"<p>Expression which evaluates to the latitude coordinate", "in degrees in the input table at which", "positions are to be sampled from the pixel data table.", postxt, "</p>"});
            this.schemeParam_ = new ChoiceParameter("pixorder", (Object[])HealpixScheme.values());
            this.schemeParam_.setPrompt("HEALPix pixel ordering scheme");
            this.schemeParam_.setDescription(new String[]{"<p>Selects the pixel ordering scheme used by the", "pixel data file.", "There are two different ways of ordering pixels in a", "HEALPix file, \"ring\" and \"nested\", and the sampler", "needs to know which one is in use.", "If you know which is in use, choose the appropriate value", "for this parameter;", "if <code>" + (Object)((Object)HealpixScheme.AUTO) + "</code> is used", "it will attempt to work it out from headers in the file", "(the ORDERING header).", "If no reliable ordering scheme can be determined,", "the command will fail with an error.", "</p>"});
            this.schemeParam_.setDefaultOption((Object)HealpixScheme.AUTO);
            String systxt = new StringBuffer().append("If the sample positions are given\n").append("in the same coordinate system as that given by\n").append("the pixel data table, both the ").append("<code>").append(this.insysParam_.getName()).append("</code>").append(" and ").append("<code>").append(this.outsysParam_.getName()).append("</code>").append(" parameters may be set <code>null</code>.\n").append("</p>\n").append("<p>The available coordinate systems are:\n").append(SkySystem.getSystemUsage()).toString();
            this.insysParam_.setPrompt("Sky coordinate system for sample positions");
            this.insysParam_.setDescription(new String[]{"<p>Specifies the sky coordinate system in which", "sample positions are provided by the", "<code>" + this.lonParam_.getName() + "</code>" + "/" + "<code>" + this.latParam_.getName() + "</code>", "parameters.", systxt, "</p>"});
            this.insysParam_.setNullPermitted(true);
            this.outsysParam_.setPrompt("Sky coordinate system for pixel positions");
            this.outsysParam_.setDescription(new String[]{"<p>Specifies the sky coordinate system", "used for the HEALPix data in the pixdata file.", systxt, "</p>"});
            this.outsysParam_.setNullPermitted(true);
        }

        @Override
        public Parameter[] getParameters() {
            return new Parameter[]{this.schemeParam_, this.modeParam_, this.lonParam_, this.latParam_, this.insysParam_, this.outsysParam_, this.radiusParam_};
        }

        @Override
        public TableMapping createMapping(Environment env, int nin) throws TaskException {
            if (nin != 2) {
                throw new TaskException("Wrong number of tables");
            }
            final PixSampler.StatMode statMode = (PixSampler.StatMode)this.modeParam_.objectValue(env);
            final CoordReader coordReader = PixSample.createCoordReader((ChoiceParameter<SkySystem>)this.insysParam_, (ChoiceParameter<SkySystem>)this.outsysParam_, env);
            final String lonExpr = this.lonParam_.stringValue(env);
            final String latExpr = this.latParam_.stringValue(env);
            final String radiusExpr = statMode.isPoint() ? "0" : this.radiusParam_.stringValue(env);
            final HealpixScheme scheme = (HealpixScheme)((Object)this.schemeParam_.objectValue(env));
            return new TableMapping(){

                @Override
                public StarTable mapTables(InputTableSpec[] ins) throws TaskException, IOException {
                    boolean isNested;
                    StarTable baseTable = ins[0].getWrappedTable();
                    StarTable pixTable = ins[1].getWrappedTable();
                    int nside = PixSampler.inferNside(pixTable);
                    if (scheme == HealpixScheme.RING) {
                        isNested = false;
                    } else if (scheme == HealpixScheme.NESTED) {
                        isNested = true;
                    } else {
                        assert (scheme == HealpixScheme.AUTO);
                        isNested = PixSampler.inferNested(pixTable);
                    }
                    PixSampler pixSampler = new PixSampler(pixTable, nside, isNested);
                    ColumnSupplement sampleSup = PixSample.createSampleSupplement(baseTable, pixSampler, statMode, coordReader, lonExpr, latExpr, radiusExpr);
                    return new AddColumnsTable(baseTable, sampleSup);
                }
            };
        }
    }
}

