/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.SkyTiling;
import uk.ac.starlink.ttools.cone.TilingParameter;
import uk.ac.starlink.ttools.jel.JELQuantity;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinResultColumnData;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.SingleTableMapping;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public class SkyDensityMap
extends SingleMapperTask {
    private final StringParameter lonParam_ = new StringParameter("lon");
    private final StringParameter latParam_;
    private final TilingParameter tilingParam_;
    private final BooleanParameter countParam_;
    private final StringMultiParameter quantParam_;
    private final ChoiceParameter<Combiner> combinerParam_;
    private final BooleanParameter completeParam_;
    private static final int MAX_ARRAY = 1000000;

    public SkyDensityMap() {
        super("Calculates sky density maps", new ChoiceMode(), true, true);
        this.lonParam_.setUsage("<expr/deg>");
        this.lonParam_.setPrompt("Longitude coordinate in input table");
        this.lonParam_.setDescription(new String[]{"<p>Longitude in degrees for the position of each row", "in the input table.", "This may simply be a column name, or it may be", "an algebraic expression as explained in <ref id='jel'/>.", "The sky system used here will determine the", "grid on which the output map is built.", "</p>"});
        this.latParam_ = new StringParameter("lat");
        this.latParam_.setUsage("<expr/deg>");
        this.latParam_.setPrompt("Latitude coordinate in input table");
        this.latParam_.setDescription(new String[]{"<p>Latitude in degrees for the position of each row", "in the input table.", "This may simply be a column name, or it may be", "an algebraic expression as explained in <ref id='jel'/>.", "The sky system used here will determine the", "grid on which the output map is built.", "</p>"});
        this.tilingParam_ = new TilingParameter("tiling");
        this.tilingParam_.setHealpixNestDefault(5);
        this.countParam_ = new BooleanParameter("count");
        this.countParam_.setPrompt("Include count column?");
        this.countParam_.setDescription(new String[]{"<p>Controls whether a COUNT column is added to the output table", "along with any other columns that may have been requested.", "If included, this reports the number of rows from the input table", "that fell within the corresponding bin.", "</p>"});
        this.countParam_.setBooleanDefault(true);
        Object[] combiners = Combiner.getKnownCombiners();
        this.combinerParam_ = new ChoiceParameter("combine", combiners);
        this.combinerParam_.setPrompt("Combination method");
        StringBuffer lbuf = new StringBuffer();
        for (Object combiner : combiners) {
            lbuf.append("<li>").append("<code>").append(((Combiner)combiner).getName()).append("</code>: ").append(((Combiner)combiner).getDescription()).append("</li>\n");
        }
        String combinersDescrip = lbuf.toString();
        this.combinerParam_.setDescription(new String[]{"<p>Combination mode for aggregating binned quantities.", "Possible values are:", "<ul>", lbuf.toString(), "</ul>", "</p>"});
        this.combinerParam_.setDefaultOption((Object)Combiner.MEAN);
        this.completeParam_ = new BooleanParameter("complete");
        this.completeParam_.setPrompt("Write row for every pixel?");
        this.completeParam_.setDescription(new String[]{"<p>Determines whether the output table contains a row", "for every pixel in the tiling, or only the rows for", "pixels in which some of the input data fell.", "</p>", "<p>The value of this parameter may affect performance as well", "as output.  If you know that most pixels on the sky will", "be covered, it's probably a good idea to set this true,", "and if you know that only a small patch of sky will be", "covered, it's better to set it false.", "</p>"});
        this.completeParam_.setBooleanDefault(false);
        this.quantParam_ = new StringMultiParameter("cols", ' ');
        this.quantParam_.setPrompt("Quantities to aggregate");
        this.quantParam_.setUsage("<expr> ...");
        this.quantParam_.setDescription(new String[]{"<p>Selects the columns to be aggregated into bins.", "The value is a space-separated list of items,", "where each item may be either a column name", "or an expression using the", "<ref id='jel'>expression language</ref>.", "The output table will have one column for each of the", "items in this list.", "</p>"});
        this.quantParam_.setNullPermitted(true);
        this.getParameterList().addAll(Arrays.asList(new Parameter[]{this.lonParam_, this.latParam_, this.tilingParam_, this.countParam_, this.quantParam_, this.combinerParam_, this.completeParam_}));
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        int countIndex;
        String lonString = this.lonParam_.stringValue(env);
        String latString = this.latParam_.stringValue(env);
        SkyTiling tiling = (SkyTiling)this.tilingParam_.objectValue(env);
        String[] quants = this.quantParam_.stringsValue(env);
        Combiner combiner = (Combiner)this.combinerParam_.objectValue(env);
        boolean complete = this.completeParam_.booleanValue(env);
        ArrayList<AggregateQuantity> aqList = new ArrayList<AggregateQuantity>();
        boolean hasCount = this.countParam_.booleanValue(env);
        if (hasCount) {
            countIndex = aqList.size();
            aqList.add(new AggregateQuantity(Combiner.COUNT, "1"){

                @Override
                public ValueInfo adjustInfo(ValueInfo combInfo) {
                    DefaultValueInfo info = new DefaultValueInfo(combInfo);
                    info.setName("count");
                    info.setDescription("number of input table rows in bin");
                    info.setUnitString(null);
                    return info;
                }
            });
        } else {
            countIndex = -1;
        }
        String[] arr$ = quants;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String quantity;
            String expr = quantity = arr$[i$];
            final String label = quantity.replaceAll("\\s+", "").replaceAll("[^0-9A-Za-z]+", "_");
            aqList.add(new AggregateQuantity(combiner, expr){

                @Override
                public ValueInfo adjustInfo(ValueInfo combInfo) {
                    DefaultValueInfo info = new DefaultValueInfo(combInfo);
                    info.setName(label);
                    return info;
                }
            });
        }
        AggregateQuantity[] aqs = aqList.toArray(new AggregateQuantity[0]);
        if (aqs.length == 0) {
            String msg = "No aggregate quantities to calculate; use parameters " + this.quantParam_.getName().toUpperCase() + " or " + this.countParam_.getName().toUpperCase();
            throw new TaskException(msg);
        }
        final SkyMapMapping mapping = new SkyMapMapping(lonString, latString, tiling, complete, aqs, countIndex);
        final TableProducer inProd = this.createInputProducer(env);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                return mapping.map(inProd.getTable());
            }
        };
    }

    private static double doEvaluateDouble(JELRowReader jelReader, CompiledExpression compEx) throws IOException {
        try {
            return jelReader.evaluateDouble(compEx);
        }
        catch (Throwable e) {
            throw new IOException("Evaluation error", e);
        }
    }

    private static BinList createBinList(Combiner combiner, long npix, boolean isComplete) {
        BinList binList;
        if (isComplete && npix < 1000000L && (binList = combiner.createArrayBinList((int)npix)) != null) {
            return binList;
        }
        return combiner.createHashBinList(npix);
    }

    private static ColumnData createIndexColumn(SkyTiling tiling) {
        DefaultValueInfo info = new DefaultValueInfo(tiling.getIndexInfo());
        if (tiling.getPixelCount() <= Integer.MAX_VALUE) {
            info.setContentClass(Integer.class);
            return new ColumnData((ValueInfo)info){

                public Object readValue(long irow) {
                    return new Integer((int)irow);
                }
            };
        }
        info.setContentClass(Long.class);
        return new ColumnData((ValueInfo)info){

            public Object readValue(long irow) {
                return new Long(irow);
            }
        };
    }

    private static class UnsparseTable
    extends WrapperStarTable {
        private final StarTable base_;
        private final long minIrow_;
        private final long maxIrow_;
        private final int[] testIcols_;

        UnsparseTable(StarTable base, long minIrow, long maxIrow, int[] testIcols) {
            super(base);
            this.base_ = base;
            this.minIrow_ = minIrow;
            this.maxIrow_ = maxIrow;
            this.testIcols_ = testIcols;
        }

        public RowSequence getRowSequence() throws IOException {
            return new RowSequence(){
                long irow;
                {
                    this.irow = UnsparseTable.this.minIrow_ - 1L;
                }

                public boolean next() throws IOException {
                    while (!UnsparseTable.this.hasData(++this.irow)) {
                        if (this.irow <= UnsparseTable.this.maxIrow_) continue;
                        return false;
                    }
                    return true;
                }

                public Object getCell(int icol) throws IOException {
                    return UnsparseTable.this.base_.getCell(this.irow, icol);
                }

                public Object[] getRow() throws IOException {
                    return UnsparseTable.this.base_.getRow(this.irow);
                }

                public void close() {
                }
            };
        }

        private boolean hasData(long irow) throws IOException {
            for (int ic : this.testIcols_) {
                if (Tables.isBlank((Object)this.base_.getCell(irow, ic))) continue;
                return true;
            }
            return false;
        }

        public boolean isRandom() {
            return false;
        }

        public long getRowCount() {
            return -1L;
        }

        public Object getCell(long irow, int icell) {
            throw new UnsupportedOperationException();
        }

        public Object[] getRow(long irow) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class AggregateQuantity {
        final Combiner combiner_;
        final String expr_;

        AggregateQuantity(Combiner combiner, String expr) {
            this.combiner_ = combiner;
            this.expr_ = expr;
        }

        abstract ValueInfo adjustInfo(ValueInfo var1);
    }

    private static class Binner {
        final ValueInfo info_;
        final BinList binList_;
        final CompiledExpression compEx_;

        Binner(ValueInfo info, BinList binList, CompiledExpression compEx) {
            this.info_ = info;
            this.binList_ = binList;
            this.compEx_ = compEx;
        }
    }

    private static class SkyMapMapping
    implements SingleTableMapping {
        private final String lonStr_;
        private final String latStr_;
        private final SkyTiling tiling_;
        private final boolean complete_;
        private final AggregateQuantity[] aqs_;
        private final int countIndex_;

        SkyMapMapping(String lonStr, String latStr, SkyTiling tiling, boolean complete, AggregateQuantity[] aqs, int countIndex) {
            this.lonStr_ = lonStr;
            this.latStr_ = latStr;
            this.tiling_ = tiling;
            this.complete_ = complete;
            this.aqs_ = aqs;
            this.countIndex_ = countIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StarTable map(StarTable inTable) throws IOException, TaskException {
            int[] testIcols;
            CompiledExpression latExpr;
            CompiledExpression lonExpr;
            SequentialJELRowReader jelReader = new SequentialJELRowReader(inTable);
            Library lib = JELUtils.getLibrary(jelReader);
            try {
                lonExpr = JELUtils.compile(lib, inTable, this.lonStr_, Double.TYPE);
                latExpr = JELUtils.compile(lib, inTable, this.latStr_, Double.TYPE);
            }
            catch (CompilationException e) {
                throw new TaskException("Bad lon/lat value: " + e.getMessage(), (Throwable)e);
            }
            int nq = this.aqs_.length;
            long npix = this.tiling_.getPixelCount();
            Binner[] binners = new Binner[nq];
            for (int iq = 0; iq < nq; ++iq) {
                JELQuantity jq;
                AggregateQuantity aq = this.aqs_[iq];
                Combiner combiner = aq.combiner_;
                String expr = aq.expr_;
                BinList binList = SkyDensityMap.createBinList(combiner, npix, this.complete_);
                try {
                    jq = JELUtils.compileQuantity(lib, jelReader, expr, Double.TYPE);
                }
                catch (CompilationException e) {
                    throw new TaskException("Bad quantity value " + expr + ": " + e.getMessage(), (Throwable)e);
                }
                ValueInfo info = aq.adjustInfo(combiner.createCombinedInfo(jq.getValueInfo()));
                CompiledExpression compEx = jq.getCompiledExpression();
                binners[iq] = new Binner(info, binList, compEx);
            }
            long minIndex = npix;
            long maxIndex = 0L;
            try {
                while (jelReader.next()) {
                    double lon = SkyDensityMap.doEvaluateDouble(jelReader, lonExpr);
                    double lat = SkyDensityMap.doEvaluateDouble(jelReader, latExpr);
                    long index = this.tiling_.getPositionTile(lon, lat);
                    minIndex = Math.min(minIndex, index);
                    maxIndex = Math.max(maxIndex, index);
                    for (Binner binner : binners) {
                        double datum = SkyDensityMap.doEvaluateDouble(jelReader, binner.compEx_);
                        if (Double.isNaN(datum)) continue;
                        binner.binList_.submitToBin(index, datum);
                    }
                }
            }
            finally {
                jelReader.close();
            }
            ColumnStarTable binsTable = ColumnStarTable.makeTableWithRows((long)npix);
            binsTable.addColumn(SkyDensityMap.createIndexColumn(this.tiling_));
            for (Binner binner : binners) {
                binsTable.addColumn(BinResultColumnData.createInstance(binner.info_, binner.binList_.getResult()));
            }
            if (this.complete_) {
                return binsTable;
            }
            int icolOffset = 1;
            if (this.countIndex_ >= 0) {
                testIcols = new int[]{icolOffset + this.countIndex_};
            } else {
                int ncol = binsTable.getColumnCount();
                testIcols = new int[ncol - icolOffset];
                for (int i = 0; i < testIcols.length; ++i) {
                    testIcols[i] = icolOffset + i;
                }
            }
            return new UnsparseTable((StarTable)binsTable, minIndex, maxIndex, testIcols);
        }
    }
}

