/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.net.URL;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.vo.EndpointSet;

public class TapEndpointParams {
    final URLParameter baseParam_;
    final EndpointParameter syncParam_;
    final EndpointParameter asyncParam_;
    final EndpointParameter tablesParam_;
    final EndpointParameter capabilitiesParam_;
    final EndpointParameter availabilityParam_;
    final EndpointParameter examplesParam_;
    final URLParameter[] otherParams_;

    public TapEndpointParams(String baseParamName) {
        this.baseParam_ = new URLParameter(baseParamName);
        this.baseParam_.setPrompt("Base URL of TAP service");
        URLParameter[] uRLParameterArray = new URLParameter[6];
        this.syncParam_ = new EndpointParameter("sync");
        uRLParameterArray[0] = this.syncParam_;
        this.asyncParam_ = new EndpointParameter("async");
        uRLParameterArray[1] = this.asyncParam_;
        this.tablesParam_ = new EndpointParameter("tables");
        uRLParameterArray[2] = this.tablesParam_;
        this.capabilitiesParam_ = new EndpointParameter("capabilities");
        uRLParameterArray[3] = this.capabilitiesParam_;
        this.availabilityParam_ = new EndpointParameter("availability");
        uRLParameterArray[4] = this.availabilityParam_;
        this.examplesParam_ = new EndpointParameter("examples");
        uRLParameterArray[5] = this.examplesParam_;
        this.otherParams_ = uRLParameterArray;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<p>The base URL of a Table Access Protocol service.\n").append("This is the bare URL without a trailing \"/[a]sync\".\n").append("</p>\n").append("<p>The default values of the various endpoints\n").append("(sync and async query submission, tables metadata,\n").append("service-provided examples etc)\n").append("use this URL as a parent\n").append("and append standard sub-paths.\n").append("However, other parameters (");
        for (int i = 0; i < 2; ++i) {
            sbuf.append("<code>").append(this.otherParams_[i].getName()).append("</code>, ");
        }
        sbuf.append("...)\n").append("are provided so that the different endpoints\n").append("can be set individually if required.\n").append("</p>\n");
        this.baseParam_.setDescription(sbuf.toString());
    }

    public URLParameter getBaseParameter() {
        return this.baseParam_;
    }

    public URLParameter[] getOtherParameters() {
        return (URLParameter[])this.otherParams_.clone();
    }

    public EndpointSet getEndpointSet(Environment env) throws TaskException {
        final URL baseUrl = (URL)this.baseParam_.objectValue(env);
        final URL syncUrl = this.syncParam_.urlValue(env, baseUrl);
        final URL asyncUrl = this.asyncParam_.urlValue(env, baseUrl);
        final URL tablesUrl = this.tablesParam_.urlValue(env, baseUrl);
        final URL capabilitiesUrl = this.capabilitiesParam_.urlValue(env, baseUrl);
        final URL availabilityUrl = this.availabilityParam_.urlValue(env, baseUrl);
        final URL examplesUrl = this.examplesParam_.urlValue(env, baseUrl);
        return new EndpointSet(){

            public String getIdentity() {
                return baseUrl.toString();
            }

            public URL getSyncEndpoint() {
                return syncUrl;
            }

            public URL getAsyncEndpoint() {
                return asyncUrl;
            }

            public URL getTablesEndpoint() {
                return tablesUrl;
            }

            public URL getCapabilitiesEndpoint() {
                return capabilitiesUrl;
            }

            public URL getAvailabilityEndpoint() {
                return availabilityUrl;
            }

            public URL getExamplesEndpoint() {
                return examplesUrl;
            }
        };
    }

    private class EndpointParameter
    extends URLParameter {
        private final String label_;

        EndpointParameter(String label) {
            super(label + "url");
            this.label_ = label;
            this.setPrompt("URL for TAP " + label + " endpoint");
            this.setDescription(new String[]{"<p>Sets the URL to use for the " + label + " endpoint", "of the TAP service.", "By default, this would be", "<code>&lt;" + TapEndpointParams.this.baseParam_.getName() + "&gt;/" + label + "</code>", "but you can set this parameter to some other location", "if required.", "If left blank, the default value is used.", "</p>"});
            this.setNullPermitted(true);
            this.setPreferExplicit(false);
        }

        URL urlValue(Environment env, URL baseUrl) throws TaskException {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(baseUrl.toString());
            if (sbuf.charAt(sbuf.length() - 1) != '/') {
                sbuf.append('/');
            }
            sbuf.append(this.label_);
            this.setStringDefault(sbuf.toString());
            return (URL)this.objectValue(env);
        }
    }
}

