/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TapLinter;
import uk.ac.starlink.ttools.task.OutputReporterParameter;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TapEndpointParams;
import uk.ac.starlink.vo.EndpointSet;

public class TapLint
implements Task {
    private final TapLinter tapLinter_;
    private final OutputReporterParameter reporterParam_;
    private final TapEndpointParams endpointParams_;
    private final StringMultiParameter stagesParam_;
    private final IntegerParameter maxtableParam_;
    private final Parameter[] params_;

    public TapLint() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.endpointParams_ = new TapEndpointParams("tapurl");
        URLParameter urlParam = this.endpointParams_.getBaseParameter();
        urlParam.setPosition(1);
        paramList.add(urlParam);
        this.stagesParam_ = new StringMultiParameter("stages", ' ');
        this.stagesParam_.setPrompt("Codes for validation stages to run");
        this.tapLinter_ = new TapLinter();
        Map<String, Stage> stageMap = this.tapLinter_.getKnownStages();
        StringBuffer slbuf = new StringBuffer();
        StringBuffer subuf = new StringBuffer();
        StringBuffer sdbuf = new StringBuffer();
        for (String code : stageMap.keySet()) {
            Stage stage = stageMap.get(code);
            boolean on = this.tapLinter_.isDefault(code);
            slbuf.append("<li>").append("<code>").append(code).append("</code>").append(": ").append(stage.getDescription()).append(on ? " (on)" : "").append("</li>").append("\n");
            if (subuf.length() > 0) {
                subuf.append('|');
            }
            subuf.append(code);
            if (!on) continue;
            if (sdbuf.length() > 0) {
                sdbuf.append(' ');
            }
            sdbuf.append(code);
        }
        this.stagesParam_.setUsage(subuf.toString() + "[ ...]");
        this.stagesParam_.setStringDefault(sdbuf.toString());
        this.stagesParam_.setDescription(new String[]{"<p>Lists the validation stages which the validator will perform.", "Each stage is represented by a short code, as follows:", "<ul>", slbuf.toString(), "</ul>", "You can specify a list of stage codes, separated by spaces.", "Order is not significant.", "</p>", "<p>Note that removing some stages may affect the operation", "of others;", "for instance table metadata is acquired from the metadata stages,", "and avoiding those will mean that later stages that use", "the table metadata to pose queries will not be able to do so", "with knowledge of the database schema.", "</p>"});
        paramList.add((Object)this.stagesParam_);
        this.maxtableParam_ = new IntegerParameter("maxtable");
        this.maxtableParam_.setPrompt("Maximum number of tables tested individually");
        this.maxtableParam_.setDescription(new String[]{"<p>Limits the number of tables from the service", "that will be tested.", "Currently, this only affects", "stage <code>MDQ</code>.", "If the value is left blank (the default),", "or if it is larger than the number of tables actually", "present in the service, it will have no effect.", "</p>"});
        this.maxtableParam_.setMinimum(1);
        this.maxtableParam_.setNullPermitted(true);
        paramList.add(this.maxtableParam_);
        this.reporterParam_ = new OutputReporterParameter("format");
        paramList.add((Object)this.reporterParam_);
        paramList.addAll(Arrays.asList(this.reporterParam_.getReporterParameters()));
        paramList.addAll(Arrays.asList(this.endpointParams_.getOtherParameters()));
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public String getPurpose() {
        return "Tests TAP services";
    }

    public Parameter[] getParameters() {
        return this.params_;
    }

    public Executable createExecutable(Environment env) throws TaskException {
        EndpointSet endpointSet = this.endpointParams_.getEndpointSet(env);
        Integer maxTablesObj = (Integer)this.maxtableParam_.objectValue(env);
        int maxTestTables = maxTablesObj == null ? -1 : maxTablesObj;
        HashSet<String> stageSet = new HashSet<String>();
        Set<String> knownStages = this.tapLinter_.getKnownStages().keySet();
        for (String s : knownStages) {
            assert (s.equals(s.toUpperCase()));
        }
        String[] stages = this.stagesParam_.stringsValue(env);
        for (int is = 0; is < stages.length; ++is) {
            String sc = stages[is];
            if (!knownStages.contains(sc.toUpperCase())) {
                throw new ParameterValueException((Parameter)this.stagesParam_, "Unknown stage " + sc);
            }
            stageSet.add(sc);
        }
        OutputReporter reporter = (OutputReporter)this.reporterParam_.objectValue(env);
        return this.tapLinter_.createExecutable(reporter, endpointSet, stageSet, maxTestTables);
    }
}

