/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.LongParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.TapEndpointParams;
import uk.ac.starlink.ttools.task.TapResultProducer;
import uk.ac.starlink.ttools.task.TapResultReader;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.AdqlSyntax;
import uk.ac.starlink.vo.AdqlValidator;
import uk.ac.starlink.vo.EndpointSet;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class TapMapper
implements TableMapper {
    private final TapEndpointParams endpointParams_;
    private final StringParameter adqlParam_;
    private final BooleanParameter parseParam_;
    private final BooleanParameter syncParam_;
    private final StringParameter langParam_;
    private final LongParameter maxrecParam_;
    private final StringParameter destructionParam_;
    private final LongParameter durationParam_;
    private final ContentCodingParameter codingParam_;
    private final Parameter<VOTableWriter> vowriterParam_;
    private final TapResultReader resultReader_;
    private final Parameter[] params_;

    public TapMapper() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(TapMapper.createUploadNameParameter("N"));
        this.endpointParams_ = new TapEndpointParams("tapurl");
        paramList.add(this.endpointParams_.getBaseParameter());
        this.adqlParam_ = new StringParameter("adql");
        this.adqlParam_.setPrompt("ADQL query text");
        this.adqlParam_.setDescription(new String[]{"<p>Astronomical Data Query Language string specifying the", "TAP query to execute.", "ADQL/S resembles SQL, so this string will likely start with", "\"SELECT\".", "</p>"});
        this.adqlParam_.setUsage("<query-text>");
        paramList.add(this.adqlParam_);
        this.parseParam_ = new BooleanParameter("parse");
        this.parseParam_.setPrompt("Perform syntax checking on ADQL?");
        this.parseParam_.setDescription(new String[]{"<p>Determines whether an attempt will be made to check", "the syntax of the ADQL prior to submitting the query.", "If this is set true, and if a syntax error is found,", "the task will fail with an error before any attempt is made", "to submit the query.", "</p>"});
        this.parseParam_.setBooleanDefault(false);
        paramList.add(this.parseParam_);
        this.syncParam_ = new BooleanParameter("sync");
        this.syncParam_.setPrompt("Submit query in synchronous mode?");
        this.syncParam_.setDescription(new String[]{"<p>Determines whether the TAP query is submitted in synchronous", "or asynchronous mode.", "Synchronous (<code>true</code>)", "means that the result is retrieved over the same HTTP connection", "that the query is submitted from.", "This is uncomplicated, but means if the query takes a long time", "it may time out and the results will be lost.", "Asynchronous (<code>false</code>)", "means that the job is queued and results may be retrieved later.", "Normally this command does the necessary waiting around and", "recovery of the result, though with appropriate settings", "you can get", "<ref id='tapresume'><code>tapresume</code></ref>", "to pick it up for you later instead.", "In most cases <code>false</code> (the default) is preferred.", "</p>"});
        this.syncParam_.setBooleanDefault(false);
        paramList.add(this.syncParam_);
        this.maxrecParam_ = new LongParameter("maxrec");
        this.maxrecParam_.setPrompt("Maximum number of records in output table");
        this.maxrecParam_.setDescription(new String[]{"<p>Sets the requested maximum row count for the result of", "the query.", "The service is not obliged to respect this, but in the case", "that it has a default maximum record count, setting this value", "may raise the limit.", "If no value is set, the service's default policy will be used.", "</p>"});
        this.maxrecParam_.setUsage("<nrow>");
        this.maxrecParam_.setMinimum(0L);
        this.maxrecParam_.setNullPermitted(true);
        paramList.add(this.maxrecParam_);
        this.destructionParam_ = new StringParameter("destruction");
        this.destructionParam_.setPrompt("Async job destruction time (ISO8601)");
        this.destructionParam_.setDescription(new String[]{"<p>Posts an updated value of the UWS DESTRUCTION parameter", "to the query job before it starts.", "This only makes sense for asynchronous jobs", "(<code>" + this.syncParam_.getName() + "</code>=false).", "</p>", "<p>The supplied value should be an ISO-8601-like string,", "giving the new requested job destruction time.", "The service is not obliged to honour this request.", "See <webref url='http://www.ivoa.net/documents/UWS/20101010/'", ">UWS v1.0</webref>, sec 2.2.3.3.", "</p>"});
        this.destructionParam_.setUsage("<iso8601>");
        this.destructionParam_.setNullPermitted(true);
        paramList.add(this.destructionParam_);
        this.durationParam_ = new LongParameter("executionduration");
        this.durationParam_.setPrompt("Async job max duration (seconds)");
        this.durationParam_.setDescription(new String[]{"<p>Posts an updated value of the UWS EXECUTIONDURATION parameter", "to the query job before it starts.", "This only makes sense for asynchronous jobs", "(<code>" + this.syncParam_.getName() + "</code>=false).", "</p>", "<p>The supplied value is an integer giving the maximum number", "of wall-clock seconds for which the job is permitted to", "execute before being forcibly terminated.", "A value of zero indicates unlimited duration.", "The service is not obliged to honour this request.", "See <webref url='http://www.ivoa.net/documents/UWS/20101010/'", ">UWS v1.0</webref>, sec 2.2.3.4.", "</p>"});
        this.durationParam_.setUsage("<seconds>");
        this.durationParam_.setMinimum(0L);
        this.durationParam_.setNullPermitted(true);
        paramList.add(this.durationParam_);
        this.codingParam_ = new ContentCodingParameter();
        paramList.add((Object)this.codingParam_);
        VOTableWriter[] vowriters = new VOTableWriter[]{new VOTableWriter(DataFormat.TABLEDATA, true, VOTableVersion.V12), new VOTableWriter(DataFormat.BINARY, true, VOTableVersion.V12), new VOTableWriter(DataFormat.BINARY2, true, VOTableVersion.V13)};
        this.vowriterParam_ = new ChoiceParameter<VOTableWriter>("upvotformat", vowriters){

            public String stringifyOption(VOTableWriter vowriter) {
                return vowriter.getDataFormat().toString();
            }
        };
        this.vowriterParam_.setPrompt("VOTable serialization used for table upload");
        this.vowriterParam_.setDescription(new String[]{"<p>Determines how any uploaded tables will be serialized", "for transmission to the TAP server.", "The supplied string is the name of one of the defined", "VOTable serialization formats.", "The choice shouldn't affect any results, though it may affect", "required bandwidth, and some services may (though should not)", "have non-standard requirements for serialization format.", "</p>"});
        this.vowriterParam_.setStringDefault(TapQuery.DFLT_UPLOAD_SER.toString());
        paramList.add(this.vowriterParam_);
        this.langParam_ = new StringParameter("language");
        this.langParam_.setPrompt("TAP query language");
        this.langParam_.setDescription(new String[]{"<p>Language to use for the ADQL-like query.", "This will usually be \"ADQL\" (the default),", "but may be set to some other value supported by the service,", "for instance a variant indicating a different ADQL version.", "Note that at present, setting it to \"PQL\" is not sufficient", "to submit a PQL query.", "</p>"});
        this.langParam_.setUsage("<lang-name>");
        this.langParam_.setStringDefault("ADQL");
        paramList.add(this.langParam_);
        this.resultReader_ = new TapResultReader();
        paramList.addAll(Arrays.asList(this.resultReader_.getParameters()));
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    @Override
    public Parameter[] getParameters() {
        return this.params_;
    }

    @Override
    public TableMapping createMapping(Environment env, int nup) throws TaskException {
        Long maxrec;
        final EndpointSet endpointSet = this.endpointParams_.getEndpointSet(env);
        final String adql = this.adqlParam_.stringValue(env);
        if (this.parseParam_.booleanValue(env)) {
            AdqlValidator validator = new AdqlValidator(null, null, null);
            try {
                validator.validate(adql);
            }
            catch (Throwable e) {
                throw new ExecutionException("ADQL Parse error: " + e.getMessage(), e);
            }
        }
        boolean sync = this.syncParam_.booleanValue(env);
        final LinkedHashMap<String, String> extraParams = new LinkedHashMap<String, String>();
        String lang = this.langParam_.stringValue(env);
        if (!"ADQL".equals(lang)) {
            extraParams.put("LANG", lang);
        }
        if ((maxrec = (Long)this.maxrecParam_.objectValue(env)) != null) {
            extraParams.put("MAXREC", maxrec.toString());
        }
        final String[] upNames = new String[nup];
        for (int iu = 0; iu < nup; ++iu) {
            upNames[iu] = TapMapper.createUploadNameParameter(Integer.toString(iu + 1)).stringValue(env);
        }
        final ContentCoding coding = this.codingParam_.codingValue(env);
        final StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        final VOTableWriter vowriter = (VOTableWriter)this.vowriterParam_.objectValue(env);
        long uploadLimit = -1L;
        if (sync) {
            return new TableMapping(){

                @Override
                public StarTable mapTables(InputTableSpec[] inSpecs) throws TaskException, IOException {
                    TapQuery tq = TapMapper.createTapQuery(endpointSet, adql, extraParams, upNames, inSpecs, -1L, vowriter);
                    return tq.executeSync(tfact.getStoragePolicy(), coding);
                }
            };
        }
        final TapResultProducer resultProducer = this.resultReader_.createResultProducer(env, coding);
        final boolean progress = this.resultReader_.getProgressParameter().booleanValue(env);
        final String destruction = this.destructionParam_.stringValue(env);
        final Long duration = (Long)this.durationParam_.objectValue(env);
        final PrintStream errStream = env.getErrorStream();
        return new TableMapping(){

            @Override
            public StarTable mapTables(InputTableSpec[] inSpecs) throws TaskException, IOException {
                TapQuery tq = TapMapper.createTapQuery(endpointSet, adql, extraParams, upNames, inSpecs, -1L, vowriter);
                UwsJob tapJob = tq.submitAsync();
                if (progress) {
                    errStream.println("SUBMITTED ...");
                    errStream.println(tapJob.getJobUrl());
                }
                if (duration != null) {
                    tapJob.postExecutionDuration(duration.longValue());
                }
                if (destruction != null) {
                    tapJob.postDestruction(destruction);
                }
                tapJob.start();
                return resultProducer.waitForResult(tapJob);
            }
        };
    }

    private static TapQuery createTapQuery(EndpointSet endpointSet, String adql, Map<String, String> extraParams, String[] upNames, InputTableSpec[] inSpecs, long uploadLimit, VOTableWriter vowriter) throws IOException, TaskException {
        int nup = upNames.length;
        LinkedHashMap<String, StarTable> uploadMap = new LinkedHashMap<String, StarTable>();
        for (int iu = 0; iu < nup; ++iu) {
            uploadMap.put(upNames[iu], inSpecs[iu].getWrappedTable());
        }
        return new TapQuery(endpointSet, adql, extraParams, uploadMap, uploadLimit, vowriter);
    }

    private static Parameter createUploadNameParameter(String label) {
        StringParameter upnameParam = new StringParameter("upname" + label){

            public String stringToObject(Environment env, String inval) throws ParameterValueException {
                if (AdqlSyntax.SQL92_IDENTIFIER_REGEX.matcher(inval).matches()) {
                    return inval;
                }
                String msg = new StringBuffer().append('\"').append(inval).append('\"').append(" is not an ADQL identifier").toString();
                throw new ParameterValueException((Parameter)this, msg);
            }
        };
        upnameParam.setPrompt("Label for uploaded table #" + label);
        upnameParam.setUsage("<adql-identifier>");
        upnameParam.setDescription(new String[]{"<p>Identifier to use in server-side expressions for uploaded", "table #" + label + ".", "In ADQL expressions, the table should be referred to as", "\"<code>TAP_UPLOAD.&lt;label&gt;</code>\".", "</p>", "<p>The value must syntactically be an ADQL identifier", "(<code>[A-Za-z][A-Za-z0-9_]*</code>).", "</p>"});
        upnameParam.setStringDefault("up" + label);
        return upnameParam;
    }
}

