/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TapResultProducer;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsStage;

public class TapResultReader {
    private final IntegerParameter pollParam_;
    private final BooleanParameter progressParam_;
    private final ChoiceParameter<DeleteMode> deleteParam_;
    private final Parameter[] parameters_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public TapResultReader() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.pollParam_ = new IntegerParameter("poll");
        this.pollParam_.setPrompt("Polling interval in milliseconds");
        int minPoll = 50;
        this.pollParam_.setMinimum(minPoll);
        this.pollParam_.setDescription(new String[]{"<p>Interval to wait between polling attempts, in milliseconds.", "Asynchronous TAP queries can only find out when they are", "complete by repeatedly polling the server to find out the", "job's status.  This parameter allows you to set how often", "that happens.", "Attempts to set it too low (&lt;" + minPoll + ")", "will be rejected on the assumption that you're thinking in", "seconds.", "</p>"});
        this.pollParam_.setUsage("<millisec>");
        this.pollParam_.setIntDefault(5000);
        paramList.add(this.pollParam_);
        this.progressParam_ = new BooleanParameter("progress");
        this.progressParam_.setPrompt("Report on query progress");
        this.progressParam_.setDescription(new String[]{"<p>If this parameter is set true, progress of the job is", "reported to standard output as it happens.", "</p>"});
        this.progressParam_.setBooleanDefault(true);
        paramList.add(this.progressParam_);
        this.deleteParam_ = new ChoiceParameter("delete", (Object[])DeleteMode.values());
        this.deleteParam_.setPrompt("Delete job on exit?");
        this.deleteParam_.setDescription(new String[]{"<p>Determines under what circumstances the UWS job is to be", "deleted from the server when its data is no longer required.", "If it is not deleted, then the job is left on the TAP server", "and it can be accessed via the normal UWS REST endpoints", "until it is destroyed by the server.", "</p>", "<p>Possible values:", "<ul>", DeleteMode.getListItems(), "</ul>", "</p>"});
        this.deleteParam_.setDefaultOption((Object)DeleteMode.finished);
        paramList.add(this.deleteParam_);
        this.parameters_ = paramList.toArray(new Parameter[0]);
    }

    public Parameter[] getParameters() {
        return this.parameters_;
    }

    public BooleanParameter getProgressParameter() {
        return this.progressParam_;
    }

    public TapResultProducer createResultProducer(Environment env, final ContentCoding coding) throws TaskException {
        final int pollMillis = this.pollParam_.intValue(env);
        final boolean progress = this.progressParam_.booleanValue(env);
        final PrintStream errStream = env.getErrorStream();
        final DeleteMode delete = (DeleteMode)((Object)this.deleteParam_.objectValue(env));
        final StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        return new TapResultProducer(){
            private Thread deleteThread;
            private String lastPhase;

            @Override
            public StarTable waitForResult(final UwsJob tapJob) throws IOException {
                StarTable table;
                UwsJob.JobWatcher progger = null;
                if (progress) {
                    progger = new UwsJob.JobWatcher(){

                        public void jobUpdated(UwsJob job, UwsJobInfo info) {
                            this.logPhase(info.getPhase());
                        }
                    };
                    tapJob.addJobWatcher(progger);
                }
                if (delete.isDeletionPossible()) {
                    this.deleteThread = new Thread("UWS job deleter"){

                        @Override
                        public void run() {
                            this.considerDeletion(tapJob);
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(this.deleteThread);
                }
                try {
                    table = TapQuery.waitForResult((UwsJob)tapJob, (ContentCoding)coding, (StoragePolicy)tfact.getStoragePolicy(), (long)pollMillis);
                }
                catch (InterruptedException e) {
                    this.considerDeletionEarly(tapJob);
                    throw (IOException)new InterruptedIOException("Interrupted").initCause(e);
                }
                catch (IOException e) {
                    this.considerDeletionEarly(tapJob);
                    throw e;
                }
                assert ("COMPLETED".equals(tapJob.getLastInfo().getPhase()));
                if (!delete.isDeletionPossible()) {
                    return table;
                }
                if (table.isRandom()) {
                    this.considerDeletionEarly(tapJob);
                    return table;
                }
                return new WrapperStarTable(table){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void finalize() throws Throwable {
                        try {
                            this.considerDeletionEarly(tapJob);
                        }
                        finally {
                            super.finalize();
                        }
                    }
                };
            }

            private void considerDeletionEarly(UwsJob uwsJob) {
                if (this.deleteThread != null) {
                    Runtime.getRuntime().removeShutdownHook(this.deleteThread);
                }
                this.considerDeletion(uwsJob);
            }

            private void considerDeletion(UwsJob uwsJob) {
                UwsStage stage = UwsStage.forPhase((String)uwsJob.getLastInfo().getPhase());
                if (delete.shouldDelete(stage)) {
                    uwsJob.attemptDelete();
                    if (progress) {
                        errStream.println("DELETED");
                        errStream.flush();
                    }
                }
            }

            private void logPhase(String phase) {
                if (!phase.equals(this.lastPhase)) {
                    String txt = phase;
                    if (UwsStage.forPhase((String)phase) != UwsStage.FINISHED) {
                        txt = txt + " ...";
                    }
                    errStream.println(txt);
                    errStream.flush();
                }
                this.lastPhase = phase;
            }
        };
    }

    private static enum DeleteMode {
        finished("delete only if the job finished, successfully or not", true){

            @Override
            public boolean shouldDelete(UwsStage stage) {
                return stage == UwsStage.FINISHED;
            }
        }
        ,
        never("do not delete", false){

            @Override
            public boolean shouldDelete(UwsStage stage) {
                return false;
            }
        }
        ,
        always("delete in any case", true){

            @Override
            public boolean shouldDelete(UwsStage stage) {
                return true;
            }
        };

        private final String description_;
        private final boolean isDeletionPossible_;

        private DeleteMode(String description, boolean isDeletionPossible) {
            this.description_ = description;
            this.isDeletionPossible_ = isDeletionPossible;
        }

        public abstract boolean shouldDelete(UwsStage var1);

        public boolean isDeletionPossible() {
            return this.isDeletionPossible_;
        }

        public static String getListItems() {
            StringBuffer sbuf = new StringBuffer();
            for (DeleteMode dMode : Arrays.asList(DeleteMode.values())) {
                sbuf.append("<li>").append("<code>").append(dMode.toString()).append("</code>").append(": ").append(dMode.description_).append("</li>").append('\n');
            }
            return sbuf.toString();
        }
    }
}

