/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.LongParameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.BlockUploader;
import uk.ac.starlink.ttools.cone.JELQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.ServiceFindMode;
import uk.ac.starlink.ttools.cone.TapUploadMatcher;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.JoinFixActionParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.TapEndpointParams;
import uk.ac.starlink.ttools.task.UserFindMode;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.EndpointSet;

public class TapUploadSkyMatch
extends SingleMapperTask {
    private final StringParameter inlonParam_;
    private final StringParameter inlatParam_;
    private final StringParameter srParam_;
    private final TapEndpointParams endpointParams_;
    private final StringParameter taptableParam_;
    private final StringParameter taplonParam_;
    private final StringParameter taplatParam_;
    private final StringMultiParameter tapcolsParam_;
    private final ChoiceParameter<UserFindMode> findParam_;
    private final IntegerParameter chunkParam_;
    private final IntegerParameter maxrecParam_;
    private final BooleanParameter syncParam_;
    private final LongParameter tapmaxrecParam_;
    private final ContentCodingParameter codingParam_;
    private final JoinFixActionParameter fixcolsParam_;
    private final StringParameter insuffixParam_;
    private final StringParameter tapsuffixParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public TapUploadSkyMatch() {
        super("Crossmatches table on sky position against TAP table", new ChoiceMode(), true, true);
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.inlonParam_ = new StringParameter("inlon");
        this.inlonParam_.setUsage("<expr/deg>");
        this.inlonParam_.setPrompt("Longitude coordinate in input table");
        this.inlonParam_.setDescription(new String[]{"<p>Longitude in degrees for the position of each row", "in the input table.", "This may simply be a column name, or it may be", "an algebraic expression as explained in <ref id='jel'/>.", "The coordinate system must match that used for the", "coordinates in the remote table.", "</p>"});
        paramList.add(this.inlonParam_);
        this.inlatParam_ = new StringParameter("inlat");
        this.inlatParam_.setUsage("<expr/deg>");
        this.inlatParam_.setPrompt("Latitude coordinate in input table");
        this.inlatParam_.setDescription(new String[]{"<p>Longitude in degrees for the position of each row", "in the input table.", "This may simply be a column name, or it may be", "an algebraic expression as explained in <ref id='jel'/>.", "The coordinate system must match that used for the", "coordinates in the remote table.", "</p>"});
        paramList.add(this.inlatParam_);
        this.endpointParams_ = new TapEndpointParams("tapurl");
        paramList.add(this.endpointParams_.getBaseParameter());
        this.taptableParam_ = new StringParameter("taptable");
        this.taptableParam_.setUsage("<name>");
        this.taptableParam_.setPrompt("Name of table in TAP service");
        this.taptableParam_.setDescription(new String[]{"<p>Name of the table in the given TAP service", "against which the matching will be performed.", "</p>"});
        paramList.add(this.taptableParam_);
        this.taplonParam_ = new StringParameter("taplon");
        this.taplonParam_.setUsage("<column>");
        this.taplonParam_.setPrompt("Longitude column in TAP table");
        this.taplonParam_.setDescription(new String[]{"<p>Longitude in degrees for the position of each row", "in the remote table.", "This is an ADQL expression interpreted within the TAP service,", "typically just a column name.", "The coordinate system must match that used for the input table.", "</p>"});
        paramList.add(this.taplonParam_);
        this.taplatParam_ = new StringParameter("taplat");
        this.taplatParam_.setUsage("<column>");
        this.taplatParam_.setPrompt("Latitude column in TAP table");
        this.taplatParam_.setDescription(new String[]{"<p>Latitude in degrees for the position of each row", "in the remote table.", "This is an ADQL expression interpreted within the TAP service,", "typically just a column name.", "The coordinate system must match that used for the input table.", "</p>"});
        paramList.add(this.taplatParam_);
        this.tapcolsParam_ = new StringMultiParameter("tapcols", ',');
        this.tapcolsParam_.setUsage("<colname,...>");
        this.tapcolsParam_.setPrompt("List of columns from TAP table");
        this.tapcolsParam_.setDescription(new String[]{"<p>Comma-separated list of column names", "to retrieve from the remote table.", "If no value is supplied (the default),", "all columns from the remote table will be returned.", "</p>"});
        this.tapcolsParam_.setNullPermitted(true);
        paramList.add((Object)this.tapcolsParam_);
        this.srParam_ = new StringParameter("sr");
        this.srParam_.setPrompt("Search radius expression in degrees");
        this.srParam_.setUsage("<expr/deg>");
        this.srParam_.setDescription(new String[]{"<p>Maximum distance in degrees", "from the local table (lat,lon) position", "at which counterparts from the remote table will be identified.", "This is an ADQL expression interpreted within the TAP service,", "so it may be a constant value or may involve columns in", "the remote table.", "</p>"});
        paramList.add(this.srParam_);
        this.chunkParam_ = new IntegerParameter("blocksize");
        this.chunkParam_.setPrompt("Maximum number of rows per request");
        this.chunkParam_.setDescription(new String[]{"<p>The number of rows uploaded in each TAP query.", "TAP services may have limits on the number of rows in", "a table uploaded for matching.", "This command can therefore break up input tables into blocks", "and make a number of individual TAP queries to generate the", "result.", "This parameter controls the maximum number of rows uploaded", "in each individual request.", "For an input table with fewer rows than this value,", "the whole thing is done as a single query.", "</p>"});
        this.chunkParam_.setMinimum(1);
        this.chunkParam_.setIntDefault(5000);
        List<ServiceFindMode> serviceModes = Arrays.asList(TapUploadMatcher.getSupportedServiceModes());
        ArrayList<UserFindMode> umodeList = new ArrayList<UserFindMode>();
        for (UserFindMode userMode : UserFindMode.getInstances()) {
            if (!serviceModes.contains((Object)userMode.getServiceMode())) continue;
            umodeList.add(userMode);
        }
        Object[] userModes = umodeList.toArray(new UserFindMode[0]);
        this.findParam_ = new ChoiceParameter("find", userModes);
        this.findParam_.setPrompt("Which pair matches to include");
        StringBuffer optBuf = new StringBuffer();
        for (UserFindMode findMode : this.findParam_.getOptionValueList()) {
            optBuf.append("<li>").append("<code>").append(findMode.getName()).append("</code>: ").append(findMode.getSummary()).append("</li>").append('\n');
        }
        this.findParam_.setDescription(new String[]{"<p>Determines which pair matches are included in the result.", "<ul>", optBuf.toString(), "</ul>", "Note only the <code>" + UserFindMode.ALL + "</code> mode", "is symmetric between the two tables.", "</p>"});
        this.findParam_.setDefaultOption((Object)UserFindMode.ALL);
        paramList.add(this.findParam_);
        paramList.add(this.chunkParam_);
        this.maxrecParam_ = new IntegerParameter("maxrec");
        this.maxrecParam_.setPrompt("Maximum number of output rows");
        this.maxrecParam_.setDescription(new String[]{"<p>Limit to the number of rows resulting from this operation.", "If the value is negative (the default) no limit is imposed.", "Note however that there can be truncation of the result", "if the number of records returned from a single chunk", "exceeds limits imposed by the service.", "</p>"});
        this.maxrecParam_.setIntDefault(-1);
        paramList.add(this.maxrecParam_);
        this.syncParam_ = new BooleanParameter("sync");
        this.syncParam_.setPrompt("Submit queries in synchronous mode?");
        this.syncParam_.setDescription(new String[]{"<p>Determines whether the TAP queries are submitted", "in synchronous or asynchronous mode.", "Since this command uses chunking to keep requests to a", "reasonable size, hopefully requests will not take too", "long to execute, therefore the default is synchronous (true).", "</p>"});
        this.syncParam_.setBooleanDefault(true);
        paramList.add(this.syncParam_);
        this.tapmaxrecParam_ = new LongParameter("blockmaxrec");
        this.tapmaxrecParam_.setPrompt("MAXREC limit per block");
        this.tapmaxrecParam_.setDescription(new String[]{"<p>Sets the MAXREC parameter passed to the TAP service", "for each uploaded block.", "This allows you to request that the service overrides its", "default limit for the number of rows output from a single query.", "The service may still impose some \"hard\" limit beyond which", "the output row count cannot be increased.", "</p>", "<p>Note this differs from the", "<code>" + this.maxrecParam_.getName() + "</code>", "parameter, which gives the maximum total number of rows", "to be returned from this command.", "</p>"});
        this.tapmaxrecParam_.setUsage("<nrow>");
        this.tapmaxrecParam_.setMinimum(0L);
        this.tapmaxrecParam_.setNullPermitted(true);
        paramList.add(this.tapmaxrecParam_);
        this.codingParam_ = new ContentCodingParameter();
        paramList.add((Object)this.codingParam_);
        this.fixcolsParam_ = new JoinFixActionParameter("fixcols");
        this.insuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffixin", "the input table", "_in");
        this.tapsuffixParam_ = this.fixcolsParam_.createSuffixParameter("suffixremote", "the TAP result table", "_tap");
        paramList.add((Object)this.fixcolsParam_);
        paramList.add(this.insuffixParam_);
        paramList.add(this.tapsuffixParam_);
        this.getParameterList().addAll(paramList);
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        String inlonString = this.inlonParam_.stringValue(env);
        String inlatString = this.inlatParam_.stringValue(env);
        EndpointSet endpointSet = this.endpointParams_.getEndpointSet(env);
        String taptable = this.taptableParam_.stringValue(env);
        String taplonString = this.taplonParam_.stringValue(env);
        String taplatString = this.taplatParam_.stringValue(env);
        String[] tapcols = this.tapcolsParam_.stringsValue(env);
        if (tapcols != null && tapcols.length == 0) {
            tapcols = null;
        }
        String srString = this.srParam_.stringValue(env);
        UserFindMode userMode = (UserFindMode)this.findParam_.objectValue(env);
        ServiceFindMode serviceMode = userMode.getServiceMode();
        boolean oneToOne = userMode.isOneToOne();
        int blocksize = this.chunkParam_.intValue(env);
        long maxrec = this.maxrecParam_.intValue(env);
        boolean isSync = this.syncParam_.booleanValue(env);
        LinkedHashMap<String, String> extraParams = new LinkedHashMap<String, String>();
        Long tapmaxrec = (Long)this.tapmaxrecParam_.objectValue(env);
        if (tapmaxrec != null) {
            extraParams.put("MAXREC", tapmaxrec.toString());
        }
        ContentCoding coding = this.codingParam_.codingValue(env);
        TapUploadMatcher umatcher = new TapUploadMatcher(endpointSet, taptable, taplonString, taplatString, srString, isSync, tapcols, serviceMode, extraParams, coding);
        final String adql = umatcher.getAdql(maxrec);
        final JELQuerySequenceFactory qsFact = new JELQuerySequenceFactory(inlonString, inlatString, "0");
        String tableName = "tapmatch(" + taptable + ")";
        JoinFixAction inFixAct = this.fixcolsParam_.getJoinFixAction(env, this.insuffixParam_);
        JoinFixAction tapFixAct = this.fixcolsParam_.getJoinFixAction(env, this.tapsuffixParam_);
        final TableProducer inProd = this.createInputProducer(env);
        final StoragePolicy storage = LineTableEnvironment.getStoragePolicy(env);
        boolean uploadEmpty = true;
        final BlockUploader blocker = new BlockUploader(umatcher, blocksize, maxrec, tableName, inFixAct, tapFixAct, serviceMode, oneToOne, uploadEmpty);
        blocker.setTruncationAdvice("Reduce " + this.chunkParam_.getName() + "? " + "Increase " + this.tapmaxrecParam_.getName() + "?");
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                StarTable inTable = Tables.randomTable((StarTable)inProd.getTable());
                logger_.info("ADQL query:\n" + adql);
                return blocker.runMatch(inTable, qsFact, storage);
            }
        };
    }
}

