/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.copy.VotCopyHandler;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.XmlEncodingParameter;
import uk.ac.starlink.ttools.votlint.VersionDetector;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.StarEntityResolver;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableVersion;

public class VotCopy
implements Task {
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    private static final String SAX_PROPERTY = "http://xml.org/sax/properties/";
    private final StringParameter inParam_ = new StringParameter("in");
    private final StringParameter outParam_;
    private final ChoiceParameter<DataFormat> formatParam_;
    private final ChoiceParameter<VOTableVersion> versionParam_;
    private final XmlEncodingParameter xencParam_;
    private final BooleanParameter cacheParam_;
    private final BooleanParameter hrefParam_;
    private final BooleanParameter nomagicParam_;
    private final StringParameter baseParam_;

    public VotCopy() {
        this.inParam_.setPosition(1);
        this.inParam_.setPrompt("Input votable");
        this.inParam_.setUsage("<location>");
        this.inParam_.setStringDefault("-");
        this.inParam_.setDescription(new String[]{"<p>Location of the input VOTable.", "May be a URL, filename, or \"-\" to indicate standard input.", "The input table may be compressed using one of the known", "compression formats (Unix compress, gzip or bzip2).", "</p>"});
        this.outParam_ = new StringParameter("out");
        this.outParam_.setPosition(2);
        this.outParam_.setPrompt("Output votable");
        this.outParam_.setUsage("<location>");
        this.outParam_.setStringDefault("-");
        this.outParam_.setDescription(new String[]{"<p>Location of the output VOTable.", "May be a filename or \"-\" to indicate standard output.", "</p>"});
        this.formatParam_ = new ChoiceParameter("format", (Object[])new DataFormat[]{DataFormat.TABLEDATA, DataFormat.BINARY, DataFormat.BINARY2, DataFormat.FITS});
        this.formatParam_.setPosition(3);
        this.formatParam_.setPrompt("Output votable format");
        this.formatParam_.setNullPermitted(true);
        this.formatParam_.setDefaultOption((Object)DataFormat.TABLEDATA);
        this.formatParam_.setPreferExplicit(true);
        this.formatParam_.setDescription(new String[]{"<p>Determines the encoding format of the table data in the ", "output document.", "If <code>null</code> is selected, then the tables will be", "data-less (will contain no DATA element), leaving only", "the document structure.", "Data-less tables are legal VOTable elements.", "</p>", "<p>The <code>BINARY2</code> format is only available for", "<code>version</code>=<code>1.3</code>", "</p>"});
        this.versionParam_ = new ChoiceParameter("version", (Object[])VOTableVersion.getKnownVersions().values().toArray(new VOTableVersion[0]));
        this.versionParam_.setPrompt("Output votable version");
        this.versionParam_.setNullPermitted(true);
        this.versionParam_.setStringDefault(null);
        this.versionParam_.setDescription(new String[]{"<p>Determines the version of the VOTable standard to which", "the output will conform.", "If null (the default), the output table will have the same", "version as the input table.", "</p>"});
        this.xencParam_ = new XmlEncodingParameter("charset");
        this.cacheParam_ = new BooleanParameter("cache");
        this.cacheParam_.setPrompt("Read data into cache before copying?");
        this.cacheParam_.setDescription(new String[]{"<p>Determines whether the input tables are read into a cache", "prior to being written out.", "The default is selected automatically depending on the input", "table; so you should normally leave this flag alone.", "</p>"});
        this.hrefParam_ = new BooleanParameter("href");
        this.hrefParam_.setPrompt("Output FITS/BINARY data external to output document?");
        this.nomagicParam_ = new BooleanParameter("nomagic");
        this.nomagicParam_.setPrompt("Eliminate VALUES/null attributes where appropriate");
        this.nomagicParam_.setDescription(new String[]{"<p>Eliminate the <code>null</code> attributes of", "<code>VALUES</code> elements", "where they are no longer required.", "In VOTable versions &lt;=1.2, the only way to specify", "null values for integer-type scalar columns was to use", "the <code>null</code> attribute of the <code>VALUES</code>", "element to indicate an in-band magic value representing null.", "From VOTable v1.3, null values can be represented using", "empty <code>&lt;TD&gt;</code> elements or flagged", "specially in <code>BINARY2</code> streams.", "In these cases, it is recommended (though not required)", "not to use the <code>VALUES</code>/<code>null</code> mechanism.", "</p>", "<p>If this parameter is set true, then any", "<code>VALUES</code>/<code>null</code>", "attributes will be removed in VOTable 1.3 BINARY2 or TABLEDATA", "output.", "If this results in an empty <code>VALUES</code> element,", "it too will be removed.", "</p>", "<p>This parameter is ignored if the output VOTable version", "is lower than 1.3 or if", "<code>" + this.formatParam_.getName() + "</code>=BINARY/FITS.", "</p>"});
        this.nomagicParam_.setBooleanDefault(true);
        this.baseParam_ = new StringParameter("base");
        this.baseParam_.setUsage("<location>");
        this.baseParam_.setPrompt("Base location for FITS/BINARY href data");
        this.baseParam_.setNullPermitted(true);
        this.hrefParam_.setDescription(new String[]{"<p>In the case of BINARY or FITS encoding, this determines", "whether the STREAM elements output will contain their data", "inline or externally.", "If set false, the output document will be self-contained,", "with STREAM data inline as base64-encoded characters.", "If true, then for each TABLE in the document the binary", "data will be written to a separate file and referenced", "by an href attribute on the corresponding STREAM element.", "The name of these files is usually determined by the name", "of the main output file; but see also the <code>", this.baseParam_.getName() + "</code> flag.", "</p>"});
        this.baseParam_.setDescription(new String[]{"<p>Determines the name of external output files written when the", "<code>" + this.hrefParam_.getName() + "</code> flag is true.", "Normally these are given names based on the name of the", "output file.", "But if this flag is given, the names will be based on the", "<code>&lt;location&gt;</code> string.", "This flag is compulsory if", "<code>" + this.hrefParam_.getName() + "</code> is true", "and <code>out=-</code> (output is to standard out),", "since in this case there is no default base name to use.", "</p>"});
    }

    public String getPurpose() {
        return "Transforms between VOTable encodings";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inParam_, this.outParam_, this.formatParam_, this.versionParam_, this.xencParam_, this.cacheParam_, this.hrefParam_, this.nomagicParam_, this.baseParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        String base;
        boolean inline;
        String inLoc = this.inParam_.stringValue(env);
        String outLoc = this.outParam_.stringValue(env);
        DataFormat format = (DataFormat)this.formatParam_.objectValue(env);
        VOTableVersion forceVersion = (VOTableVersion)this.versionParam_.objectValue(env);
        if (format == DataFormat.BINARY2 && forceVersion != null && !forceVersion.allowBinary2()) {
            throw new UsageException("BINARY2 not permitted for v" + forceVersion + " - v1.3+ only");
        }
        boolean nomagic = this.nomagicParam_.booleanValue(env);
        this.cacheParam_.setBooleanDefault(format == DataFormat.FITS);
        PrintStream pstrm = env.getOutputStream();
        if (format == DataFormat.TABLEDATA || format == null) {
            inline = true;
        } else {
            if (format == DataFormat.BINARY || format == DataFormat.BINARY2) {
                this.hrefParam_.setBooleanDefault(false);
            } else if (format == DataFormat.FITS) {
                this.hrefParam_.setBooleanDefault(true);
            } else assert (false);
            boolean bl = inline = !this.hrefParam_.booleanValue(env);
        }
        if (!inline) {
            this.baseParam_.setNullPermitted(false);
            if (outLoc != null && !outLoc.equals("-")) {
                this.baseParam_.setStringDefault(new File(outLoc).getName().replaceFirst("\\.[a-zA-Z0-9]*$", ""));
            }
            base = this.baseParam_.stringValue(env);
        } else {
            base = null;
        }
        Charset xenc = (Charset)this.xencParam_.objectValue(env);
        boolean strict = LineTableEnvironment.isStrictVotable(env);
        boolean cache = this.cacheParam_.booleanValue(env);
        StoragePolicy policy = LineTableEnvironment.getStoragePolicy(env);
        return new VotCopier(inLoc, outLoc, pstrm, xenc, inline, nomagic, base, format, forceVersion, strict, cache, policy);
    }

    public static void saxCopy(InputSource saxSrc, VotCopyHandler copyHandler) throws SAXException, IOException {
        XMLReader parser = VotCopy.createParser();
        parser.setContentHandler(copyHandler);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", copyHandler);
        }
        catch (SAXException e) {
            logger_.info("Lexical handler not set: " + e);
        }
        parser.parse(saxSrc);
    }

    private static XMLReader createParser() throws SAXException {
        XMLReader parser;
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(false);
            spfact.setNamespaceAware(true);
            VotCopy.trySetFeature(spfact, "namespace-prefixes", true);
            VotCopy.trySetFeature(spfact, "external-general-entities", false);
            parser = spfact.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
        parser.setEntityResolver((EntityResolver)StarEntityResolver.getInstance());
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void warning(SAXParseException e) {
                logger_.warning(e.toString());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        return parser;
    }

    private static boolean trySetFeature(SAXParserFactory spfact, String feature, boolean value) {
        try {
            spfact.setFeature("http://xml.org/sax/features/" + feature, value);
            return true;
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        catch (SAXException e) {
            return false;
        }
    }

    private class VotCopier
    implements Executable {
        final String inLoc_;
        final String outLoc_;
        final PrintStream pstrm_;
        final Charset xenc_;
        final boolean inline_;
        final boolean nomagic_;
        final String base_;
        final DataFormat format_;
        final VOTableVersion forceVersion_;
        final boolean strict_;
        final boolean cache_;
        final StoragePolicy policy_;

        VotCopier(String inLoc, String outLoc, PrintStream pstrm, Charset xenc, boolean inline, boolean nomagic, String base, DataFormat format, VOTableVersion forceVersion, boolean strict, boolean cache, StoragePolicy policy) {
            this.inLoc_ = inLoc;
            this.outLoc_ = outLoc;
            this.pstrm_ = pstrm;
            this.xenc_ = xenc;
            this.inline_ = inline;
            this.nomagic_ = nomagic;
            this.base_ = base;
            this.format_ = format;
            this.forceVersion_ = forceVersion;
            this.strict_ = strict;
            this.cache_ = cache;
            this.policy_ = policy;
        }

        public void execute() throws IOException, ExecutionException {
            BufferedInputStream in = null;
            Writer out = null;
            try {
                String vstr;
                String systemId = this.inLoc_.equals("-") ? "." : this.inLoc_;
                in = new BufferedInputStream(DataSource.getInputStream((String)this.inLoc_));
                Object version = this.forceVersion_ != null ? this.forceVersion_ : ((vstr = VersionDetector.getVersionString(in)) == null ? null : (VOTableVersion)VOTableVersion.getKnownVersions().get(vstr));
                if (this.format_ == DataFormat.BINARY2 && version != null && !version.allowBinary2()) {
                    throw new ExecutionException("BINARY2 not permitted for v" + version + " - v1.3+ only");
                }
                boolean squashMagic = this.nomagic_ && version != null && (this.format_ == DataFormat.BINARY2 && version.allowBinary2() || this.format_ == DataFormat.TABLEDATA && version.allowEmptyTd());
                OutputStream ostrm = this.outLoc_.equals("-") ? this.pstrm_ : new FileOutputStream(this.outLoc_);
                out = this.xenc_ == null ? new OutputStreamWriter(ostrm) : new OutputStreamWriter(ostrm, this.xenc_);
                VotCopyHandler handler = new VotCopyHandler(this.strict_, this.format_, this.forceVersion_, this.inline_, squashMagic, this.base_, this.cache_, this.policy_);
                handler.setOutput(out);
                out.write("<?xml version=\"1.0\"");
                if (this.xenc_ != null) {
                    out.write(" encoding=\"" + this.xenc_ + "\"");
                }
                out.write("?>\n");
                InputSource saxsrc = new InputSource(in);
                saxsrc.setSystemId(systemId);
                VotCopy.saxCopy(saxsrc, handler);
                out.flush();
            }
            catch (SAXException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }
}

