/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.InputStreamParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.UsageException;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.votlint.DoctypeInterpolator;
import uk.ac.starlink.ttools.votlint.VersionDetector;
import uk.ac.starlink.ttools.votlint.VotLintContext;
import uk.ac.starlink.ttools.votlint.VotLinter;
import uk.ac.starlink.util.Destination;
import uk.ac.starlink.votable.VOTableVersion;

public class VotLint
implements Task {
    private final InputStreamParameter inParam_ = new InputStreamParameter("votable");
    private final BooleanParameter validParam_;
    private final ChoiceParameter<VOTableVersion> versionParam_;
    private final OutputStreamParameter outParam_;

    public VotLint() {
        this.inParam_.setStringDefault("-");
        this.inParam_.setPosition(1);
        this.inParam_.setPrompt("VOTable location");
        this.inParam_.setDescription(new String[]{"<p>Location of the VOTable to be checked.", "This may be a filename, URL or \"-\" (the default),", "to indicate standard input.", "The input may be compressed using one of the known", "compression formats (Unix compress, gzip or bzip2).", "</p>"});
        this.validParam_ = new BooleanParameter("validate");
        this.validParam_.setBooleanDefault(true);
        this.validParam_.setPrompt("Validate against VOTable DTD?");
        this.validParam_.setDescription(new String[]{"<p>Whether to validate the input document aganist", "the VOTable DTD.", "If true (the default), then as well as", "<code>votlint</code>'s own checks,", "it is validated against an appropriate version of the VOTable", "DTD which picks up such things as the presence of", "unknown elements and attributes, elements in the wrong place,", "and so on.", "Sometimes however, particularly when XML namespaces are", "involved, the validator can get confused and may produce", "a lot of spurious errors.  Setting this flag false prevents", "this validation step so that only <code>votlint</code>'s", "own checks are performed.", "In this case many violations of the VOTable standard", "concerning document structure will go unnoticed.", "</p>"});
        this.versionParam_ = new ChoiceParameter("version", (Object[])VOTableVersion.getKnownVersions().values().toArray(new VOTableVersion[0]));
        this.versionParam_.setNullPermitted(true);
        this.versionParam_.setPrompt("VOTable standard version");
        this.versionParam_.setDescription(new String[]{"<p>Selects the version of the VOTable standard which the input", "table is supposed to exemplify.", "The version may also be specified within the document", "using the \"version\" attribute of the document's VOTABLE", "element; if it is and it conflicts with the value specified", "by this flag, a warning is issued.", "</p>", "<p>If no value is provided for this parameter (the default),", "the version will be determined from the VOTable itself.", "</p>"});
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPrompt("File for output messages");
        this.outParam_.setUsage("<location>");
        this.outParam_.setStringDefault("-");
        this.outParam_.setDescription(new String[]{"<p>Destination file for output messages.", "May be a filename or \"-\" to indicate standard output.", "</p>"});
    }

    public String getPurpose() {
        return "Validates VOTable documents";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inParam_, this.validParam_, this.versionParam_, this.outParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        PrintStream out;
        VOTableVersion version = (VOTableVersion)this.versionParam_.objectValue(env);
        boolean validate = this.validParam_.booleanValue(env);
        boolean debug = env instanceof TableEnvironment && ((TableEnvironment)env).isDebug();
        String sysid = this.inParam_.stringValue(env);
        InputStream in = (InputStream)this.inParam_.objectValue(env);
        try {
            out = new PrintStream(((Destination)this.outParam_.objectValue(env)).createStream());
        }
        catch (IOException e) {
            throw new UsageException("Can't open \"" + this.outParam_.stringValue(env) + "\" for output: " + e.getMessage(), (Throwable)e);
        }
        return new VotLintExecutable(in, version, validate, debug, sysid, out);
    }

    private class VotLintExecutable
    implements Executable {
        final InputStream baseIn_;
        final VOTableVersion forceVersion_;
        final boolean validate_;
        final boolean debug_;
        final String sysid_;
        final PrintStream out_;

        VotLintExecutable(InputStream in, VOTableVersion forceVersion, boolean validate, boolean debug, String sysid, PrintStream out) {
            this.baseIn_ = in;
            this.forceVersion_ = forceVersion;
            this.validate_ = validate;
            this.debug_ = debug;
            this.sysid_ = sysid;
            this.out_ = out;
        }

        public void execute() throws IOException, ExecutionException {
            VOTableVersion version;
            BufferedInputStream bufIn = new BufferedInputStream(this.baseIn_);
            if (this.forceVersion_ != null) {
                version = this.forceVersion_;
            } else {
                String foundVersStr = VersionDetector.getVersionString(bufIn);
                VOTableVersion foundVersion = (VOTableVersion)VOTableVersion.getKnownVersions().get(foundVersStr);
                if (foundVersion != null) {
                    version = foundVersion;
                } else {
                    VotLintContext preContext = new VotLintContext(null, this.validate_, this.debug_, this.out_);
                    preContext.info("Unable to determine VOTable version from document");
                    version = VOTableVersion.getDefaultVersion();
                    preContext.info("Assuming VOTable v" + version + " by default");
                }
            }
            assert (version != null);
            final VotLintContext context = new VotLintContext(version, this.validate_, this.debug_, this.out_);
            InputStream in = this.validate_ && version.getDoctypeDeclaration() != null ? new DoctypeInterpolator(){

                @Override
                public void message(String msg) {
                    context.info(msg);
                }
            }.getStreamWithDoctype(bufIn) : bufIn;
            InputSource sax = new InputSource(in);
            sax.setSystemId(this.sysid_);
            try {
                new VotLinter(context).createParser(this.validate_).parse(sax);
            }
            catch (SAXException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

