/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.task.WordParser;

public class WordsParameter
extends Parameter<String[]> {
    private int nWords_ = -1;
    private WordParser parser_;

    public WordsParameter(String name) {
        super(name, String[].class, false);
    }

    public void setRequiredWordCount(int nWords) {
        this.nWords_ = nWords;
    }

    public int getRequiredWordCount() {
        return this.nWords_;
    }

    public void setWordParser(WordParser parser) {
        this.parser_ = parser;
    }

    public WordParser getWordParser() {
        return this.parser_;
    }

    public void setWordUsage(String wordUsage) {
        StringBuffer ubuf = new StringBuffer(wordUsage);
        if (this.nWords_ > 0) {
            for (int i = 1; i < this.nWords_; ++i) {
                ubuf.append(' ').append(wordUsage);
            }
        } else {
            ubuf.append(" ...");
        }
        this.setUsage(ubuf.toString());
    }

    public String[] wordsValue(Environment env) throws TaskException {
        return (String[])this.objectValue(env);
    }

    public Object[] parsedWordsValue(Environment env) throws TaskException {
        return this.parseWords((String[])this.objectValue(env));
    }

    public String[] stringToObject(Environment env, String sval) throws TaskException {
        String[] svals = this.stringToWords(sval);
        this.parseWords(svals);
        return svals;
    }

    private String[] stringToWords(String sval) throws TaskException {
        String[] words = Tokenizer.tokenizeWords(sval);
        if (this.nWords_ >= 0 && this.nWords_ != words.length) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("Wrong number of words - wanted ").append(this.nWords_).append(", got ").append(words.length);
            throw new ParameterValueException((Parameter)this, sbuf.toString());
        }
        return words;
    }

    private Object[] parseWords(String[] words) throws TaskException {
        if (words == null) {
            return null;
        }
        WordParser parser = this.getWordParser();
        if (parser != null) {
            Object[] parsedWords = new Object[words.length];
            for (int i = 0; i < words.length; ++i) {
                try {
                    parsedWords[i] = parser.parseWord(words[i]);
                    continue;
                }
                catch (TaskException e) {
                    StringBuffer msg = new StringBuffer(e.getMessage()).append(" in word \"").append(words[i]).append('\"');
                    throw new ParameterValueException((Parameter)this, msg.toString(), (Throwable)e);
                }
            }
            return parsedWords;
        }
        return words;
    }
}

