/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.ExtraParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class XmlEncodingParameter
extends Parameter<Charset>
implements ExtraParameter {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public XmlEncodingParameter(String name) {
        super(name, Charset.class, true);
        this.setUsage("<xml-encoding>");
        this.setNullPermitted(true);
        String dflt = "UTF-8";
        try {
            Charset.forName(dflt);
            this.setStringDefault(dflt);
        }
        catch (UnsupportedCharsetException e) {
            logger_.log(Level.WARNING, "Unsupported charset " + dflt + "???", e);
        }
        this.setDescription(new String[]{"<p>Selects the Unicode encoding used for the output XML.", "The available options are dependent on your JVM,", "use <code>help=" + this.getName() + "</code> for a full listing.", "Setting the value null will use the JVM's system default.", "</p>"});
    }

    @Override
    public String getExtraUsage(TableEnvironment env) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('\n').append("   Supported encodings:\n");
        Iterator<String> it = Charset.availableCharsets().keySet().iterator();
        while (it.hasNext()) {
            sbuf.append("      ").append(it.next().toString()).append('\n');
        }
        return sbuf.toString();
    }

    public Charset stringToObject(Environment env, String sval) throws TaskException {
        try {
            return Charset.forName(sval);
        }
        catch (UnsupportedCharsetException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
        catch (IllegalCharsetNameException e) {
            throw new ParameterValueException((Parameter)this, (Throwable)e);
        }
    }
}

