/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import uk.ac.starlink.ttools.votlint.FieldHandler;
import uk.ac.starlink.ttools.votlint.StreamingHandler;
import uk.ac.starlink.ttools.votlint.ValueParser;
import uk.ac.starlink.ttools.votlint.VotLintContext;

public class BinaryHandler
extends StreamingHandler {
    private final boolean isBinary2_;

    public BinaryHandler(boolean isBinary2) {
        this.isBinary2_ = isBinary2;
    }

    @Override
    public void feed(InputStream in) throws IOException {
        FieldHandler[] fields = this.getFields();
        int ncol = fields.length;
        ValueParser[] parsers = new ValueParser[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            parsers[icol] = fields[icol].getParser();
            if (parsers[icol] != null) continue;
            this.warning("Can't validate stream with unidentified column " + fields[icol]);
            throw new IOException("No stream validation");
        }
        VotLintContext context = this.getContext();
        int nflag = this.isBinary2_ ? (ncol + 7) / 8 : 0;
        PushbackInputStream pushIn = new PushbackInputStream(in);
        int b;
        while ((b = pushIn.read()) >= 0) {
            pushIn.unread(b);
            if (nflag > 0) {
                ValueParser.slurpStream(pushIn, nflag, context);
            }
            for (int icol = 0; icol < ncol; ++icol) {
                parsers[icol].checkStream(pushIn);
            }
            this.foundRow();
        }
        return;
    }
}

