/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.IOException;
import java.io.InputStream;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.ttools.votlint.FieldHandler;
import uk.ac.starlink.ttools.votlint.StreamingHandler;
import uk.ac.starlink.ttools.votlint.ValueParser;

public class FitsHandler
extends StreamingHandler
implements TableSink {
    @Override
    public void feed(InputStream in) throws IOException {
        String extnum = this.getAttribute("extnum");
        if (extnum != null && extnum.trim().length() > 0) {
            try {
                int en = Integer.parseInt(extnum);
                if (en <= 0) {
                    this.error("Non-positive extension number extnum=" + en);
                    extnum = null;
                }
            }
            catch (NumberFormatException e) {
                this.error("Bad extension number extnum='" + extnum + "'");
                extnum = null;
            }
        }
        new FitsTableBuilder().streamStarTable(in, (TableSink)this, extnum);
        byte[] buffer = new byte[16384];
        while (in.read(buffer) > 0) {
        }
    }

    private void checkConsistent(FieldHandler vField, ColumnInfo cinfo) {
        int fSize;
        Class fClass;
        ValueParser vParser = vField.getParser();
        Class vClass = vParser.getContentClass();
        if (!vClass.equals(fClass = cinfo.getContentClass())) {
            this.warning("VOTable/FITS type mismatch for column " + vField.getRef() + " (" + vClass.getName() + " != " + fClass.getName() + ")");
        }
        int vSize = vParser.getElementCount();
        if (cinfo.isArray()) {
            fSize = 1;
            int[] shape = cinfo.getShape();
            for (int i = 0; fSize > 0 && i < shape.length; fSize *= shape[i], ++i) {
            }
        } else {
            fSize = 1;
        }
        if (vSize > 0 && fSize > 0 && vSize != fSize) {
            this.warning("VOTable/FITS array size mismatch for column " + vField.getRef() + " (" + vSize + " != " + fSize + ")");
        }
    }

    public void acceptMetadata(StarTable meta) {
        FieldHandler[] fields;
        int ncol = meta.getColumnCount();
        if (ncol != (fields = this.getFields()).length) {
            this.warning("FITS table has " + ncol + " columns and VOTable has " + fields.length + " - no type checking done");
        } else {
            for (int icol = 0; icol < ncol; ++icol) {
                this.checkConsistent(fields[icol], meta.getColumnInfo(icol));
            }
        }
    }

    public void acceptRow(Object[] row) {
        this.foundRow();
    }

    public void endRows() {
    }
}

