/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import uk.ac.starlink.ttools.votlint.AttributeChecker;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.ElementRef;
import uk.ac.starlink.ttools.votlint.VotLintContext;

public class RefChecker
implements AttributeChecker {
    private final Set legalReferents_;

    public RefChecker(String[] legalReferents) {
        this.legalReferents_ = new HashSet<String>(Arrays.asList(legalReferents));
    }

    public RefChecker(String legalReferent) {
        this(new String[]{legalReferent});
    }

    @Override
    public void check(String id, ElementHandler handler) {
        ElementRef from = handler.getRef();
        handler.getContext().registerRef(id, from, this);
    }

    public void checkLink(VotLintContext context, String id, ElementRef from, ElementRef to) {
        String toName = to.getName();
        String fromName = from.getName();
        if (!this.legalReferents_.contains(toName)) {
            context.warning(fromName + " has ref '" + id + "' to element type " + toName + " - is this meaningful?");
        }
    }
}

