/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.ttools.votlint.ElementHandler;
import uk.ac.starlink.ttools.votlint.VotLintContext;

public abstract class ValueParser {
    private VotLintContext context_;
    private static final Pattern DOUBLE_REGEX = Pattern.compile("([+-])?[0-9]*([0-9]|[0-9]\\.|\\.[0-9])[0-9]*([Ee][+-]?[0-9]{1,3})?");

    public abstract void checkString(String var1);

    public abstract void checkStream(InputStream var1) throws IOException;

    public abstract Class getContentClass();

    public abstract int getElementCount();

    public void setContext(VotLintContext context) {
        this.context_ = context;
    }

    public VotLintContext getContext() {
        return this.context_;
    }

    public void info(String msg) {
        this.getContext().info(msg);
    }

    public void warning(String msg) {
        this.getContext().warning(msg);
    }

    public void error(String msg) {
        this.getContext().error(msg);
    }

    public static ValueParser makeParser(ElementHandler handler, String datatype, String arraysize) {
        int i;
        int[] shape;
        if (datatype == null || datatype.trim().length() == 0) {
            handler.error("No datatype specified for " + handler + " Can't parse values");
            return null;
        }
        if (arraysize == null || arraysize.trim().length() == 0) {
            shape = new int[]{1};
            if ("char".equals(datatype) || "unicodeChar".equals(datatype)) {
                handler.info("No arraysize for character, " + handler + " implies single character");
            }
        } else {
            String[] dims = arraysize.split("x");
            shape = new int[dims.length];
            for (i = 0; i < dims.length; ++i) {
                if (i == dims.length - 1 && dims[i].endsWith("*")) {
                    String num = dims[i].substring(0, dims[i].length() - 1);
                    if (num.length() > 0) {
                        try {
                            Integer.parseInt(num);
                        }
                        catch (NumberFormatException e) {
                            handler.error("Bad arraysize value '" + arraysize + "'");
                        }
                    }
                    shape[i] = -1;
                    continue;
                }
                try {
                    shape[i] = Integer.parseInt(dims[i]);
                }
                catch (NumberFormatException e) {
                    handler.error("Bad arraysize value '" + arraysize + "'");
                    return null;
                }
                if (shape[i] > 0) continue;
                handler.error("Non-positive dimensions element " + shape[i]);
                return null;
            }
        }
        int nel = 1;
        for (i = 0; i < shape.length; ++i) {
            nel *= shape[i];
        }
        if ("char".equals(datatype) || "unicodeChar".equals(datatype)) {
            boolean ascii = "char".equals(datatype);
            int stringLeng = shape[0];
            if (nel == 1) {
                return new SingleCharParser(ascii);
            }
            if (shape.length == 1) {
                if (stringLeng < 0) {
                    return new VariableCharParser(ascii);
                }
                return new FixedCharParser(ascii, stringLeng);
            }
            if (nel < 0) {
                return new VariableCharArrayParser(ascii);
            }
            return new FixedCharArrayParser(ascii, nel, stringLeng);
        }
        if ("bit".equals(datatype)) {
            if (nel < 0) {
                return new VariableBitParser();
            }
            return new FixedBitParser(nel);
        }
        if ("floatComplex".equals(datatype)) {
            if (nel < 0) {
                return new VariableArrayParser(new FloatParser(), float[].class);
            }
            return new FixedArrayParser(new FloatParser(), float[].class, nel * 2);
        }
        if ("doubleComplex".equals(datatype)) {
            if (nel < 0) {
                return new VariableArrayParser(new DoubleParser(), double[].class);
            }
            return new FixedArrayParser(new DoubleParser(), double[].class, nel * 2);
        }
        if (nel == 1) {
            return ValueParser.makeScalarParser(datatype, handler);
        }
        ValueParser base = ValueParser.makeScalarParser(datatype, handler);
        if (base == null) {
            return null;
        }
        Class clazz = ValueParser.getArrayClass(base.getContentClass());
        return nel < 0 ? new VariableArrayParser(base, clazz) : new FixedArrayParser(base, clazz, nel);
    }

    private static ValueParser makeScalarParser(String datatype, ElementHandler handler) {
        if ("boolean".equals(datatype)) {
            return new BooleanParser();
        }
        if ("unsignedByte".equals(datatype)) {
            return new IntegerParser(1, 0L, 255L, Short.class);
        }
        if ("short".equals(datatype)) {
            return new IntegerParser(2, -32768L, 32767L, Short.class);
        }
        if ("int".equals(datatype)) {
            return new IntegerParser(4, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class);
        }
        if ("long".equals(datatype)) {
            return new IntegerParser(8, Long.MIN_VALUE, Long.MAX_VALUE, Long.class);
        }
        if ("float".equals(datatype)) {
            return new FloatParser();
        }
        if ("double".equals(datatype)) {
            return new DoubleParser();
        }
        handler.error("Unknown datatype '" + datatype + "'" + " - can't parse column");
        return null;
    }

    void slurpStream(InputStream in, int nbyte) throws IOException {
        ValueParser.slurpStream(in, nbyte, this.getContext());
    }

    public static void slurpStream(InputStream in, int nbyte, VotLintContext context) throws IOException {
        for (int i = 0; i < nbyte; ++i) {
            if (in.read() >= 0) continue;
            context.error("Stream ended during data read; done " + i + "/" + nbyte);
            throw new EOFException();
        }
    }

    int readCount(InputStream in) throws IOException {
        int c1 = in.read();
        int c2 = in.read();
        int c3 = in.read();
        int c4 = in.read();
        if (c1 < 0 || c2 < 0 || c3 < 0 || c4 < 0) {
            this.error("End of stream while reading element count (probable stream corruption)");
            throw new EOFException();
        }
        int count = (c1 & 0xFF) << 24 | (c2 & 0xFF) << 16 | (c3 & 0xFF) << 8 | (c4 & 0xFF) << 0;
        if (count < 0) {
            this.error("Apparent negative element count (probably stream corruption)");
            throw new IOException("Unrecoverable stream error");
        }
        return count;
    }

    private static Class getArrayClass(Class wclazz) {
        if (wclazz == Boolean.class) {
            return boolean[].class;
        }
        if (wclazz == Character.class) {
            return char[].class;
        }
        if (wclazz == Byte.class) {
            return byte[].class;
        }
        if (wclazz == Short.class) {
            return short[].class;
        }
        if (wclazz == Integer.class) {
            return int[].class;
        }
        if (wclazz == Long.class) {
            return long[].class;
        }
        if (wclazz == Float.class) {
            return float[].class;
        }
        if (wclazz == Double.class) {
            return double[].class;
        }
        assert (false);
        return Array.newInstance(wclazz, 0).getClass();
    }

    private static class FixedCharArrayParser
    extends AbstractParser {
        final boolean ascii_;
        final int nchar_;

        FixedCharArrayParser(boolean ascii, int nchar, int stringLeng) {
            super(String[].class, nchar / stringLeng);
            this.ascii_ = ascii;
            this.nchar_ = nchar;
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.nchar_ * (this.ascii_ ? 1 : 2));
        }

        @Override
        public void checkString(String text) {
            int leng = text.length();
            if (text.length() != this.nchar_) {
                this.warning("Wrong number of characters in string (" + leng + " found, " + this.nchar_ + " expected)");
            }
        }
    }

    private static class VariableCharArrayParser
    extends AbstractParser {
        final boolean ascii_;

        VariableCharArrayParser(boolean ascii) {
            super(String[].class, -1);
            this.ascii_ = ascii;
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.readCount(in) * (this.ascii_ ? 1 : 2));
        }

        @Override
        public void checkString(String text) {
        }
    }

    private static class VariableCharParser
    extends AbstractParser {
        final boolean ascii_;

        VariableCharParser(boolean ascii) {
            super(String.class, 1);
            this.ascii_ = ascii;
        }

        @Override
        public void checkString(String text) {
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.readCount(in) * (this.ascii_ ? 1 : 2));
        }
    }

    private static class FixedCharParser
    extends SlurpParser {
        public FixedCharParser(boolean ascii, int count) {
            super(count * (ascii ? 1 : 2), String.class, 1);
        }

        @Override
        public void checkString(String text) {
        }
    }

    private static class SingleCharParser
    extends SlurpParser {
        private final boolean ascii_;

        public SingleCharParser(boolean ascii) {
            super(ascii ? 1 : 2, Character.class, 1);
            this.ascii_ = ascii;
        }

        @Override
        public void checkString(String text) {
            int leng = text.length();
            switch (leng) {
                case 0: {
                    this.warning("Empty character value is questionable");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.warning("Characters after first in char scalar ignored (missing arraysize?)");
                }
            }
            if (this.ascii_ && leng > 0 && text.charAt(0) > '\u007f') {
                this.error("Non-ascii character in 'char' data");
            }
        }
    }

    private static class VariableBitParser
    extends AbstractParser {
        public VariableBitParser() {
            super(boolean[].class, -1);
        }

        @Override
        public void checkString(String text) {
            int leng = text.length();
            block3: for (int i = 0; i < leng; ++i) {
                switch (text.charAt(i)) {
                    case '\n': 
                    case ' ': 
                    case '0': 
                    case '1': {
                        continue block3;
                    }
                    default: {
                        this.error("Bad value for bit vector " + text);
                        return;
                    }
                }
            }
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, (1 + this.readCount(in)) / 8);
        }
    }

    private static class FixedBitParser
    extends SlurpParser {
        final int count_;

        FixedBitParser(int count) {
            super((count + 7) / 8, Boolean.class, count);
            this.count_ = count;
        }

        @Override
        public void checkString(String text) {
            int leng = text.length();
            int nbit = 0;
            block4: for (int i = 0; i < leng; ++i) {
                switch (text.charAt(i)) {
                    case '0': 
                    case '1': {
                        ++nbit;
                        continue block4;
                    }
                    case '\n': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        this.error("Bad value for bit vector " + text);
                        return;
                    }
                }
            }
            if (nbit != this.count_) {
                this.error("Wrong number of elements in array (" + nbit + " found, " + this.count_ + " expected)");
            }
        }
    }

    private static class DoubleParser
    extends SlurpParser {
        DoubleParser() {
            super(8, Double.class, 1);
        }

        @Override
        public void checkString(String text) {
            if ("NaN".equals(text = text.trim()) || "+Inf".equals(text) || "-Inf".equals(text) || text.length() == 0) {
                return;
            }
            Matcher matcher = DOUBLE_REGEX.matcher(text);
            if (!matcher.matches()) {
                this.error("Bad double string '" + text + "'");
            }
        }
    }

    private static class FloatParser
    extends SlurpParser {
        FloatParser() {
            super(4, Float.class, 1);
        }

        @Override
        public void checkString(String text) {
            if ("NaN".equals(text = text.trim()) || "+Inf".equals(text) || "-Inf".equals(text) || text.length() == 0) {
                return;
            }
            Matcher matcher = DOUBLE_REGEX.matcher(text);
            if (!matcher.matches()) {
                this.error("Bad float string '" + text + "'");
            }
        }
    }

    private static class IntegerParser
    extends SlurpParser {
        final long minVal_;
        final long maxVal_;

        IntegerParser(int nbyte, long minVal, long maxVal, Class clazz) {
            super(nbyte, clazz, 1);
            this.minVal_ = minVal;
            this.maxVal_ = maxVal;
        }

        @Override
        public void checkString(String text) {
            long value;
            int pos;
            int leng = text.length();
            for (pos = 0; pos < leng && text.charAt(pos) == ' '; ++pos) {
            }
            if (leng - pos > 1 && text.charAt(pos + 1) == 'x' && text.charAt(pos) == '0') {
                try {
                    value = Long.parseLong(text.substring(pos + 2), 16);
                }
                catch (NumberFormatException e) {
                    this.error("Bad hexadecimal string '" + text + "'");
                    return;
                }
            }
            if (text.length() == 0) {
                if (!this.getContext().getVersion().allowEmptyTd()) {
                    this.error("Empty cell illegal for integer value");
                }
                return;
            }
            try {
                value = Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                this.error("Bad integer string '" + text + "'");
                return;
            }
            if (value < this.minVal_ || value > this.maxVal_) {
                this.error("Value " + text + " outside type range " + this.minVal_ + "..." + this.maxVal_);
            }
        }
    }

    private static class BooleanParser
    extends AbstractParser {
        public BooleanParser() {
            super(Boolean.class, 1);
        }

        @Override
        public void checkString(String text) {
            int leng = text.length();
            if (leng == 0) {
                return;
            }
            if (leng == 1) {
                switch (text.charAt(0)) {
                    case '\u0000': 
                    case ' ': 
                    case '0': 
                    case '1': 
                    case '?': 
                    case 'F': 
                    case 'T': 
                    case 'f': 
                    case 't': {
                        return;
                    }
                }
                this.error("Bad boolean value '" + text + "'");
            } else {
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("false")) {
                    return;
                }
                this.error("Bad boolean value '" + text + "'");
            }
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            char chr = (char)(0xFFFF & in.read());
            switch (chr) {
                case '\u0000': 
                case ' ': 
                case '0': 
                case '1': 
                case '?': 
                case 'F': 
                case 'T': 
                case 'f': 
                case 't': {
                    return;
                }
                case '\uffff': {
                    this.error("End of stream during read");
                    throw new EOFException();
                }
            }
            this.error("Bad boolean value '" + chr + "'");
        }
    }

    private static class VariableArrayParser
    extends AbstractParser {
        final ValueParser base_;

        VariableArrayParser(ValueParser base, Class clazz) {
            super(clazz, -1);
            this.base_ = base;
            this.base_.toString();
        }

        @Override
        public VotLintContext getContext() {
            return this.base_.getContext();
        }

        @Override
        public void setContext(VotLintContext context) {
            this.base_.setContext(context);
        }

        @Override
        public void checkString(String text) {
            StringTokenizer stok = new StringTokenizer(text);
            while (stok.hasMoreTokens()) {
                this.base_.checkString(stok.nextToken());
            }
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            int count = this.readCount(in);
            for (int i = 0; i < count; ++i) {
                try {
                    this.base_.checkStream(in);
                    continue;
                }
                catch (EOFException e) {
                    this.error("End of stream while reading " + count + " elements (probable stream corruption)");
                    throw e;
                }
            }
        }
    }

    private static class FixedArrayParser
    extends AbstractParser {
        final ValueParser base_;
        final int count_;

        FixedArrayParser(ValueParser base, Class clazz, int count) {
            super(clazz, count);
            this.base_ = base;
            this.count_ = count;
            this.base_.toString();
        }

        @Override
        public VotLintContext getContext() {
            return this.base_.getContext();
        }

        @Override
        public void setContext(VotLintContext context) {
            this.base_.setContext(context);
        }

        @Override
        public void checkString(String text) {
            StringTokenizer stok = new StringTokenizer(text);
            int ntok = stok.countTokens();
            if (ntok != this.count_) {
                this.error("Wrong number of elements in array (" + ntok + " found, " + this.count_ + " expected)");
            }
            while (stok.hasMoreTokens()) {
                this.base_.checkString(stok.nextToken());
            }
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            for (int i = 0; i < this.count_; ++i) {
                this.base_.checkStream(in);
            }
        }
    }

    private static abstract class SlurpParser
    extends ValueParser {
        private final int nbyte_;
        private final Class clazz_;
        private final int count_;

        SlurpParser(int nbyte, Class clazz, int count) {
            this.nbyte_ = nbyte;
            this.clazz_ = clazz;
            this.count_ = count;
        }

        @Override
        public Class getContentClass() {
            return this.clazz_;
        }

        @Override
        public int getElementCount() {
            return this.count_;
        }

        @Override
        public void checkStream(InputStream in) throws IOException {
            this.slurpStream(in, this.nbyte_);
        }
    }

    private static abstract class AbstractParser
    extends ValueParser {
        private final Class clazz_;
        private final int count_;

        public AbstractParser(Class clazz, int count) {
            this.clazz_ = clazz;
            this.count_ = count;
        }

        @Override
        public Class getContentClass() {
            return this.clazz_;
        }

        @Override
        public int getElementCount() {
            return this.count_;
        }
    }
}

