/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.votlint;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.ext.LexicalHandler;
import uk.ac.starlink.ttools.votlint.VotLintContext;

public class VotLintEntityResolver
implements EntityResolver,
LexicalHandler {
    private final VotLintContext context_;
    private String dtdSystemId_;
    private String dtdPublicId_;

    public VotLintEntityResolver(VotLintContext context) {
        this.context_ = context;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        this.dtdPublicId_ = publicId;
        this.dtdSystemId_ = systemId;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource saxsrc;
        if ((publicId != null && publicId.trim().length() > 0 && publicId.equals(this.dtdPublicId_) || systemId != null && systemId.trim().length() > 0 && systemId.equals(this.dtdSystemId_)) && (saxsrc = this.getVOTableDTD()) != null) {
            return saxsrc;
        }
        return null;
    }

    private InputSource getVOTableDTD() {
        InputStream in;
        URL dtdUrl = this.context_.getVersion().getDtdUrl();
        if (dtdUrl == null) {
            return null;
        }
        try {
            in = dtdUrl.openStream();
        }
        catch (IOException e) {
            if (this.context_.isValidating()) {
                this.context_.warning("Trouble opening DTD - validation may not be done");
            }
            return null;
        }
        InputSource saxsrc = new InputSource(in);
        saxsrc.setSystemId(dtdUrl.toString());
        return saxsrc;
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }
}

