/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public abstract class AbstractStarTable
implements StarTable {
    private List parameters_ = new ArrayList();
    private String name_;
    private URL url_;

    @Override
    public List getColumnAuxDataInfos() {
        TreeMap<String, ValueInfo> auxMap = new TreeMap<String, ValueInfo>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            for (DescribedValue dval : this.getColumnInfo(i).getAuxData()) {
                ValueInfo info = dval.getInfo();
                String name = info.getName();
                if (auxMap.containsKey(name)) {
                    ValueInfo oldInfo = (ValueInfo)auxMap.get(name);
                    auxMap.put(name, DefaultValueInfo.generalise(oldInfo, info));
                    continue;
                }
                auxMap.put(name, info);
            }
        }
        return Collections.unmodifiableList(new ArrayList(auxMap.values()));
    }

    @Override
    public List getParameters() {
        return this.parameters_;
    }

    public void setParameters(List parameters) {
        this.parameters_ = parameters;
    }

    @Override
    public void setParameter(DescribedValue dval) {
        DescribedValue old = this.getParameterByName(dval.getInfo().getName());
        List parameters = this.getParameters();
        if (old != null) {
            parameters.remove(old);
        }
        parameters.add(dval);
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public URL getURL() {
        return this.url_;
    }

    @Override
    public void setURL(URL url) {
        this.url_ = url;
    }

    @Override
    public DescribedValue getParameterByName(String parname) {
        for (Object item : this.getParameters()) {
            DescribedValue dval;
            if (!(item instanceof DescribedValue) || !parname.equals((dval = (DescribedValue)item).getInfo().getName())) continue;
            return dval;
        }
        return null;
    }

    public static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    @Override
    public boolean isRandom() {
        return false;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        throw new UnsupportedOperationException("No random access available");
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        int ncol = this.getColumnCount();
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = this.getCell(irow, icol);
        }
        return row;
    }

    @Override
    public abstract ColumnInfo getColumnInfo(int var1);

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract long getRowCount();

    @Override
    public abstract RowSequence getRowSequence() throws IOException;
}

