/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.ValueInfo;

public class BeanStarTable
extends RandomStarTable {
    private final Class beanClass_;
    private final Map colInfos_;
    private final Map props_;
    private PropertyDescriptor[] colProps_;
    private Object[] data_;
    private static final ValueInfo PROGNAME_INFO = new DefaultValueInfo("ProgName", String.class, "Programmatic name");
    private static final Object[] NO_ARGS = new Object[0];

    public BeanStarTable(Class clazz) throws IntrospectionException {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Can't do primitive class");
        }
        this.beanClass_ = clazz;
        PropertyDescriptor[] props = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        ArrayList<PropertyDescriptor> colPropList = new ArrayList<PropertyDescriptor>();
        this.colInfos_ = new HashMap();
        this.props_ = new HashMap();
        for (int i = 0; i < props.length; ++i) {
            PropertyDescriptor prop = props[i];
            String progName = prop.getName();
            this.props_.put(progName, prop);
            ColumnInfo colInfo = new ColumnInfo(prop.getDisplayName(), BeanStarTable.getObjectType(prop.getPropertyType()), prop.getShortDescription());
            colInfo.setAuxDatum(new DescribedValue(PROGNAME_INFO, progName));
            this.colInfos_.put(progName, colInfo);
            if (!BeanStarTable.useProperty(prop)) continue;
            colPropList.add(prop);
        }
        this.colProps_ = colPropList.toArray(new PropertyDescriptor[0]);
        this.data_ = (Object[])Array.newInstance(clazz, 0);
    }

    public void setData(Object[] data) {
        if (!this.beanClass_.isAssignableFrom(data.getClass().getComponentType())) {
            throw new ClassCastException(data.getClass().getName() + " is not " + this.beanClass_.getName() + "[]");
        }
        this.data_ = data;
    }

    public Object[] getData() {
        return this.data_;
    }

    @Override
    public long getRowCount() {
        return this.data_.length;
    }

    @Override
    public int getColumnCount() {
        return this.colProps_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return (ColumnInfo)this.colInfos_.get(this.colProps_[icol].getName());
    }

    public void setColumnInfo(String name, ValueInfo info) {
        if (!this.colInfos_.containsKey(name)) {
            throw new IllegalArgumentException("No such property " + name);
        }
        ColumnInfo cinfo = info instanceof ColumnInfo ? (ColumnInfo)info : new ColumnInfo(info);
        this.colInfos_.put(name, cinfo);
    }

    public String[] getColumnProperties() {
        String[] propNames = new String[this.colProps_.length];
        for (int i = 0; i < this.colProps_.length; ++i) {
            propNames[i] = this.colProps_[i].getName();
        }
        return propNames;
    }

    public void setColumnProperties(String[] propNames) {
        PropertyDescriptor[] props = new PropertyDescriptor[propNames.length];
        for (int i = 0; i < propNames.length; ++i) {
            String name = propNames[i];
            if (!this.props_.containsKey(name)) {
                throw new IllegalArgumentException("No such property " + name);
            }
            props[i] = (PropertyDescriptor)this.props_.get(name);
        }
        this.colProps_ = props;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.getProperty(this.data_[BeanStarTable.checkedLongToInt(irow)], this.colProps_[icol]);
    }

    private Object getProperty(Object bean, PropertyDescriptor prop) throws IOException {
        try {
            return prop.getReadMethod().invoke(bean, NO_ARGS);
        }
        catch (IllegalAccessException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Introspector said it would be OK"))).initCause(e));
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getCause();
            if (e2 instanceof IOException) {
                throw (IOException)e2;
            }
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            if (e2 instanceof Error) {
                throw (Error)e2;
            }
            throw (IOException)new IOException(e2.getMessage()).initCause(e2);
        }
    }

    private static boolean useProperty(PropertyDescriptor prop) {
        Class<?> pclazz = prop.getPropertyType();
        return prop.getReadMethod() != null && !prop.isHidden() && (pclazz == String.class || pclazz.isPrimitive());
    }

    private static Class getObjectType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
        }
        return clazz;
    }
}

