/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ColumnPermutedStarTable
extends WrapperStarTable {
    private int[] columnMap_;
    private boolean fixReadRow_;
    private boolean readRow_;
    public static final double READROW_FRACTION = 0.75;

    public ColumnPermutedStarTable(StarTable baseTable, int[] columnMap) {
        super(baseTable);
        this.setColumnMap(columnMap);
    }

    public ColumnPermutedStarTable(StarTable baseTable, int[] columnMap, boolean readRow) {
        this(baseTable, columnMap);
        this.readRow_ = readRow;
        this.fixReadRow_ = true;
    }

    public int[] getColumnMap() {
        return this.columnMap_;
    }

    public void setColumnMap(int[] columnMap) {
        this.columnMap_ = columnMap;
        if (!this.fixReadRow_) {
            this.readRow_ = (double)this.getColumnCount() / (double)this.getBaseTable().getColumnCount() > 0.75;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnMap_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.baseTable.getColumnInfo(this.columnMap_[icol]);
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        final int ncol = this.getColumnCount();
        return this.readRow_ ? new WrapperRowSequence(this.baseTable.getRowSequence()){

            @Override
            public Object getCell(int icol) throws IOException {
                return this.baseSeq.getCell(ColumnPermutedStarTable.this.columnMap_[icol]);
            }

            @Override
            public Object[] getRow() throws IOException {
                return ColumnPermutedStarTable.this.permuteRow(this.baseSeq.getRow());
            }
        } : new WrapperRowSequence(this.baseTable.getRowSequence()){

            @Override
            public Object getCell(int icol) throws IOException {
                return this.baseSeq.getCell(ColumnPermutedStarTable.this.columnMap_[icol]);
            }

            @Override
            public Object[] getRow() throws IOException {
                Object[] row = new Object[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    row[icol] = this.getCell(icol);
                }
                return row;
            }
        };
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.baseTable.getCell(irow, this.columnMap_[icol]);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        if (this.readRow_) {
            return this.permuteRow(this.baseTable.getRow(irow));
        }
        int ncol = this.columnMap_.length;
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = this.getCell(irow, icol);
        }
        return row;
    }

    private Object[] permuteRow(Object[] baseRow) {
        int ncol = this.columnMap_.length;
        Object[] row = new Object[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            row[icol] = baseRow[this.columnMap_[icol]];
        }
        return row;
    }

    public static ColumnPermutedStarTable deleteColumns(StarTable baseTable, int[] icols) {
        int nIn = baseTable.getColumnCount();
        boolean[] delFlags = new boolean[nIn];
        for (int i = 0; i < icols.length; ++i) {
            delFlags[icols[i]] = true;
        }
        int nOut = nIn;
        for (int i = 0; i < nIn; ++i) {
            if (!delFlags[i]) continue;
            --nOut;
        }
        int[] colMap = new int[nOut];
        int j = 0;
        for (int i = 0; i < nIn; ++i) {
            if (delFlags[i]) continue;
            colMap[j++] = i;
        }
        assert (j == nOut);
        return new ColumnPermutedStarTable(baseTable, colMap);
    }
}

