/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomWrapperStarTable;
import uk.ac.starlink.table.StarTable;

public class ColumnRandomWrapperStarTable
extends RandomWrapperStarTable {
    private int ncol;
    private int nrow;
    private ArrayColumn[] columns;
    private long currentRow = 0L;

    public ColumnRandomWrapperStarTable(StarTable baseTable, int nrow) throws IOException {
        super(baseTable);
        this.nrow = nrow;
        this.ncol = this.getColumnCount();
        this.columns = new ArrayColumn[this.ncol];
        for (int icol = 0; icol < this.ncol; ++icol) {
            ColumnInfo colinfo = this.getColumnInfo(icol);
            this.columns[icol] = ArrayColumn.makeColumn(colinfo, nrow);
        }
    }

    @Override
    public long getRowCount() {
        return this.nrow;
    }

    @Override
    protected synchronized void storeNextRow(Object[] row) {
        if (this.currentRow < (long)this.nrow) {
            for (int icol = 0; icol < this.ncol; ++icol) {
                this.columns[icol].storeValue(this.currentRow, row[icol]);
            }
            ++this.currentRow;
        }
    }

    @Override
    protected Object[] retrieveStoredRow(long lrow) {
        Object[] row = new Object[this.ncol];
        if (lrow < (long)this.nrow) {
            for (int icol = 0; icol < this.ncol; ++icol) {
                row[icol] = this.columns[icol].readValue(lrow);
            }
        }
        return row;
    }
}

