/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RandomStarTable;
import uk.ac.starlink.table.StarTable;

public abstract class ColumnStarTable
extends RandomStarTable {
    public List columns = new ArrayList();

    public ColumnStarTable() {
    }

    public ColumnStarTable(StarTable template) {
        this.setName(template.getName());
        this.setParameters(new ArrayList(template.getParameters()));
    }

    @Override
    public abstract long getRowCount();

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.getColumnData(icol).getColumnInfo();
    }

    @Override
    public Object getCell(long lrow, int icol) throws IOException {
        return this.getColumnData(icol).readValue(lrow);
    }

    public void setCell(long lrow, int icol, Object value) throws IOException {
        ColumnData coldata = this.getColumnData(icol);
        if (!coldata.isWritable()) {
            throw new UnsupportedOperationException("Column " + coldata + " not writable");
        }
        coldata.storeValue(lrow, value);
    }

    public ColumnData getColumnData(int icol) {
        return (ColumnData)this.columns.get(icol);
    }

    public void addColumn(ColumnData coldata) {
        this.columns.add(coldata);
    }

    public void setColumn(int icol, ColumnData coldata) {
        this.columns.set(icol, coldata);
    }

    public static ColumnStarTable makeTableWithRows(final long nrow) {
        return new ColumnStarTable(){

            @Override
            public long getRowCount() {
                return nrow;
            }
        };
    }
}

