/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.lang.reflect.Array;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public class DefaultValueInfo
implements ValueInfo {
    private String name;
    private String unitString = null;
    private String ucd = null;
    private String utype = null;
    private String description = "";
    private Class contentClass = Object.class;
    private DomainMapper[] domainMappers = new DomainMapper[0];
    private boolean isNullable = true;
    private int[] shape = new int[]{-1};
    private int elementSize = -1;
    private static Pattern trailDigits = Pattern.compile("\\.([0-9]+)$");
    private static Pattern trailSpaces = Pattern.compile("( +)$");

    public DefaultValueInfo() {
    }

    public DefaultValueInfo(String name) {
        this.name = name;
    }

    public DefaultValueInfo(String name, Class contentClass) {
        this(name);
        this.setContentClass(contentClass);
    }

    public DefaultValueInfo(String name, Class contentClass, String description) {
        this(name);
        this.setContentClass(contentClass);
        this.setDescription(description);
    }

    public DefaultValueInfo(ValueInfo base) {
        this(base.getName());
        this.setUnitString(base.getUnitString());
        this.setUCD(base.getUCD());
        this.setUtype(base.getUtype());
        this.setDescription(base.getDescription());
        this.setContentClass(base.getContentClass());
        this.setShape(base.getShape());
        this.setElementSize(base.getElementSize());
        this.setNullable(base.isNullable());
        this.setDomainMappers(base.getDomainMappers());
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setUnitString(String unitString) {
        this.unitString = unitString;
    }

    @Override
    public String getUnitString() {
        return this.unitString;
    }

    public void setUCD(String ucd) {
        this.ucd = ucd;
    }

    @Override
    public String getUCD() {
        return this.ucd;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    @Override
    public String getUtype() {
        return this.utype;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(Class contentClass) {
        if (contentClass.isPrimitive()) {
            throw new IllegalArgumentException("Primitive content class " + contentClass + " not permitted");
        }
        this.contentClass = contentClass;
        if (!this.isArray()) {
            this.setShape(null);
        } else if (this.shape == null) {
            this.setShape(new int[]{-1});
        }
    }

    @Override
    public boolean isArray() {
        return this.contentClass.isArray();
    }

    @Override
    public int[] getShape() {
        return this.shape == null ? null : (int[])this.shape.clone();
    }

    public void setShape(int[] shape) {
        if (shape != null) {
            for (int i = 0; i < shape.length - 1; ++i) {
                if (shape[i] > 0) continue;
                throw new IllegalArgumentException("Bad shape");
            }
        }
        this.shape = shape;
    }

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    public void setElementSize(int size) {
        this.elementSize = size;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public DomainMapper[] getDomainMappers() {
        return this.domainMappers;
    }

    public void setDomainMappers(DomainMapper[] domainMappers) {
        this.domainMappers = domainMappers;
    }

    public static ValueInfo generalise(ValueInfo vi1, ValueInfo vi2) {
        if (vi1.equals(vi2)) {
            return vi1;
        }
        DefaultValueInfo vi = new DefaultValueInfo(vi1){

            @Override
            public String formatValue(Object obj, int leng) {
                try {
                    return super.formatValue(obj, leng);
                }
                catch (RuntimeException e) {
                    String rep = String.valueOf(obj);
                    return rep.length() > leng ? rep.substring(0, leng) : rep;
                }
            }

            @Override
            public Object unformatString(String rep) {
                try {
                    return super.unformatString(rep);
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        };
        if (vi1.getUnitString() != null && !vi1.getUnitString().equals(vi2.getUnitString())) {
            vi.setUnitString(null);
        }
        if (vi1.getUCD() != null && !vi1.getUCD().equals(vi2.getUCD())) {
            vi.setUCD(null);
        }
        if (vi1.getDescription() != null && !vi1.getDescription().equals(vi2.getDescription())) {
            vi.setDescription("");
        }
        Class c2 = vi2.getContentClass();
        vi.setContentClass(Object.class);
        for (Class c1 = vi1.getContentClass(); c1 != null; c1 = c1.getSuperclass()) {
            if (!c1.isAssignableFrom(c2)) continue;
            vi.setContentClass(c1);
            break;
        }
        if (vi.isArray()) {
            int[] s1 = vi1.getShape();
            int[] s2 = vi2.getShape();
            if (s1 != null && s2 != null) {
                if (s1.length != s2.length) {
                    vi.setShape(new int[]{-1});
                } else {
                    int ndim = s1.length;
                    boolean same = true;
                    for (int i = 0; i < ndim - 1 && same; ++i) {
                        if (s1[i] == s2[i]) continue;
                        same = false;
                    }
                    if (same) {
                        if (ndim > 1 && s1[ndim - 1] != s2[ndim - 1]) {
                            s1[ndim - 1] = -1;
                        }
                        vi.setShape(s1);
                    } else {
                        vi.setShape(new int[]{-1});
                    }
                }
            }
        }
        if (vi1.isNullable() || vi2.isNullable()) {
            vi.setNullable(true);
        }
        return vi;
    }

    @Override
    public String formatValue(Object value, int maxLength) {
        int over;
        Matcher tmatch;
        if (maxLength <= 0) {
            return "";
        }
        if (Tables.isBlank(value)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isArray()) {
            buf.append(value == null ? "" : value.toString());
        } else {
            int[] ashape = DefaultValueInfo.getActualShape(this.shape, Array.getLength(value));
            DefaultValueInfo.appendElements(buf, value, 0, ashape, maxLength);
        }
        if (buf.length() > maxLength && (value instanceof Float || value instanceof Double) && (tmatch = trailDigits.matcher(buf)).find()) {
            over = buf.length() - maxLength;
            if (tmatch.group(1).length() > over) {
                buf.setLength(maxLength);
            }
        }
        if (buf.length() > maxLength && (tmatch = trailSpaces.matcher(buf)).lookingAt()) {
            over = buf.length() - maxLength;
            if (tmatch.group(1).length() > buf.length() - maxLength) {
                buf.setLength(maxLength);
            }
        }
        if (buf.length() > maxLength) {
            buf.setLength(Math.max(0, maxLength - 3));
            buf.append("...");
        }
        return buf.toString();
    }

    private static int appendElements(StringBuffer sb, Object array, int pos, int[] dims, int maxChars) {
        block7: {
            int leng = Array.getLength(array);
            int ndim = dims.length;
            int limit = dims[ndim - 1];
            if (sb.length() >= maxChars) break block7;
            sb.append('(');
            if (ndim == 1) {
                for (int i = 0; i < limit && sb.length() < maxChars; ++i) {
                    if (pos < leng) {
                        sb.append(Array.get(array, pos++));
                    }
                    if (i < limit - 1) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append(")");
                }
            } else {
                int[] subdims = new int[ndim - 1];
                System.arraycopy(dims, 0, subdims, 0, ndim - 1);
                for (int i = 0; i < limit && sb.length() < maxChars; ++i) {
                    pos = DefaultValueInfo.appendElements(sb, array, pos, subdims, maxChars);
                    if (i < limit - 1) {
                        sb.append(", ");
                        continue;
                    }
                    sb.append(")");
                }
            }
        }
        return pos;
    }

    public static String formatClass(Class clazz) {
        String basename;
        int ndim;
        block20: {
            int pos;
            String cname;
            block19: {
                cname = clazz.getName();
                pos = -1;
                ndim = 0;
                while (cname.charAt(++pos) == '[') {
                    ++ndim;
                }
                if (cname.length() != pos + 1) break block19;
                switch (cname.charAt(pos)) {
                    case 'B': {
                        basename = "byte";
                        break block20;
                    }
                    case 'C': {
                        basename = "char";
                        break block20;
                    }
                    case 'D': {
                        basename = "double";
                        break block20;
                    }
                    case 'F': {
                        basename = "float";
                        break block20;
                    }
                    case 'I': {
                        basename = "int";
                        break block20;
                    }
                    case 'J': {
                        basename = "long";
                        break block20;
                    }
                    case 'S': {
                        basename = "short";
                        break block20;
                    }
                    case 'Z': {
                        basename = "boolean";
                        break block20;
                    }
                    case 'V': {
                        basename = "void";
                        break block20;
                    }
                    default: {
                        throw new AssertionError((Object)("What class is " + cname + "??"));
                    }
                }
            }
            if (ndim == 0) {
                basename = cname;
            } else {
                assert (cname.charAt(pos) == 'L');
                assert (cname.charAt(cname.length() - 1) == ';');
                basename = cname.substring(pos + 1, cname.length() - 1);
            }
        }
        basename = basename.replaceFirst("^java\\.lang\\.", "");
        if (basename.equals("java.net.URL")) {
            basename = "URL";
        }
        if (basename.equals("java.net.URI")) {
            basename = "URI";
        }
        StringBuffer buf = new StringBuffer(basename);
        for (int i = 0; i < ndim; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    public static String formatShape(int[] shape) {
        if (shape == null || shape.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < shape.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            if (shape[i] <= 0) {
                buf.append('*');
                continue;
            }
            buf.append(shape[i]);
        }
        return buf.toString();
    }

    @Override
    public Object unformatString(String rep) {
        if (rep == null || rep.length() == 0) {
            return null;
        }
        Class clazz = this.getContentClass();
        if (clazz == Boolean.class) {
            return Boolean.valueOf(rep);
        }
        if (clazz == Character.class) {
            if (rep.length() == 1) {
                return new Character(rep.charAt(0));
            }
            if (rep.trim().length() == 1) {
                return new Character(rep.trim().charAt(0));
            }
            throw new IllegalArgumentException();
        }
        if (clazz == Byte.class) {
            return Byte.valueOf(rep);
        }
        if (clazz == Short.class) {
            return Short.valueOf(rep);
        }
        if (clazz == Integer.class) {
            return Integer.valueOf(rep);
        }
        if (clazz == Long.class) {
            return Long.valueOf(rep);
        }
        if (clazz == Float.class) {
            if (rep.trim().length() == 0) {
                return new Float(Float.NaN);
            }
            return Float.valueOf(rep);
        }
        if (clazz == Double.class || clazz == Number.class) {
            if (rep.trim().length() == 0) {
                return new Double(Double.NaN);
            }
            return Double.valueOf(rep);
        }
        if (clazz == String.class) {
            return rep;
        }
        throw new IllegalArgumentException("No unformatter available for " + clazz.getName());
    }

    public String toString() {
        StringBuffer typeRep = new StringBuffer();
        typeRep.append(DefaultValueInfo.formatClass(this.getContentClass()));
        int trlen = typeRep.length();
        if (typeRep.charAt(trlen - 2) == '[' && typeRep.charAt(trlen - 1) == ']') {
            typeRep.insert(trlen - 1, DefaultValueInfo.formatShape(this.getShape()));
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append("(").append(typeRep).append(")");
        if (this.getUnitString() != null && this.getUnitString().trim().length() > 0) {
            buf.append("/").append(this.getUnitString().trim());
        }
        return buf.toString();
    }

    private static int[] getActualShape(int[] basicShape, int nel) {
        int ndim;
        int[] ashape = (int[])basicShape.clone();
        if (ashape[(ndim = ashape.length) - 1] <= 0) {
            int slice = 1;
            for (int i = 0; i < ndim - 1; ++i) {
                slice *= ashape[i];
            }
            ashape[ndim - 1] = (nel + slice - 1) / slice;
        }
        return ashape;
    }
}

