/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.WrapperColumn;

public class EditableColumn
extends WrapperColumn {
    private final ColumnData base;
    private final Map changedEntries = new HashMap();

    public EditableColumn(ColumnData base) {
        super(base);
        this.base = base;
        this.setColumnInfo(new ColumnInfo(base.getColumnInfo()));
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public Object readValue(long irow) throws IOException {
        Long key = new Long(irow);
        return this.changedEntries.containsKey(key) ? this.changedEntries.get(key) : this.base.readValue(irow);
    }

    @Override
    public void storeValue(long irow, Object value) throws IOException {
        if (value == null && !this.getColumnInfo().isNullable()) {
            throw new NullPointerException("Nulls not permitted in column " + this);
        }
        if (value != null && !this.getColumnInfo().getContentClass().isAssignableFrom(value.getClass())) {
            throw new ArrayStoreException("Value " + value + " is a " + value.getClass() + " not a " + this.getColumnInfo().getContentClass());
        }
        Long key = new Long(irow);
        this.changedEntries.put(key, value);
    }
}

