/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;

public class JoinStarTable
extends AbstractStarTable {
    private final StarTable[] tables;
    private final StarTable[] tablesByColumn;
    private final int[] indicesByColumn;
    private final int[] nCols;
    private final int nTab;
    private final int nCol;
    private final boolean isRandom;
    private final ColumnInfo[] colInfos;
    private final List auxData;

    public JoinStarTable(StarTable[] tables, JoinFixAction[] fixCols) {
        int ic;
        int itab;
        this.nTab = tables.length;
        this.tables = (StarTable[])tables.clone();
        if (fixCols == null) {
            fixCols = new JoinFixAction[this.nTab];
            Arrays.fill(fixCols, JoinFixAction.NO_ACTION);
        }
        if (fixCols.length != this.nTab) {
            throw new IllegalArgumentException("Incompatible length of array arguments");
        }
        int nc = 0;
        this.nCols = new int[this.nTab];
        for (int itab2 = 0; itab2 < this.nTab; ++itab2) {
            this.nCols[itab2] = tables[itab2].getColumnCount();
            nc += this.nCols[itab2];
        }
        this.nCol = nc;
        this.tablesByColumn = new StarTable[this.nCol];
        this.indicesByColumn = new int[this.nCol];
        int icol = 0;
        for (int itab3 = 0; itab3 < this.nTab; ++itab3) {
            int ic2 = 0;
            while (ic2 < this.nCols[itab3]) {
                this.tablesByColumn[icol] = tables[itab3];
                this.indicesByColumn[icol] = ic2++;
                ++icol;
            }
        }
        assert (icol == this.nCol);
        this.colInfos = new ColumnInfo[this.nCol];
        ArrayList<String> nameList = new ArrayList<String>();
        icol = 0;
        for (itab = 0; itab < this.nTab; ++itab) {
            for (ic = 0; ic < this.nCols[itab]; ++ic) {
                this.colInfos[icol] = new ColumnInfo(tables[itab].getColumnInfo(ic));
                nameList.add(this.colInfos[icol].getName());
                ++icol;
            }
        }
        assert (icol == this.nCol);
        icol = 0;
        for (itab = 0; itab < this.nTab; ++itab) {
            for (ic = 0; ic < this.nCols[itab]; ++ic) {
                String origName = (String)nameList.remove(icol);
                assert (origName.equals(this.colInfos[icol].getName()));
                String name = fixCols[itab].getFixedName(origName, nameList);
                nameList.add(icol, origName);
                nameList.add(name);
                this.colInfos[icol].setName(name);
                ++icol;
            }
        }
        assert (icol == this.nCol);
        LinkedHashSet auxInfos = new LinkedHashSet();
        for (int itab4 = 0; itab4 < this.nTab; ++itab4) {
            auxInfos.addAll(tables[itab4].getColumnAuxDataInfos());
        }
        this.auxData = new ArrayList(auxInfos);
        LinkedHashSet params = new LinkedHashSet();
        for (int itab5 = 0; itab5 < this.nTab; ++itab5) {
            params.addAll(tables[itab5].getParameters());
        }
        this.setParameters(new ArrayList(params));
        boolean rand = true;
        for (int itab6 = 0; itab6 < this.nTab; ++itab6) {
            rand = rand && tables[itab6].isRandom();
        }
        this.isRandom = rand;
    }

    public JoinStarTable(StarTable[] tables) {
        this(tables, null);
    }

    public List getTables() {
        return Collections.unmodifiableList(Arrays.asList(this.tables));
    }

    @Override
    public int getColumnCount() {
        return this.nCol;
    }

    @Override
    public long getRowCount() {
        if (this.nTab == 0) {
            return 0L;
        }
        long nrow = Long.MAX_VALUE;
        for (int itab = 0; itab < this.nTab; ++itab) {
            nrow = Math.min(nrow, this.tables[itab].getRowCount());
        }
        return nrow;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos[icol];
    }

    @Override
    public boolean isRandom() {
        return this.isRandom;
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        return this.tablesByColumn[icol].getCell(irow, this.indicesByColumn[icol]);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        if (!this.isRandom()) {
            throw new UnsupportedOperationException("No random access");
        }
        Object[] row = new Object[this.nCol];
        int icol = 0;
        for (int itab = 0; itab < this.nTab; ++itab) {
            Object[] subrow = this.tables[itab].getRow(irow);
            System.arraycopy(subrow, 0, row, icol, this.nCols[itab]);
            icol += this.nCols[itab];
        }
        assert (icol == this.nCol);
        return row;
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return new JoinRowSequence();
    }

    private class JoinRowSequence
    implements RowSequence {
        RowSequence[] rseqs;
        RowSequence[] rseqsByColumn;

        JoinRowSequence() throws IOException {
            this.rseqs = new RowSequence[JoinStarTable.this.nTab];
            this.rseqsByColumn = new RowSequence[JoinStarTable.this.nCol];
            int icol = 0;
            for (int itab = 0; itab < JoinStarTable.this.nTab; ++itab) {
                this.rseqs[itab] = JoinStarTable.this.tables[itab].getRowSequence();
                for (int ic = 0; ic < JoinStarTable.this.nCols[itab]; ++ic) {
                    this.rseqsByColumn[icol] = this.rseqs[itab];
                    assert (JoinStarTable.this.indicesByColumn[icol] == ic);
                    ++icol;
                }
            }
            assert (icol == JoinStarTable.this.nCol);
        }

        @Override
        public boolean next() throws IOException {
            for (int itab = 0; itab < JoinStarTable.this.nTab; ++itab) {
                if (this.rseqs[itab].next()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.rseqsByColumn[icol].getCell(JoinStarTable.this.indicesByColumn[icol]);
        }

        @Override
        public Object[] getRow() throws IOException {
            Object[] row = new Object[JoinStarTable.this.nCol];
            int icol = 0;
            for (int itab = 0; itab < JoinStarTable.this.nTab; ++itab) {
                Object[] subrow = this.rseqs[itab].getRow();
                System.arraycopy(subrow, 0, row, icol, JoinStarTable.this.nCols[itab]);
                icol += JoinStarTable.this.nCols[itab];
            }
            assert (icol == JoinStarTable.this.nCol);
            return row;
        }

        @Override
        public void close() throws IOException {
            for (int itab = 0; itab < JoinStarTable.this.nTab; ++itab) {
                this.rseqs[itab].close();
            }
        }
    }
}

