/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;

public class MetaCopyStarTable
extends WrapperStarTable {
    private String name_;
    private URL url_;
    private List paramList_;
    private ColumnInfo[] colInfos_;

    public MetaCopyStarTable(StarTable base) {
        super(base);
        this.name_ = base.getName();
        this.url_ = base.getURL();
        this.paramList_ = new ArrayList();
        for (Object item : base.getParameters()) {
            if (!(item instanceof DescribedValue)) continue;
            DescribedValue dval = (DescribedValue)item;
            this.paramList_.add(new DescribedValue(dval.getInfo(), dval.getValue()));
        }
        int ncol = base.getColumnCount();
        this.colInfos_ = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            this.colInfos_[icol] = new ColumnInfo(base.getColumnInfo(icol));
        }
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public URL getURL() {
        return this.url_;
    }

    @Override
    public void setURL(URL url) {
        this.url_ = url;
    }

    @Override
    public List getParameters() {
        return this.paramList_;
    }

    public void setParameters(List paramList) {
        this.paramList_ = paramList;
    }

    @Override
    public DescribedValue getParameterByName(String name) {
        for (Object item : this.getParameters()) {
            if (!(item instanceof DescribedValue) || !name.equals(((DescribedValue)item).getInfo().getName())) continue;
            return (DescribedValue)item;
        }
        return null;
    }

    @Override
    public void setParameter(DescribedValue dval) {
        String name = dval.getInfo().getName();
        List paramList = this.getParameters();
        Iterator it = paramList.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof DescribedValue) || !name.equals(((DescribedValue)item).getInfo().getName())) continue;
            it.remove();
        }
        paramList.add(dval);
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public void setColumnInfo(int icol, ColumnInfo colInfo) {
        this.colInfos_[icol] = colInfo;
    }
}

