/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.util.LinkedList;
import uk.ac.starlink.table.RowPipe;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class OnceRowPipe
implements RowPipe,
RowSequence {
    private final LinkedList rowQueue_;
    private final int queueSize_;
    private StarTable table_;
    private Object[] seqRow_;
    private boolean seqClosed_;
    private boolean seqEnded_;
    private IOException error_;
    private static final Object[] END_ROWS = new Object[0];

    public OnceRowPipe() {
        this(1024);
    }

    public OnceRowPipe(int queueSize) {
        this.queueSize_ = queueSize;
        this.rowQueue_ = new LinkedList();
    }

    @Override
    public synchronized void setError(IOException error) {
        if (this.error_ == null) {
            this.error_ = error;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void acceptMetadata(StarTable meta) {
        this.table_ = new WrapperStarTable(meta){
            RowSequence rseq_;
            {
                this.rseq_ = OnceRowPipe.this;
            }

            @Override
            public boolean isRandom() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RowSequence getRowSequence() throws IOException {
                OnceRowPipe onceRowPipe = OnceRowPipe.this;
                synchronized (onceRowPipe) {
                    if (this.rseq_ == null) {
                        throw new UnrepeatableSequenceException("Can't re-read data from stream");
                    }
                    OnceRowPipe.this.checkError();
                    RowSequence rseq = this.rseq_;
                    this.rseq_ = null;
                    return new WrapperRowSequence(rseq){

                        @Override
                        public boolean next() throws IOException {
                            OnceRowPipe.this.checkError();
                            return super.next();
                        }

                        @Override
                        public Object getCell(int icol) throws IOException {
                            OnceRowPipe.this.checkError();
                            return super.getCell(icol);
                        }

                        @Override
                        public Object[] getRow() throws IOException {
                            OnceRowPipe.this.checkError();
                            return super.getRow();
                        }

                        @Override
                        public void close() throws IOException {
                            OnceRowPipe.this.checkError();
                            super.close();
                        }
                    };
                }
            }
        };
    }

    @Override
    public synchronized void acceptRow(Object[] row) throws IOException {
        if (this.seqClosed_) {
            throw new IOException("Stream closed at reading end");
        }
        try {
            while (this.rowQueue_.size() > this.queueSize_) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        this.rowQueue_.addLast(row);
        this.notifyAll();
    }

    @Override
    public synchronized void endRows() {
        this.rowQueue_.addLast(END_ROWS);
        if (this.table_ == null) {
            this.setError(new IOException("No data in table"));
        }
        this.notifyAll();
    }

    @Override
    public synchronized StarTable waitForStarTable() throws IOException {
        try {
            while (this.table_ == null && this.error_ == null) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread interrupted", e);
        }
        this.checkError();
        return this.table_;
    }

    @Override
    public synchronized boolean next() throws IOException {
        this.checkError();
        if (this.seqEnded_) {
            this.notifyAll();
            return false;
        }
        try {
            while (this.rowQueue_.size() == 0) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Thread interrupted").initCause(e);
        }
        this.seqRow_ = (Object[])this.rowQueue_.removeFirst();
        if (this.seqRow_ == END_ROWS) {
            this.seqEnded_ = true;
        }
        this.notifyAll();
        return !this.seqEnded_;
    }

    @Override
    public synchronized Object[] getRow() {
        if (this.seqRow_ != null) {
            return this.seqRow_;
        }
        throw new IllegalStateException("next() has not been called yet");
    }

    @Override
    public Object getCell(int icol) {
        return this.getRow()[icol];
    }

    @Override
    public synchronized void close() {
        this.seqClosed_ = true;
    }

    private synchronized void checkError() throws IOException {
        if (this.error_ != null) {
            String msg = this.error_.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = this.error_.toString();
            }
            throw (IOException)new IOException(msg).initCause(this.error_);
        }
    }
}

