/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;

public class RowPermutedStarTable
extends WrapperStarTable {
    private long[] rowMap;

    public RowPermutedStarTable(StarTable baseTable, long[] rowMap) {
        super(baseTable);
        if (!baseTable.isRandom()) {
            throw new IllegalArgumentException("No random access in base table " + baseTable);
        }
        this.rowMap = rowMap;
    }

    public RowPermutedStarTable(StarTable baseTable) {
        this(baseTable, new long[Math.max(RowPermutedStarTable.checkedLongToInt(baseTable.getRowCount()), 0)]);
        int nrow = this.rowMap.length;
        for (int i = 0; i < nrow; ++i) {
            this.rowMap[i] = i;
        }
    }

    public long[] getRowMap() {
        return this.rowMap;
    }

    public void setRowMap(long[] rowMap) {
        this.rowMap = rowMap;
    }

    @Override
    public long getRowCount() {
        return this.rowMap.length;
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public RowSequence getRowSequence() {
        return new RandomRowSequence(this);
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        long baseRow = this.rowMap[RowPermutedStarTable.checkedLongToInt(irow)];
        return baseRow >= 0L ? this.baseTable.getCell(baseRow, icol) : null;
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        long baseRow = this.rowMap[RowPermutedStarTable.checkedLongToInt(irow)];
        return baseRow >= 0L ? this.baseTable.getRow(baseRow) : new Object[this.baseTable.getColumnCount()];
    }
}

