/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.Iterator;

public class ShapeIterator
implements Iterator {
    private final int[] shape_;
    private final int ndim_;
    private int[] pos_;

    public ShapeIterator(int[] shape) {
        if (shape.length == 0) {
            throw new IllegalArgumentException("Empty shape");
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] > 0) continue;
            throw new IllegalArgumentException("Not a finite shape");
        }
        this.shape_ = shape;
        this.ndim_ = this.shape_.length;
        this.pos_ = new int[this.ndim_];
    }

    @Override
    public boolean hasNext() {
        return this.pos_ != null;
    }

    public Object next() {
        int[] next = (int[])this.pos_.clone();
        for (int j = 0; j < this.ndim_; ++j) {
            int n = j;
            this.pos_[n] = this.pos_[n] + 1;
            if (this.pos_[n] < this.shape_[j]) {
                return next;
            }
            this.pos_[j] = 0;
        }
        this.pos_ = null;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

