/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableTransferable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamTableSink;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.AsciiTableWriter;
import uk.ac.starlink.table.formats.CsvTableWriter;
import uk.ac.starlink.table.formats.HTMLTableWriter;
import uk.ac.starlink.table.formats.IpacTableWriter;
import uk.ac.starlink.table.formats.LatexTableWriter;
import uk.ac.starlink.table.formats.TextTableWriter;
import uk.ac.starlink.table.formats.TstTableWriter;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.WriteMode;
import uk.ac.starlink.util.Loader;

public class StarTableOutput {
    private List handlers = new ArrayList();
    private JDBCHandler jdbcHandler;
    private static String[] defaultHandlerClasses = new String[]{"uk.ac.starlink.votable.FitsPlusTableWriter", "uk.ac.starlink.fits.FitsTableWriter", "uk.ac.starlink.fits.VariableFitsTableWriter", "uk.ac.starlink.votable.ColFitsPlusTableWriter", "uk.ac.starlink.fits.ColFitsTableWriter", "uk.ac.starlink.votable.VOTableWriter", TextTableWriter.class.getName(), AsciiTableWriter.class.getName(), CsvTableWriter.class.getName(), IpacTableWriter.class.getName(), TstTableWriter.class.getName(), HTMLTableWriter.class.getName(), LatexTableWriter.class.getName(), "uk.ac.starlink.mirage.MirageTableWriter"};
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table");
    private StarTableWriter voWriter;
    public static final String AUTO_HANDLER = "(auto)";
    public static final String EXTRA_WRITERS_PROPERTY = "startable.writers";

    public StarTableOutput() {
        for (int i = 0; i < defaultHandlerClasses.length; ++i) {
            String className = defaultHandlerClasses[i];
            try {
                this.getClass();
                Class<?> clazz = Class.forName(className);
                StarTableWriter[] writers = null;
                try {
                    Class<?> retClass;
                    Method getList = clazz.getMethod("getStarTableWriters", new Class[0]);
                    int mods = getList.getModifiers();
                    if (Modifier.isStatic(mods) && Modifier.isPublic(mods) && (retClass = getList.getReturnType()).isArray() && StarTableWriter.class.isAssignableFrom(retClass.getComponentType())) {
                        writers = (StarTableWriter[])getList.invoke(null, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (writers != null) {
                    for (int j = 0; j < writers.length; ++j) {
                        void handler = writers[j];
                        this.handlers.add(handler);
                        logger.config("Handler " + handler.getFormatName() + " registered");
                    }
                    continue;
                }
                StarTableWriter handler = (StarTableWriter)clazz.newInstance();
                this.handlers.add(handler);
                logger.config("Handler " + handler.getFormatName() + " registered");
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.config(className + " not found - can't register");
                continue;
            }
            catch (Exception e) {
                logger.config("Failed to register " + className + " - " + e);
            }
        }
        this.handlers.addAll(Loader.getClassInstances(EXTRA_WRITERS_PROPERTY, StarTableWriter.class));
        this.voWriter = StarTableOutput.getTransferableWriter(this.handlers.toArray(new StarTableWriter[0]));
    }

    public List getHandlers() {
        return this.handlers;
    }

    public void setHandlers(StarTableWriter[] handlers) {
        this.handlers = new ArrayList<StarTableWriter>(Arrays.asList(handlers));
    }

    public void writeStarTable(StarTable startab, String location, String format) throws TableFormatException, IOException {
        if (location.startsWith("jdbc:")) {
            try {
                this.getJDBCHandler().createJDBCTable(startab, location, WriteMode.DROP_CREATE);
                return;
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        this.getHandler(format, location).writeStarTable(startab, location, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, OutputStream out, StarTableWriter handler) throws IOException {
        try {
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            handler.writeStarTable(startab, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public void writeStarTables(StarTable[] tables, String location, String format) throws TableFormatException, IOException {
        StarTableWriter handler = this.getHandler(format, location);
        if (handler instanceof MultiStarTableWriter) {
            ((MultiStarTableWriter)handler).writeStarTables(Tables.arrayTableSequence(tables), location, this);
        } else if (tables.length == 1) {
            handler.writeStarTable(tables[0], location, this);
        } else {
            throw new TableFormatException("Output handler " + handler.getFormatName() + " can't write multiple tables");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTables(StarTable[] tables, OutputStream out, MultiStarTableWriter handler) throws IOException {
        try {
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            handler.writeStarTables(Tables.arrayTableSequence(tables), out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public TableSink createOutputSink(final OutputStream out, final StarTableWriter handler) {
        return new StreamTableSink(){

            @Override
            protected void scanTable(StarTable table) throws IOException {
                StarTableOutput.this.writeStarTable(table, out, handler);
            }
        };
    }

    public TableSink createOutputSink(final String location, final String format) {
        return new StreamTableSink(){

            @Override
            protected void scanTable(StarTable table) throws IOException {
                StarTableOutput.this.writeStarTable(table, location, format);
            }
        };
    }

    public OutputStream getOutputStream(String location) throws IOException {
        if (location.equals("-")) {
            PrintStream out = System.out;
            return new FilterOutputStream(out){

                @Override
                public void close() throws IOException {
                    this.out.flush();
                }
            };
        }
        try {
            URL url = new URL(location);
            URLConnection uconn = url.openConnection();
            uconn.setDoInput(false);
            uconn.setDoOutput(true);
            uconn.connect();
            return uconn.getOutputStream();
        }
        catch (MalformedURLException e) {
            File file = new File(location);
            if (file.exists()) {
                if (file.delete()) {
                    logger.info("Deleting file \"" + location + "\" prior to overwriting");
                } else {
                    logger.warning("Failed to delete \"" + location + "\" prior to overwriting");
                }
            }
            return new FileOutputStream(file);
        }
    }

    public StarTableWriter getHandler(String format) throws TableFormatException {
        block8: {
            if (format.equals(AUTO_HANDLER)) {
                throw new TableFormatException(format + " does not name a " + "specific output handler");
            }
            try {
                this.getClass();
                Class<?> fcls = Class.forName(format);
                if (!StarTableWriter.class.isAssignableFrom(fcls)) break block8;
                for (StarTableWriter handler : this.handlers) {
                    if (!fcls.isInstance(handler)) continue;
                    return handler;
                }
                try {
                    StarTableWriter handler = (StarTableWriter)fcls.newInstance();
                    return handler;
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        for (StarTableWriter handler : this.handlers) {
            if (!handler.getFormatName().toLowerCase().startsWith(format.toLowerCase())) continue;
            return handler;
        }
        throw new TableFormatException("No handler for table format \"" + format + "\"");
    }

    public StarTableWriter getHandler(String format, String location) throws TableFormatException {
        if (format != null && format.length() > 0 && !AUTO_HANDLER.equals(format)) {
            return this.getHandler(format);
        }
        for (StarTableWriter handler : this.handlers) {
            if (!handler.looksLikeFile(location)) continue;
            return handler;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("No handler specified for writing table.\n").append("Known formats: ");
        Iterator it = this.getKnownFormats().iterator();
        while (it.hasNext()) {
            msg.append(it.next());
            if (!it.hasNext()) continue;
            msg.append(", ");
        }
        throw new TableFormatException(msg.toString());
    }

    public List getKnownFormats() {
        ArrayList<String> kf = new ArrayList<String>();
        kf.add("jdbc");
        Iterator it = this.handlers.iterator();
        while (it.hasNext()) {
            kf.add(((StarTableWriter)it.next()).getFormatName());
        }
        return kf;
    }

    public JDBCHandler getJDBCHandler() {
        if (this.jdbcHandler == null) {
            this.jdbcHandler = new JDBCHandler();
        }
        return this.jdbcHandler;
    }

    public void setJDBCHandler(JDBCHandler handler) {
        this.jdbcHandler = handler;
    }

    public Transferable transferStarTable(StarTable startab) {
        if (this.voWriter != null) {
            return new StarTableTransferable(this, startab);
        }
        return null;
    }

    StarTableWriter getTransferWriter() {
        return this.voWriter;
    }

    private static StarTableWriter getTransferableWriter(StarTableWriter[] handlers) {
        StarTableWriter tdWriter = null;
        for (int ih = 0; ih < handlers.length; ++ih) {
            StarTableWriter handler = handlers[ih];
            String formatName = handler.getFormatName();
            if ("votable-binary-inline".equals(formatName)) {
                return handler;
            }
            if (!"votable-tabledata".equals(formatName)) continue;
            tdWriter = handler;
        }
        return tdWriter;
    }
}

