/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.ShapeIterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.TableSorter;
import uk.ac.starlink.table.ValueInfo;

public class Tables {
    public static final ValueInfo NULL_VALUE_INFO = new DefaultValueInfo("NULL_VALUE", Object.class, "Integer value which represents a null");
    public static final ValueInfo UBYTE_FLAG_INFO = new DefaultValueInfo("UBYTE_FLAG", Boolean.class, "If true, data represents unsigned byte values");
    public static final DefaultValueInfo RA_INFO = new DefaultValueInfo("RA", Number.class, "Right Ascension");
    public static final DefaultValueInfo DEC_INFO = new DefaultValueInfo("Dec", Number.class, "Declination");

    public static StarTable randomTable(StarTable startab) throws IOException {
        return StoragePolicy.getDefaultPolicy().randomTable(startab);
    }

    public static ColumnInfo[] getColumnInfos(StarTable startab) {
        int ncol = startab.getColumnCount();
        ColumnInfo[] infos = new ColumnInfo[ncol];
        for (int i = 0; i < ncol; ++i) {
            infos[i] = startab.getColumnInfo(i);
        }
        return infos;
    }

    public static StarTable deleteColumn(StarTable startab, int icol) {
        int ncol = startab.getColumnCount();
        if (icol < 0 || icol >= ncol) {
            throw new IndexOutOfBoundsException("Deleted column " + icol + " out of range 0.." + (ncol - 1));
        }
        int[] colmap = new int[ncol - 1];
        int j = 0;
        for (int i = 0; i < ncol; ++i) {
            if (i == icol) continue;
            colmap[j++] = i;
        }
        assert (j == ncol - 1);
        return new ColumnPermutedStarTable(startab, colmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamStarTable(StarTable source, TableSink sink) throws IOException {
        sink.acceptMetadata(source);
        RowSequence rseq = source.getRowSequence();
        try {
            while (rseq.next()) {
                sink.acceptRow(rseq.getRow());
            }
        }
        finally {
            rseq.close();
        }
        sink.endRows();
    }

    public static void checkTable(StarTable table) throws IOException {
        int formatChars = 100;
        int ncol = table.getColumnCount();
        long nrow = table.getRowCount();
        boolean isRandom = table.isRandom();
        if (isRandom) {
            Tables.assertTrue(nrow >= 0L);
        }
        int[] nels = new int[ncol];
        Class[] classes = new Class[ncol];
        ColumnInfo[] colinfos = new ColumnInfo[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo cinfo;
            colinfos[icol] = cinfo = table.getColumnInfo(icol);
            classes[icol] = cinfo.getContentClass();
            int[] dims = cinfo.getShape();
            if (dims != null) {
                int ndim = dims.length;
                Tables.assertTrue(ndim > 0);
                Tables.assertTrue(cinfo.getContentClass().isArray());
                int nel = 1;
                for (int i = 0; i < ndim; ++i) {
                    nel *= dims[i];
                    Tables.assertTrue(dims[i] != 0);
                    if (i >= ndim - 1) continue;
                    Tables.assertTrue(dims[i] > 0);
                }
                nels[icol] = nel;
            }
            Tables.assertTrue(cinfo.getContentClass().isArray() == cinfo.isArray());
        }
        RowSequence rseq = table.getRowSequence();
        try {
            rseq.getRow();
            Tables.assertTrue(false);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        long lrow = 0L;
        while (rseq.next()) {
            Object[] row = rseq.getRow();
            for (int icol = 0; icol < ncol; ++icol) {
                boolean isNull;
                Object cell;
                Object val1 = cell = row[icol];
                Object val2 = rseq.getCell(icol);
                Object val3 = null;
                if (isRandom) {
                    val3 = table.getCell(lrow, icol);
                }
                boolean bl = isNull = cell == null;
                if (isNull) {
                    Tables.assertTrue(colinfos[icol].isNullable());
                    Tables.assertTrue(val2 == null);
                    if (isRandom) {
                        Tables.assertTrue(val3 == null);
                    }
                } else {
                    String s1 = colinfos[icol].formatValue(val1, formatChars);
                    Tables.assertTrue(s1.equals(colinfos[icol].formatValue(val2, formatChars)));
                    if (isRandom) {
                        Tables.assertTrue(s1.equals(colinfos[icol].formatValue(val3, formatChars)));
                    }
                }
                if (cell != null && cell.getClass().isArray()) {
                    int nel = Array.getLength(cell);
                    if (nels[icol] < 0) {
                        Tables.assertTrue(nel % nels[icol] == 0);
                    } else {
                        Tables.assertTrue(nels[icol] == nel);
                    }
                }
                if (cell != null && !classes[icol].isAssignableFrom(cell.getClass())) {
                    throw new AssertionError((Object)("Column " + (icol + 1) + ": " + cell + " is a " + cell.getClass().getName() + " not a " + classes[icol].getName()));
                }
            }
            ++lrow;
        }
        rseq.close();
        if (nrow >= 0L) {
            Tables.assertTrue(lrow == nrow);
        }
    }

    public static boolean isBlank(Object value) {
        return value == null || value instanceof Float && ((Float)value).isNaN() || value instanceof Double && ((Double)value).isNaN() || value instanceof String && ((String)value).length() == 0 || value.getClass().isArray() && Array.getLength(value) == 0;
    }

    public static TableSequence singleTableSequence(StarTable table) {
        return Tables.arrayTableSequence(new StarTable[]{table});
    }

    public static TableSequence arrayTableSequence(StarTable[] tables) {
        final Iterator<StarTable> it = Arrays.asList(tables).iterator();
        return new TableSequence(){

            @Override
            public StarTable nextTable() {
                return it.hasNext() ? (StarTable)it.next() : null;
            }
        };
    }

    public static StarTable[] tableArray(TableSequence tseq) throws IOException {
        StarTable table;
        ArrayList<StarTable> list = new ArrayList<StarTable>();
        while ((table = tseq.nextTable()) != null) {
            list.add(table);
        }
        return list.toArray(new StarTable[0]);
    }

    public static StarTable sortTable(StarTable table, int[] colIndices, boolean up, boolean nullsLast) throws IOException {
        long[] rowMap = TableSorter.getSortedOrder(table, colIndices, up, nullsLast);
        return new RowPermutedStarTable(table, rowMap);
    }

    public static int checkedLongToInt(long lval) {
        int ival = (int)lval;
        if ((long)ival == lval) {
            return ival;
        }
        if (ival < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Out of supported range: " + ival + " < Integer.MIN_VALUE");
        }
        if (ival > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Out of supported range: " + ival + " > Integer.MAX_VALUE");
        }
        throw new AssertionError();
    }

    public static int assertLongToInt(long lval) {
        int ival = (int)lval;
        assert ((long)ival == lval) : "Long value " + lval + " unexpectedly out of int range";
        return ival;
    }

    public static String[] getElementLabels(int[] shape) {
        if (shape == null || shape.length == 0) {
            return null;
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] > 0) continue;
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>();
        ShapeIterator it = new ShapeIterator(shape);
        while (it.hasNext()) {
            int[] pos = (int[])it.next();
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < pos.length; ++i) {
                sbuf.append('_').append(Integer.toString(pos[i] + 1));
            }
            labels.add(sbuf.toString());
        }
        return labels.toArray(new String[0]);
    }

    public static String getUtype(ValueInfo info) {
        return info.getUtype();
    }

    public static void setUtype(ValueInfo info, String utype) {
        if (info instanceof DefaultValueInfo) {
            ((DefaultValueInfo)info).setUtype(utype);
        }
    }

    public static Object getValue(Collection dvals, ValueInfo info) {
        String iname = info.getName();
        Class iclazz = info.getContentClass();
        if (iname != null && iclazz != null) {
            for (Object obj : dvals) {
                DescribedValue dval;
                ValueInfo dinfo;
                if (!(obj instanceof DescribedValue) || !iname.equals((dinfo = (dval = (DescribedValue)obj).getInfo()).getName()) || !iclazz.equals(dinfo.getContentClass())) continue;
                return dval.getValue();
            }
        }
        return null;
    }

    public static void fixColumns(ColumnInfo[][] infoLists, JoinFixAction[] fixActs) {
        int nt = infoLists.length;
        if (fixActs.length != nt) {
            throw new IllegalArgumentException();
        }
        int maxNc = 0;
        for (int it = 0; it < nt; ++it) {
            maxNc = Math.max(infoLists[it].length, maxNc);
        }
        String[] names = new String[maxNc * nt];
        for (int it = 0; it < nt; ++it) {
            ColumnInfo[] infos = infoLists[it];
            for (int ic = 0; ic < infos.length; ++ic) {
                int ix = it * maxNc + ic;
                names[ix] = infos[ic].getName();
            }
        }
        ArrayList<String> nameList = new ArrayList<String>(Arrays.asList(names));
        for (int it = 0; it < nt; ++it) {
            ColumnInfo[] infos = infoLists[it];
            JoinFixAction fixAct = fixActs[it];
            for (int ic = 0; ic < infos.length; ++ic) {
                int ix = it * maxNc + ic;
                String origName = (String)nameList.remove(ix);
                assert (origName.equals(infos[ic].getName()));
                String name = fixAct.getFixedName(origName, nameList);
                nameList.add(ix, origName);
                if (name.equals(origName)) continue;
                nameList.add(name);
                infos[ic].setName(name);
            }
        }
    }

    private static void assertTrue(boolean ok) {
        if (!ok) {
            throw new AssertionError();
        }
    }

    static {
        RA_INFO.setUnitString("radians");
        DEC_INFO.setUnitString("radians");
        RA_INFO.setNullable(false);
        DEC_INFO.setNullable(false);
        RA_INFO.setUCD("POS_EQ_RA");
        DEC_INFO.setUCD("POS_EQ_DEC");
    }
}

