/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.DomainMapper;

public abstract class TimeMapper
implements DomainMapper {
    private final Class sourceClass_;
    private final String sourceName_;
    private final String sourceDescription_;
    public static final String TARGET_NAME = "Time";
    public static final TimeMapper DECIMAL_YEAR;
    public static final TimeMapper MJD;
    public static final TimeMapper JD;
    public static final TimeMapper UNIX_SECONDS;
    private static final TimeZone UTC;
    public static final TimeMapper ISO_8601;
    private static final TimeMapper[] MAPPERS;

    protected TimeMapper(Class sourceClass, String sourceName, String sourceDescription) {
        this.sourceClass_ = sourceClass;
        this.sourceName_ = sourceName;
        this.sourceDescription_ = sourceDescription;
    }

    @Override
    public final String getTargetName() {
        return TARGET_NAME;
    }

    @Override
    public Class getSourceClass() {
        return this.sourceClass_;
    }

    @Override
    public String getSourceName() {
        return this.sourceName_;
    }

    @Override
    public String getSourceDescription() {
        return this.sourceDescription_;
    }

    public abstract double toUnixSeconds(Object var1);

    public static TimeMapper[] getTimeMappers() {
        return (TimeMapper[])MAPPERS.clone();
    }

    static {
        UTC = TimeZone.getTimeZone("UTC");
        DECIMAL_YEAR = new DecimalYearTimeMapper("DecYear", "Years since 0 AD");
        MJD = new MjdTimeMapper("MJD", "Modified Julian Date");
        JD = new JdTimeMapper("JD", "Julian Day");
        UNIX_SECONDS = new UnixTimeMapper("Unix", "Seconds since midnight 1 Jan 1970");
        ISO_8601 = new Iso8601TimeMapper("Iso8601", "ISO 8601 string");
        MAPPERS = new TimeMapper[]{DECIMAL_YEAR, MJD, JD, UNIX_SECONDS, ISO_8601};
    }

    private static class Iso8601TimeMapper
    extends TimeMapper {
        private static final Pattern ISO_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?Z?)?");

        Iso8601TimeMapper(String name, String description) {
            super(String.class, name, description);
        }

        @Override
        public double toUnixSeconds(Object value) {
            if (value instanceof String) {
                String sval = ((String)value).trim();
                Matcher matcher = ISO_REGEX.matcher(((String)value).trim());
                if (matcher.matches()) {
                    String[] groups = new String[6];
                    int ng = matcher.groupCount();
                    for (int i = 0; i < ng; ++i) {
                        groups[i] = matcher.group(i + 1);
                    }
                    try {
                        int year = Integer.parseInt(groups[0]);
                        int month = Integer.parseInt(groups[1]);
                        int dom = Integer.parseInt(groups[2]);
                        int hour = groups[3] == null ? 0 : Integer.parseInt(groups[3]);
                        int min = groups[4] == null ? 0 : Integer.parseInt(groups[4]);
                        double sec = groups[5] == null ? 0.0 : Double.parseDouble(groups[5]);
                        return Iso8601TimeMapper.dateToUnix(year, month, dom, hour, min, sec);
                    }
                    catch (NumberFormatException e) {
                        return Double.NaN;
                    }
                }
                return Double.NaN;
            }
            return Double.NaN;
        }

        private static double dateToUnix(int year, int month, int dom, int hour, int min, double sec) {
            int intSec = (int)sec;
            double fracSec = sec - (double)intSec;
            GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
            cal.clear();
            cal.set(year, month - 1, dom, hour, min, (int)sec);
            double calMillis = cal.getTimeInMillis();
            double calSec = calMillis * 0.001;
            return calSec + fracSec;
        }
    }

    private static class UnixTimeMapper
    extends TimeMapper {
        UnixTimeMapper(String name, String description) {
            super(Number.class, name, description);
        }

        @Override
        public double toUnixSeconds(Object value) {
            return value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
        }
    }

    private static class JdTimeMapper
    extends TimeMapper {
        private static final double JD_EPOCH = 2440587.5;
        private static final double SECONDS_PER_DAY = 86400.0;

        JdTimeMapper(String name, String description) {
            super(Number.class, name, description);
        }

        @Override
        public double toUnixSeconds(Object value) {
            if (value instanceof Number) {
                double jd = ((Number)value).doubleValue();
                return (jd - 2440587.5) * 86400.0;
            }
            return Double.NaN;
        }
    }

    private static class MjdTimeMapper
    extends TimeMapper {
        private static final double MJD_EPOCH = 40587.0;
        private static final double SECONDS_PER_DAY = 86400.0;

        MjdTimeMapper(String name, String description) {
            super(Number.class, name, description);
        }

        @Override
        public double toUnixSeconds(Object value) {
            if (value instanceof Number) {
                double mjd = ((Number)value).doubleValue();
                return (mjd - 40587.0) * 86400.0;
            }
            return Double.NaN;
        }
    }

    private static class DecimalYearTimeMapper
    extends TimeMapper {
        DecimalYearTimeMapper(String name, String description) {
            super(Number.class, name, description);
        }

        @Override
        public double toUnixSeconds(Object value) {
            if (value instanceof Number) {
                double decYear = ((Number)value).doubleValue();
                if (Double.isNaN(decYear)) {
                    return Double.NaN;
                }
                int year = (int)decYear;
                double yearFraction = decYear - (double)year;
                GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
                cal.clear();
                cal.set(year, 0, 1, 0, 0, 0);
                long millis0 = cal.getTimeInMillis();
                ((Calendar)cal).add(1, 1);
                long millis1 = cal.getTimeInMillis();
                long millisInYear = millis1 - millis0;
                double milliOfYear = yearFraction * (double)millisInYear;
                double unixMillis = (double)millis0 + milliOfYear;
                return unixMillis / 1000.0;
            }
            return Double.NaN;
        }
    }
}

