/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class WrapperStarTable
implements StarTable {
    protected StarTable baseTable;
    private String name;
    private boolean nameSet;
    private URL url;

    public WrapperStarTable(StarTable baseTable) {
        this.baseTable = baseTable;
    }

    public StarTable getBaseTable() {
        return this.baseTable;
    }

    @Override
    public int getColumnCount() {
        return this.baseTable.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.baseTable.getRowCount();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public String getName() {
        return this.nameSet ? this.name : this.baseTable.getName();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.nameSet = true;
    }

    @Override
    public List getParameters() {
        return this.baseTable.getParameters();
    }

    @Override
    public DescribedValue getParameterByName(String parname) {
        return this.baseTable.getParameterByName(parname);
    }

    @Override
    public void setParameter(DescribedValue dval) {
        DescribedValue old = this.getParameterByName(dval.getInfo().getName());
        if (old != null) {
            this.baseTable.getParameters().remove(old);
        }
        this.baseTable.getParameters().add(dval);
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.baseTable.getColumnInfo(icol);
    }

    @Override
    public List getColumnAuxDataInfos() {
        return this.baseTable.getColumnAuxDataInfos();
    }

    @Override
    public RowSequence getRowSequence() throws IOException {
        return this.baseTable.getRowSequence();
    }

    @Override
    public boolean isRandom() {
        return this.baseTable.isRandom();
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.baseTable.getCell(irow, icol);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        return this.baseTable.getRow(irow);
    }

    public static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(super.toString());
        StarTable table = this;
        while (table instanceof WrapperStarTable) {
            table = ((WrapperStarTable)table).getBaseTable();
            sbuf.append(" -> ");
            sbuf.append(table.getClass().getName());
        }
        return sbuf.toString();
    }
}

