/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.ValueInfo;

public abstract class AbstractTextTableWriter
extends StreamStarTableWriter {
    private boolean writeParams_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.formats");

    protected AbstractTextTableWriter(boolean writeParams) {
        this.writeParams_ = writeParams;
    }

    @Override
    public String getFormatName() {
        return "text";
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTable(StarTable startab, OutputStream strm) throws IOException {
        RowSequence rseq = startab.getRowSequence();
        try {
            this.writeStarTable(startab, rseq, strm);
        }
        finally {
            rseq.close();
        }
    }

    private void writeStarTable(StarTable startab, RowSequence rseq, OutputStream strm) throws IOException {
        ArrayList<Object[]> sampleList = new ArrayList<Object[]>();
        boolean allRowsSampled = false;
        int maxSamples = this.getSampledRows();
        logger_.config("Reading <=" + maxSamples + " rows to guess column widths");
        for (int ir = 0; ir < maxSamples; ++ir) {
            if (!rseq.next()) {
                allRowsSampled = true;
                break;
            }
            sampleList.add(rseq.getRow());
        }
        logger_.config(sampleList.size() + (allRowsSampled ? " (all)" : "") + " rows read to guess column widths");
        int ncol = startab.getColumnCount();
        ColumnInfo[] cinfos = new ColumnInfo[ncol];
        int[] cwidths = new int[ncol];
        int[] maxDataWidths = new int[ncol];
        for (int i = 0; i < ncol; ++i) {
            cinfos[i] = startab.getColumnInfo(i);
            cwidths[i] = this.getMinNameWidth(cinfos[i]);
            maxDataWidths[i] = this.getMaxDataWidth(cinfos[i].getContentClass());
        }
        for (Object[] row : sampleList) {
            for (int i = 0; i < ncol; ++i) {
                String formatted = cinfos[i].formatValue(row[i], maxDataWidths[i]);
                if (formatted.length() <= cwidths[i]) continue;
                cwidths[i] = formatted.length();
            }
        }
        if (!allRowsSampled) {
            for (int icol = 0; icol < ncol; ++icol) {
                int nchar;
                int n = icol;
                cwidths[n] = cwidths[n] + 2;
                ColumnInfo cinfo = cinfos[icol];
                if (!cinfo.getContentClass().equals(String.class) || (nchar = cinfo.getElementSize()) <= 0) continue;
                cwidths[icol] = Math.max(cwidths[icol], nchar);
            }
        }
        for (int i = 0; i < ncol; ++i) {
            cwidths[i] = Math.min(this.getMaxWidth(), cwidths[i]);
        }
        if (this.writeParams_) {
            int maxleng = this.getMaximumParameterLength();
            String name = startab.getName();
            if (name != null && name.trim().length() > 0) {
                this.printParam(strm, "Table name", name, String.class);
            }
            for (DescribedValue param : startab.getParameters()) {
                ValueInfo info = param.getInfo();
                this.printParam(strm, info.getName(), param.getValueAsString(maxleng), info.getContentClass());
            }
        }
        this.printColumnHeads(strm, cwidths, cinfos);
        String[] data = new String[ncol];
        for (Object[] row : sampleList) {
            for (int icol = 0; icol < ncol; ++icol) {
                data[icol] = this.formatValue(row[icol], cinfos[icol], cwidths[icol]);
            }
            this.printLine(strm, cwidths, data);
        }
        if (!allRowsSampled) {
            logger_.config("Streaming remaining data rows");
        } else assert (!rseq.next());
        while (rseq.next()) {
            Object[] row;
            row = rseq.getRow();
            for (int icol = 0; icol < ncol; ++icol) {
                data[icol] = this.formatValue(row[icol], cinfos[icol], cwidths[icol]);
            }
            this.printLine(strm, cwidths, data);
        }
        this.printSeparator(strm, cwidths);
    }

    protected int getMaximumParameterLength() {
        return 160;
    }

    public void setWriteParameters(boolean writeParams) {
        this.writeParams_ = writeParams;
    }

    public boolean getWriteParameters() {
        return this.writeParams_;
    }

    public abstract int getMaxWidth();

    public int getMinNameWidth(ColumnInfo info) {
        return info.getName().length();
    }

    public int getSampledRows() {
        return 200;
    }

    protected abstract String formatValue(Object var1, ValueInfo var2, int var3);

    protected abstract void printSeparator(OutputStream var1, int[] var2) throws IOException;

    protected abstract void printColumnHeads(OutputStream var1, int[] var2, ColumnInfo[] var3) throws IOException;

    protected abstract void printLine(OutputStream var1, int[] var2, String[] var3) throws IOException;

    protected abstract void printParam(OutputStream var1, String var2, String var3, Class var4) throws IOException;

    protected byte[] getBytes(String str) {
        int leng = str.length();
        byte[] buf = new byte[leng];
        for (int i = 0; i < leng; ++i) {
            buf[i] = (byte)str.charAt(i);
        }
        return buf;
    }

    private int getMaxDataWidth(Class clazz) {
        if (clazz == Double.class) {
            return Math.max(Double.toString(-1.7976931348623157E308).length(), Double.toString(-4.9E-324).length());
        }
        if (clazz == Float.class) {
            return Math.max(Float.toString(-3.4028235E38f).length(), Float.toString(-1.4E-45f).length());
        }
        if (clazz == Long.class) {
            return Math.max(Long.toString(Long.MIN_VALUE).length(), Long.toString(Long.MAX_VALUE).length());
        }
        if (clazz == Integer.class) {
            return Math.max(Integer.toString(Integer.MIN_VALUE).length(), Integer.toString(Integer.MAX_VALUE).length());
        }
        if (clazz == Short.class || clazz == Byte.class || clazz == Character.class) {
            return Math.max(Short.toString((short)Short.MIN_VALUE).length(), Short.toString((short)Short.MAX_VALUE).length());
        }
        return this.getMaxWidth();
    }
}

