/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class CoinsTableBuilder
implements TableBuilder {
    @Override
    public String getFormatName() {
        return "COINS";
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws IOException {
        return new CoinsStarTable(datsrc);
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        throw new TableFormatException("Can't stream ASCII format tables");
    }

    private static class CoinsStarTable
    extends StreamStarTable {
        private static final char DELIMITER = '@';

        public CoinsStarTable(DataSource datsrc) throws TableFormatException, IOException {
            this.init(datsrc);
        }

        @Override
        protected PushbackInputStream getInputStream() throws IOException {
            PushbackInputStream in = super.getInputStream();
            this.readRow(in);
            return in;
        }

        @Override
        protected RowEvaluator.Metadata obtainMetadata() throws TableFormatException, IOException {
            List row;
            PushbackInputStream in = super.getInputStream();
            if (in.read() != 255 || in.read() != 254) {
                throw new TableFormatException("Unexpected/bad BOM");
            }
            String[] colNames = this.readRow(in).toArray(new String[0]);
            RowEvaluator evaluator = new RowEvaluator();
            while ((row = this.readRow(in)) != null) {
                evaluator.submitRow(row);
            }
            in.close();
            RowEvaluator.Metadata meta = evaluator.getMetadata();
            if (meta.nrow_ == 0L) {
                throw new TableFormatException("No rows");
            }
            ColumnInfo[] colinfos = meta.colInfos_;
            RowEvaluator.Decoder[] decoders = meta.decoders_;
            int ncol = meta.ncol_;
            long nrow = meta.nrow_;
            for (int icol = 0; icol < ncol; ++icol) {
                colinfos[icol].setName(colNames[icol]);
            }
            return new RowEvaluator.Metadata(colinfos, decoders, nrow);
        }

        @Override
        protected List readRow(PushbackInputStream in) throws IOException {
            ArrayList<String> cellList = new ArrayList<String>();
            StringBuffer buffer = new StringBuffer();
            boolean endLine = false;
            block5: while (!endLine) {
                int c2;
                int c1 = in.read();
                int n = c2 = c1 >= 0 ? in.read() : -1;
                if (c1 < 0 || c2 < 0) {
                    return null;
                }
                char c = (char)(c1 | c2 << 8);
                switch (c) {
                    case '\r': {
                        continue block5;
                    }
                    case '\n': {
                        endLine = true;
                        if (cellList.size() <= 1) {
                            cellList.clear();
                        }
                    }
                    case '@': {
                        String str = buffer.toString();
                        buffer.setLength(0);
                        cellList.add("NULL".equals(str) ? null : str);
                        continue block5;
                    }
                }
                buffer.append(c);
            }
            return cellList.size() <= 1 ? null : cellList;
        }
    }
}

