/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class CsvStarTable
extends StreamStarTable {
    private boolean hasHeading_;

    public CsvStarTable(DataSource datsrc) throws TableFormatException, IOException {
        this.init(datsrc);
    }

    @Override
    protected PushbackInputStream getInputStream() throws IOException {
        PushbackInputStream in = super.getInputStream();
        if (this.hasHeading_) {
            this.readRow(in);
        }
        return in;
    }

    @Override
    protected RowEvaluator.Metadata obtainMetadata() throws TableFormatException, IOException {
        PushbackInputStream in = super.getInputStream();
        long lrow = 0L;
        String[] row0 = this.readRow(in).toArray(new String[0]);
        ++lrow;
        RowEvaluator evaluator = new RowEvaluator();
        try {
            List row;
            while ((row = this.readRow(in)) != null) {
                evaluator.submitRow(row);
                ++lrow;
            }
        }
        catch (TableFormatException e) {
            throw new TableFormatException(e.getMessage() + " at line " + (lrow + 1L), e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        RowEvaluator.Metadata meta = evaluator.getMetadata();
        if (meta.nrow_ == 0L) {
            throw new TableFormatException("No rows");
        }
        RowEvaluator.Decoder[] decoders = meta.decoders_;
        int ncol = meta.ncol_;
        if (row0.length == ncol) {
            boolean isDataRow = true;
            for (int icol = 0; icol < ncol; ++icol) {
                String cell = row0[icol];
                if (cell == null || cell.length() <= 0) continue;
                isDataRow = isDataRow && decoders[icol].isValid(cell);
            }
            if (isDataRow) {
                evaluator.submitRow(Arrays.asList(row0));
                return evaluator.getMetadata();
            }
            assert (!isDataRow);
            this.hasHeading_ = true;
            ColumnInfo[] colinfos = meta.colInfos_;
            for (int icol = 0; icol < ncol; ++icol) {
                String h = row0[icol];
                if (h == null || h.trim().length() <= 0) continue;
                colinfos[icol].setName(h);
            }
            return new RowEvaluator.Metadata(colinfos, decoders, meta.nrow_);
        }
        this.hasHeading_ = true;
        return meta;
    }

    @Override
    protected List readRow(PushbackInputStream in) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean discard = false;
        boolean endFile = false;
        while (cellList.size() == 0 && !endFile) {
            boolean endLine = false;
            block8: while (!endLine) {
                char c = (char)in.read();
                switch (c) {
                    case '\uffff': {
                        endFile = true;
                    }
                    case '\n': 
                    case '\r': {
                        boolean endLineChar = true;
                        while (endLineChar) {
                            int b = in.read();
                            endLineChar = b == 13 || b == 10;
                            if (endLineChar) continue;
                            in.unread(b);
                        }
                        if (discard) {
                            discard = false;
                        } else if (cellList.size() > 0 || !endFile) {
                            cellList.add(buffer.toString().trim());
                        }
                        buffer.setLength(0);
                        endLine = true;
                        continue block8;
                    }
                    case ',': {
                        if (discard) {
                            discard = false;
                        } else {
                            cellList.add(buffer.toString().trim());
                        }
                        buffer.setLength(0);
                        continue block8;
                    }
                    case '\"': {
                        if (buffer.toString().trim().length() > 0) {
                            throw new TableFormatException("Mixed quoted/unquoted cell '" + buffer + "'");
                        }
                        cellList.add(this.readString(in));
                        discard = true;
                        continue block8;
                    }
                    case '\t': 
                    case ' ': {
                        if (discard) continue block8;
                        buffer.append(c);
                        continue block8;
                    }
                }
                if (discard) {
                    throw new TableFormatException("Mixed quoted/unquoted cell '" + c + "'");
                }
                buffer.append(c);
            }
        }
        return cellList.size() == 0 ? null : cellList;
    }

    private String readString(PushbackInputStream in) throws IOException {
        StringBuffer buffer = new StringBuffer();
        block4: while (true) {
            char c = (char)in.read();
            switch (c) {
                case '\"': {
                    char c2 = (char)in.read();
                    if (c2 == '\"') {
                        buffer.append('\"');
                        continue block4;
                    }
                    if (c2 != '\uffff') {
                        in.unread(c2);
                    }
                    return buffer.toString();
                }
                case '\uffff': {
                    throw new TableFormatException("End of file within a string literal");
                }
            }
            buffer.append(c);
        }
    }
}

