/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.Tables;

public class CsvTableWriter
extends StreamStarTableWriter {
    private boolean writeHeader_ = true;
    private int maxFieldChars_ = Integer.MAX_VALUE;

    public CsvTableWriter() {
        this(true);
    }

    public CsvTableWriter(boolean writeHeader) {
        this.setWriteHeader(writeHeader);
    }

    public void setWriteHeader(boolean writeHeader) {
        this.writeHeader_ = writeHeader;
    }

    public boolean getWriteHeader() {
        return this.writeHeader_;
    }

    public void setMaxFieldChars(int maxFieldChars) {
        this.maxFieldChars_ = maxFieldChars;
    }

    public int getMaxFieldChars() {
        return this.maxFieldChars_;
    }

    @Override
    public String getFormatName() {
        return this.writeHeader_ ? "CSV" : "CSV-noheader";
    }

    @Override
    public String getMimeType() {
        return "text/csv; header=\"" + (this.writeHeader_ ? "present" : "absent") + "\"";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.endsWith(".csv") || location.endsWith(".CSV");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTable(StarTable table, OutputStream ostrm) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(ostrm);
        int ncol = table.getColumnCount();
        ColumnInfo[] cinfos = Tables.getColumnInfos(table);
        RowSequence rseq = table.getRowSequence();
        try {
            if (this.getWriteHeader()) {
                String[] headRow = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    headRow[icol] = cinfos[icol].getName();
                }
                this.writeRow(out, headRow);
            }
            String[] dataRow = new String[ncol];
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    dataRow[icol] = cinfos[icol].formatValue(row[icol], this.maxFieldChars_);
                }
                this.writeRow(out, dataRow);
            }
        }
        finally {
            ((Writer)out).flush();
            rseq.close();
        }
    }

    private void writeRow(Writer out, String[] row) throws IOException {
        int ncol = row.length;
        for (int icol = 0; icol < ncol; ++icol) {
            this.writeField(out, row[icol]);
            out.write(icol < ncol - 1 ? 44 : 10);
        }
    }

    private void writeField(Writer out, String value) throws IOException {
        int i;
        if (value == null || value.length() == 0) {
            return;
        }
        int nchar = value.length();
        boolean quoted = false;
        switch (value.charAt(0)) {
            case '\t': 
            case ' ': {
                quoted = true;
            }
        }
        switch (value.charAt(nchar - 1)) {
            case '\t': 
            case ' ': {
                quoted = true;
            }
        }
        for (i = 0; i < nchar && !quoted; ++i) {
            switch (value.charAt(i)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    quoted = true;
                }
            }
        }
        if (!quoted) {
            out.write(value);
        } else {
            out.write(34);
            for (i = 0; i < nchar; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\"': {
                        out.write(34);
                    }
                }
                out.write(c);
            }
            out.write(34);
        }
    }

    public static StarTableWriter[] getStarTableWriters() {
        return new StarTableWriter[]{new CsvTableWriter(true), new CsvTableWriter(false)};
    }
}

