/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.StreamStarTableWriter;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;

public class HTMLTableWriter
extends StreamStarTableWriter
implements MultiStarTableWriter {
    private boolean standalone_;
    private boolean useRowGroups_;

    public HTMLTableWriter() {
        this(true, true);
    }

    public HTMLTableWriter(boolean standalone, boolean useRowGroups) {
        this.setStandalone(standalone);
        this.useRowGroups_ = useRowGroups;
    }

    public void setStandalone(boolean standalone) {
        this.standalone_ = standalone;
    }

    public boolean isStandalone() {
        return this.standalone_;
    }

    @Override
    public String getFormatName() {
        return this.standalone_ ? "HTML" : "HTML-element";
    }

    @Override
    public String getMimeType() {
        return "text/html";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.endsWith(".html") || location.endsWith(".htm");
    }

    @Override
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        if (this.standalone_) {
            this.printHeader(out, table);
        }
        this.writeTableElement(table, out);
        if (this.standalone_) {
            this.printFooter(out);
        }
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        if (this.standalone_) {
            this.printHeader(out, null);
        }
        while ((table = tableSeq.nextTable()) != null) {
            this.printLine(out, "<P>");
            this.writeTableElement(table, out);
            this.printLine(out, "</P>");
        }
        if (this.standalone_) {
            this.printFooter(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        OutputStream out = sto.getOutputStream(location);
        try {
            out = new BufferedOutputStream(out);
            this.writeStarTables(tableSeq, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTableElement(StarTable table, OutputStream ostrm) throws IOException {
        RowSequence rseq = table.getRowSequence();
        try {
            String unit;
            this.printLine(ostrm, "<TABLE BORDER='1'>");
            String tname = table.getName();
            if (tname != null) {
                this.printLine(ostrm, "<CAPTION><STRONG>" + tname + "</STRONG></CAPTION>");
            }
            int ncol = table.getColumnCount();
            ColumnInfo[] colinfos = Tables.getColumnInfos(table);
            String[] names = new String[ncol];
            String[] units = new String[ncol];
            boolean hasUnits = false;
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo colinfo = colinfos[icol];
                String name = colinfo.getName();
                unit = colinfo.getUnitString();
                if (unit != null) {
                    hasUnits = true;
                    unit = "(" + unit + ")";
                }
                names[icol] = name;
                units[icol] = unit;
            }
            String[] headings = new String[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                String heading = names[icol];
                unit = units[icol];
                if (hasUnits) {
                    heading = heading + "<BR>";
                    if (unit != null) {
                        heading = heading + "(" + unit + ")";
                    }
                }
                headings[icol] = heading;
            }
            if (this.useRowGroups_) {
                this.printLine(ostrm, "<THEAD>");
            }
            this.outputRow(ostrm, "TH", null, names);
            if (hasUnits) {
                this.outputRow(ostrm, "TH", null, units);
            }
            this.printLine(ostrm, "<TR><TD colspan='" + ncol + "'></TD></TR>");
            if (this.useRowGroups_) {
                this.printLine(ostrm, "</THEAD>");
            }
            if (this.useRowGroups_) {
                this.printLine(ostrm, "<TBODY>");
            }
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                String[] cells = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    cells[icol] = colinfos[icol].formatValue(row[icol], 200);
                }
                this.outputRow(ostrm, "TD", null, cells);
            }
            if (this.useRowGroups_) {
                this.printLine(ostrm, "</TBODY>");
            }
            this.printLine(ostrm, "</TABLE>");
        }
        finally {
            rseq.close();
        }
    }

    public static StarTableWriter[] getStarTableWriters() {
        return new StarTableWriter[]{new HTMLTableWriter(true, true), new HTMLTableWriter(false, true)};
    }

    private void outputRow(OutputStream ostrm, String tagname, String attlist, String[] values) throws IOException {
        int ncol = values.length;
        this.printLine(ostrm, "<TR>");
        StringBuffer sbuf = new StringBuffer();
        for (int icol = 0; icol < ncol; ++icol) {
            String value;
            sbuf.append(' ').append('<').append(tagname);
            if (attlist != null) {
                sbuf.append(" " + attlist);
            }
            sbuf.append('>');
            String string = value = values[icol] == null ? null : this.escape(values[icol]);
            if (value == null || value.length() == 0) {
                sbuf.append("&nbsp;");
            } else if (this.isUrl(value)) {
                sbuf.append("<A href='").append(value).append("'>").append(value).append("</A>");
            } else {
                sbuf.append(value);
            }
            sbuf.append("</").append(tagname).append(">");
        }
        this.printLine(ostrm, sbuf.toString());
        this.printLine(ostrm, "</TR>");
    }

    private void printLine(OutputStream ostrm, String str) throws IOException {
        ostrm.write(str.getBytes());
        ostrm.write(10);
    }

    protected void printHeader(OutputStream ostrm, StarTable table) throws IOException {
        String tname;
        String publicId = this.useRowGroups_ ? "-//W3C//DTD HTML 4.01 Transitional//EN" : "-//W3C//DTD HTML 3.2 Final//EN";
        String declaration = "<!DOCTYPE HTML PUBLIC \"" + publicId + "\">";
        this.printLine(ostrm, declaration);
        this.printLine(ostrm, "<HTML>");
        String string = tname = table == null ? null : table.getName();
        if (tname != null && tname.trim().length() > 0) {
            this.printLine(ostrm, "<HEAD><TITLE>Table " + this.escape(tname) + "</TITLE></HEAD>");
        }
        this.printLine(ostrm, "<BODY>");
    }

    protected void printFooter(OutputStream ostrm) throws IOException {
        this.printLine(ostrm, "</BODY>");
        this.printLine(ostrm, "</HTML>");
    }

    private String escape(String line) {
        StringBuffer sbuf = new StringBuffer();
        block7: for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            switch (chr) {
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                default: {
                    sbuf.append(chr > '\u0000' && chr < '\u00fe' ? chr : (char)'?');
                }
            }
        }
        return sbuf.toString();
    }

    protected boolean isUrl(String txt) {
        if (txt.startsWith("http:") || txt.startsWith("ftp:") || txt.startsWith("mailto:")) {
            try {
                new URL(txt);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }
}

