/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.AbstractTextTableWriter;
import uk.ac.starlink.table.formats.IpacTableBuilder;

public class IpacTableWriter
extends AbstractTextTableWriter {
    public static String NULL = "null";

    public IpacTableWriter() {
        super(true);
    }

    @Override
    public String getFormatName() {
        return "IPAC";
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.endsWith(".tbl") || location.endsWith(".ipac");
    }

    @Override
    public int getMaxWidth() {
        return 1000;
    }

    @Override
    public int getMinNameWidth(ColumnInfo info) {
        return new IpacHead((ColumnInfo)info).name_.length();
    }

    @Override
    public String formatValue(Object val, ValueInfo info, int width) {
        return Tables.isBlank(val) ? NULL : info.formatValue(val, width);
    }

    @Override
    public void printColumnHeads(OutputStream out, int[] colwidths, ColumnInfo[] cinfos) throws IOException {
        int ncol = cinfos.length;
        IpacHead[] heads = new IpacHead[ncol];
        String[] names = new String[ncol];
        String[] types = new String[ncol];
        String[] units = new String[ncol];
        String[] nulls = new String[ncol];
        for (int ic = 0; ic < ncol; ++ic) {
            IpacHead head = new IpacHead(cinfos[ic]);
            names[ic] = head.name_;
            types[ic] = head.type_;
            units[ic] = head.unit_;
            nulls[ic] = NULL;
        }
        this.printIpacLine(out, colwidths, names, '|');
        this.printIpacLine(out, colwidths, types, '|');
        this.printIpacLine(out, colwidths, units, '|');
        this.printIpacLine(out, colwidths, nulls, '|');
    }

    @Override
    protected void printLine(OutputStream out, int[] colwidths, String[] data) throws IOException {
        this.printIpacLine(out, colwidths, data, ' ');
    }

    @Override
    protected void printSeparator(OutputStream out, int[] colwidths) {
    }

    private void printIpacLine(OutputStream out, int[] colwidths, String[] data, char sepChar) throws IOException {
        for (int ic = 0; ic < data.length; ++ic) {
            out.write(sepChar);
            out.write(32);
            String datum = data[ic] == null ? "" : data[ic];
            int padding = colwidths[ic] - datum.length();
            out.write(this.getBytes(datum), 0, Math.min(colwidths[ic], datum.length()));
            if (padding > 0) {
                for (int j = 0; j < padding; ++j) {
                    out.write(32);
                }
            }
            out.write(32);
        }
        out.write(sepChar);
        out.write(10);
    }

    @Override
    protected void printParam(OutputStream out, String name, String value, Class clazz) throws IOException {
        String[] lines = value.split("[\\n\\r]+");
        int maxl = 320;
        if (IpacTableBuilder.COMMENT_INFO.getName().equals(name)) {
            for (int il = 0; il < lines.length; ++il) {
                out.write(92);
                out.write(32);
                out.write(this.getBytes(this.truncateLine(lines[il], maxl)));
                out.write(10);
            }
        } else {
            out.write(92);
            out.write(this.getBytes(name.trim()));
            out.write(32);
            out.write(61);
            out.write(32);
            out.write(this.getBytes(clazz.equals(String.class) ? IpacTableWriter.quoteString(this.truncateLine(lines[0], maxl)) : value));
            out.write(10);
        }
    }

    @Override
    protected int getMaximumParameterLength() {
        return 100000;
    }

    private String truncateLine(String txt, int maxLeng) {
        return txt.length() > maxLeng ? txt.substring(0, maxLeng) : txt;
    }

    private static String quoteString(String raw) {
        boolean hasDouble;
        boolean hasSingle = raw.indexOf(39) >= 0;
        boolean bl = hasDouble = raw.indexOf(34) >= 0;
        if (!hasDouble) {
            return "\"" + raw + "\"";
        }
        if (!hasSingle) {
            return "'" + raw + "'";
        }
        return "\"" + raw.replaceAll("\"", "'") + "\"";
    }

    private static class IpacHead {
        final String name_;
        final String type_;
        final String unit_;

        IpacHead(ColumnInfo info) {
            Class clazz;
            String unit;
            String name = info.getName().trim().replaceAll("[^a-zA-Z0-9_]+", "_");
            if (name.length() > 40) {
                name = name.substring(0, 40);
            }
            if ((unit = info.getUnitString()) == null) {
                unit = "";
            }
            String type = (clazz = info.getContentClass()).equals(Integer.class) || clazz.equals(Short.class) || clazz.equals(Byte.class) ? "int" : (clazz.equals(Long.class) ? "long" : (clazz.equals(Double.class) ? "double" : (clazz.equals(Float.class) ? "float" : (clazz.equals(String.class) || clazz.equals(Character.class) ? "char" : "char"))));
            int width = 0;
            width = Math.max(width, type.length());
            width = Math.max(width, NULL.length());
            width = Math.max(width, unit.length());
            int npad = width - name.length();
            for (int i = 0; i < npad; ++i) {
                name = name + " ";
            }
            this.name_ = name;
            this.type_ = type;
            this.unit_ = unit;
        }
    }
}

