/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TimeMapper;

public class RowEvaluator {
    private boolean[] maybeBoolean_;
    private boolean[] maybeShort_;
    private boolean[] maybeInteger_;
    private boolean[] maybeLong_;
    private boolean[] maybeFloat_;
    private boolean[] maybeDouble_;
    private boolean[] maybeDate_;
    private boolean[] maybeHms_;
    private boolean[] maybeDms_;
    private int[] stringLength_;
    private long nrow_;
    private int ncol_ = -1;
    public static final Pattern ISO8601_REGEX = Pattern.compile("([0-9]+)-([0-9]{1,2})-([0-9]{1,2})(?:[T ]([0-9]{1,2})(?::([0-9]{1,2})(?::([0-9]{1,2}(?:\\.[0-9]*)?))?)?Z?)?");
    private static final Pattern HMS_REGEX = Pattern.compile("[ 012]?[0-9][:h ][ 0-6][0-9][:m ][0-6][0-9](\\.[0-9]*)?");
    private static final Pattern DMS_REGEX = Pattern.compile("[-+][ 0-9]?[0-9][:d ][ 0-6][0-9][:m ][0-6][0-9](\\.[0-9]*)?");
    private static final Pattern NAN_REGEX = Pattern.compile("NaN", 2);
    private static final Pattern INFINITY_REGEX = Pattern.compile("([+-]?)(Infinity|inf)", 2);
    private static Decoder BOOLEAN_DECODER = new Decoder(Boolean.class){

        @Override
        public Object decode(String value) {
            char v1 = value.trim().charAt(0);
            return v1 == 't' || v1 == 'T' ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public boolean isValid(String value) {
            return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("f") || value.equalsIgnoreCase("t");
        }
    };
    private static Decoder SHORT_DECODER = new Decoder(Short.class){

        @Override
        public Object decode(String value) {
            return new Short(Short.parseShort(value.trim()));
        }

        @Override
        public boolean isValid(String value) {
            try {
                return Short.parseShort(value) != 0 || value.charAt(0) != '-';
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Decoder INTEGER_DECODER = new Decoder(Integer.class){

        @Override
        public Object decode(String value) {
            return new Integer(Integer.parseInt(value.trim()));
        }

        @Override
        public boolean isValid(String value) {
            try {
                return Integer.parseInt(value) != 0 || value.charAt(0) != '-';
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Decoder LONG_DECODER = new Decoder(Long.class){

        @Override
        public Object decode(String value) {
            return new Long(Long.parseLong(value.trim()));
        }

        @Override
        public boolean isValid(String value) {
            try {
                return Long.parseLong(value) != 0L || value.charAt(0) != '-';
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Decoder FLOAT_DECODER = new Decoder(Float.class){

        @Override
        public Object decode(String value) {
            return new Float((float)RowEvaluator.parseFloating((String)value.trim()).dValue);
        }

        @Override
        public boolean isValid(String value) {
            try {
                ParsedFloat pf = RowEvaluator.parseFloating(value);
                return pf.sigFig <= 6 && (!Float.isInfinite((float)pf.dValue) || Double.isInfinite(pf.dValue));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Decoder DOUBLE_DECODER = new Decoder(Double.class){

        @Override
        public Object decode(String value) {
            return new Double(RowEvaluator.parseFloating((String)value.trim()).dValue);
        }

        @Override
        public boolean isValid(String value) {
            try {
                RowEvaluator.parseFloating(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Decoder DATE_DECODER = new StringDecoder(){

        @Override
        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setUnitString("iso-8601");
            info.setUCD("TIME");
            info.setDomainMappers(new DomainMapper[]{TimeMapper.ISO_8601});
            return info;
        }

        @Override
        public boolean isValid(String value) {
            return ISO8601_REGEX.matcher(value).matches();
        }
    };
    private static Decoder HMS_DECODER = new StringDecoder(){

        @Override
        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setUnitString("hms");
            return info;
        }

        @Override
        public boolean isValid(String value) {
            return HMS_REGEX.matcher(value).matches();
        }
    };
    private static Decoder DMS_DECODER = new StringDecoder(){

        @Override
        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setUnitString("dms");
            return info;
        }

        @Override
        public boolean isValid(String value) {
            return DMS_REGEX.matcher(value).matches();
        }
    };
    private static Decoder STRING_DECODER = new StringDecoder(){

        @Override
        public boolean isValid(String value) {
            return true;
        }
    };

    public RowEvaluator() {
    }

    public RowEvaluator(int ncol) {
        this.init(ncol);
    }

    private void init(int ncol) {
        this.ncol_ = ncol;
        this.maybeBoolean_ = this.makeFlagArray(true);
        this.maybeShort_ = this.makeFlagArray(true);
        this.maybeInteger_ = this.makeFlagArray(true);
        this.maybeLong_ = this.makeFlagArray(true);
        this.maybeFloat_ = this.makeFlagArray(true);
        this.maybeDouble_ = this.makeFlagArray(true);
        this.maybeDate_ = this.makeFlagArray(true);
        this.maybeHms_ = this.makeFlagArray(true);
        this.maybeDms_ = this.makeFlagArray(true);
        this.stringLength_ = new int[ncol];
    }

    public void submitRow(List row) throws TableFormatException {
        ++this.nrow_;
        if (this.ncol_ < 0) {
            this.init(row.size());
        }
        if (row.size() != this.ncol_) {
            throw new TableFormatException("Wrong number of columns at row " + this.nrow_ + " (expecting " + this.ncol_ + ", found " + row.size() + ")");
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            boolean done = false;
            String cell0 = (String)row.get(icol);
            int leng0 = cell0 == null ? 0 : cell0.length();
            String cell = cell0 == null ? "" : cell0.trim();
            int leng = cell.length();
            if (leng == 0) {
                done = true;
            }
            if (leng0 > this.stringLength_[icol]) {
                this.stringLength_[icol] = leng0;
            }
            if (!done && this.maybeBoolean_[icol]) {
                if (BOOLEAN_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeBoolean_[icol] = false;
                }
            }
            if (!done && this.maybeShort_[icol]) {
                if (SHORT_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeShort_[icol] = false;
                }
            }
            if (!done && this.maybeInteger_[icol]) {
                if (INTEGER_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeInteger_[icol] = false;
                }
            }
            if (!done && this.maybeLong_[icol]) {
                if (LONG_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeLong_[icol] = false;
                }
            }
            if (!done && this.maybeFloat_[icol]) {
                if (FLOAT_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeFloat_[icol] = false;
                }
            }
            if (!done && this.maybeDouble_[icol]) {
                if (DOUBLE_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeDouble_[icol] = false;
                }
            }
            if (!done && this.maybeDate_[icol]) {
                if (DATE_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeDate_[icol] = false;
                }
            }
            if (!done && this.maybeHms_[icol]) {
                if (HMS_DECODER.isValid(cell)) {
                    done = true;
                } else {
                    this.maybeHms_[icol] = false;
                }
            }
            if (done || !this.maybeDms_[icol]) continue;
            if (DMS_DECODER.isValid(cell)) {
                done = true;
                continue;
            }
            this.maybeDms_[icol] = false;
        }
    }

    public Metadata getMetadata() {
        ColumnInfo[] colInfos = new ColumnInfo[this.ncol_];
        Decoder[] decoders = new Decoder[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String name = "col" + (icol + 1);
            Decoder decoder = this.maybeBoolean_[icol] ? BOOLEAN_DECODER : (this.maybeShort_[icol] ? SHORT_DECODER : (this.maybeInteger_[icol] ? INTEGER_DECODER : (this.maybeLong_[icol] ? LONG_DECODER : (this.maybeFloat_[icol] ? FLOAT_DECODER : (this.maybeDouble_[icol] ? DOUBLE_DECODER : (this.maybeDate_[icol] ? DATE_DECODER : (this.maybeHms_[icol] ? HMS_DECODER : (this.maybeDms_[icol] ? DMS_DECODER : STRING_DECODER))))))));
            decoders[icol] = decoder;
            ColumnInfo info = decoder.createColumnInfo(name);
            if (decoder instanceof StringDecoder) {
                info.setElementSize(this.stringLength_[icol]);
            }
            colInfos[icol] = info;
        }
        return new Metadata(colInfos, decoders, this.nrow_);
    }

    private boolean[] makeFlagArray(boolean val) {
        boolean[] flags = new boolean[this.ncol_];
        Arrays.fill(flags, val);
        return flags;
    }

    private static ParsedFloat parseFloating(String item) {
        if (NAN_REGEX.matcher(item).matches()) {
            return ParsedFloat.NaN;
        }
        Matcher infMatcher = INFINITY_REGEX.matcher(item);
        if (infMatcher.matches()) {
            String sign = infMatcher.group(1);
            return sign.length() > 0 && sign.charAt(0) == '-' ? ParsedFloat.NEGATIVE_INFINITY : ParsedFloat.POSITIVE_INFINITY;
        }
        int nc = item.length();
        boolean foundExp = false;
        int sigFig = 0;
        block5: for (int i = 0; i < nc; ++i) {
            char c = item.charAt(i);
            switch (c) {
                case 'D': 
                case 'd': {
                    if (!foundExp) {
                        StringBuffer sbuf = new StringBuffer(item);
                        sbuf.setCharAt(i, 'e');
                        item = sbuf.toString();
                    }
                    foundExp = true;
                    continue block5;
                }
                case 'E': 
                case 'e': {
                    foundExp = true;
                    continue block5;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (foundExp) continue block5;
                    ++sigFig;
                    continue block5;
                }
            }
        }
        double dvalue = Double.parseDouble(item);
        return new ParsedFloat(sigFig, dvalue);
    }

    private static class ParsedFloat {
        final int sigFig;
        final double dValue;
        static final ParsedFloat NaN = new ParsedFloat(0, Double.NaN);
        static final ParsedFloat POSITIVE_INFINITY = new ParsedFloat(0, Double.POSITIVE_INFINITY);
        static final ParsedFloat NEGATIVE_INFINITY = new ParsedFloat(0, Double.NEGATIVE_INFINITY);

        ParsedFloat(int sigFig, double dValue) {
            this.sigFig = sigFig;
            this.dValue = dValue;
        }
    }

    private static abstract class StringDecoder
    extends Decoder {
        StringDecoder() {
            super(String.class);
        }

        @Override
        public Object decode(String value) {
            return value;
        }
    }

    public static abstract class Decoder {
        private final Class clazz_;

        public Decoder(Class clazz) {
            this.clazz_ = clazz;
        }

        public ColumnInfo createColumnInfo(String name) {
            return new ColumnInfo(name, this.clazz_, null);
        }

        public abstract Object decode(String var1);

        public abstract boolean isValid(String var1);
    }

    public static class Metadata {
        public final ColumnInfo[] colInfos_;
        public final Decoder[] decoders_;
        public final long nrow_;
        public final int ncol_;

        public Metadata(ColumnInfo[] colInfos, Decoder[] decoders, long nrow) {
            this.colInfos_ = colInfos;
            this.decoders_ = decoders;
            this.nrow_ = nrow;
            if (this.colInfos_.length != this.decoders_.length) {
                throw new IllegalArgumentException();
            }
            this.ncol_ = this.colInfos_.length;
        }
    }
}

