/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.formats.AbstractTextTableWriter;

public class TextTableWriter
extends AbstractTextTableWriter
implements MultiStarTableWriter {
    public TextTableWriter() {
        super(true);
    }

    @Override
    public String getFormatName() {
        return "text";
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.equals("-");
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        StarTable table;
        int ix = 0;
        while ((table = tableSeq.nextTable()) != null) {
            if (ix > 0) {
                out.write(10);
            }
            this.writeStarTable(table, out);
            ++ix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        OutputStream out = sto.getOutputStream(location);
        try {
            out = new BufferedOutputStream(out);
            this.writeStarTables(tableSeq, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    @Override
    public int getMaxWidth() {
        return 40;
    }

    @Override
    protected String formatValue(Object val, ValueInfo vinfo, int width) {
        return vinfo.formatValue(val, width);
    }

    @Override
    protected void printSeparator(OutputStream strm, int[] colwidths) throws IOException {
        for (int i = 0; i < colwidths.length; ++i) {
            strm.write(43);
            strm.write(45);
            for (int j = 0; j < colwidths[i]; ++j) {
                strm.write(45);
            }
            strm.write(45);
        }
        strm.write(43);
        strm.write(10);
    }

    @Override
    protected void printColumnHeads(OutputStream strm, int[] colwidths, ColumnInfo[] cinfos) throws IOException {
        int ncol = cinfos.length;
        String[] heads = new String[ncol];
        for (int i = 0; i < ncol; ++i) {
            heads[i] = cinfos[i].getName();
        }
        this.printSeparator(strm, colwidths);
        this.printLine(strm, colwidths, heads);
        this.printSeparator(strm, colwidths);
    }

    @Override
    protected void printLine(OutputStream strm, int[] colwidths, String[] data) throws IOException {
        for (int i = 0; i < colwidths.length; ++i) {
            strm.write(124);
            strm.write(32);
            String datum = data[i] == null ? "" : data[i];
            int padding = colwidths[i] - datum.length();
            strm.write(this.getBytes(datum), 0, Math.min(colwidths[i], datum.length()));
            if (padding > 0) {
                for (int j = 0; j < padding; ++j) {
                    strm.write(32);
                }
            }
            strm.write(32);
        }
        strm.write(124);
        strm.write(10);
    }

    @Override
    protected void printParam(OutputStream strm, String name, String value, Class clazz) throws IOException {
        strm.write(this.getBytes(name));
        strm.write(58);
        strm.write(32);
        strm.write(this.getBytes(value));
        strm.write(10);
    }
}

